/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.filter;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.geoserver.security.config.BasicAuthenticationFilterConfig;
import org.geoserver.security.config.SecurityNamedServiceConfig;
import org.geoserver.security.filter.AuthenticationCachingFilter;
import org.geoserver.security.filter.GeoServerAuthenticationFilter;
import org.geoserver.security.filter.GeoServerCompositeFilter;
import org.geoserver.security.filter.GeoServerWebAuthenticationDetailsSource;
import org.springframework.security.authentication.AuthenticationDetailsSource;
import org.springframework.security.crypto.codec.Hex;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.authentication.www.BasicAuthenticationEntryPoint;
import org.springframework.security.web.authentication.www.BasicAuthenticationFilter;

public class GeoServerBasicAuthenticationFilter
extends GeoServerCompositeFilter
implements AuthenticationCachingFilter,
GeoServerAuthenticationFilter {
    private BasicAuthenticationEntryPoint aep;
    private MessageDigest digest;

    @Override
    public void initializeFromConfig(SecurityNamedServiceConfig config) throws IOException {
        super.initializeFromConfig(config);
        try {
            this.digest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("No MD5 algorithm available!");
        }
        this.aep = new BasicAuthenticationEntryPoint();
        this.aep.setRealmName("GeoServer Realm");
        try {
            this.aep.afterPropertiesSet();
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        BasicAuthenticationFilterConfig authConfig = (BasicAuthenticationFilterConfig)config;
        BasicAuthenticationFilter filter = new BasicAuthenticationFilter(this.getSecurityManager().authenticationManager(), (AuthenticationEntryPoint)this.aep);
        if (authConfig.isUseRememberMe()) {
            filter.setRememberMeServices(this.securityManager.getRememberMeService());
            GeoServerWebAuthenticationDetailsSource s = new GeoServerWebAuthenticationDetailsSource();
            filter.setAuthenticationDetailsSource((AuthenticationDetailsSource)s);
        }
        filter.afterPropertiesSet();
        this.getNestedFilters().add((Filter)filter);
    }

    @Override
    public AuthenticationEntryPoint getAuthenticationEntryPoint() {
        return this.aep;
    }

    @Override
    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        req.setAttribute("_AUTHENTICATION_ENTRY_POINT_HEADER", (Object)this.aep);
        super.doFilter(req, res, chain);
    }

    @Override
    public String getCacheKey(HttpServletRequest request) {
        if (request.getSession(false) != null) {
            return null;
        }
        String header = request.getHeader("Authorization");
        if (header != null && header.startsWith("Basic ")) {
            byte[] base64Token = null;
            base64Token = header.substring(6).getBytes(StandardCharsets.UTF_8);
            String token = new String(Base64.getDecoder().decode(base64Token));
            String username = "";
            String password = "";
            int delim = token.indexOf(":");
            if (delim == -1) {
                return null;
            }
            username = token.substring(0, delim);
            password = token.substring(delim + 1);
            if ("root".equals(username)) {
                return null;
            }
            StringBuffer buff = new StringBuffer(password);
            buff.append(":");
            buff.append(this.getName());
            String digestString = null;
            try {
                MessageDigest md = (MessageDigest)this.digest.clone();
                digestString = String.valueOf(Hex.encode((byte[])md.digest(buff.toString().getBytes(StandardCharsets.UTF_8))));
            }
            catch (CloneNotSupportedException e) {
                throw new RuntimeException(e);
            }
            buff = new StringBuffer(username);
            buff.append(":");
            buff.append(digestString);
            return buff.toString();
        }
        return null;
    }

    @Override
    public boolean applicableForHtml() {
        return true;
    }

    @Override
    public boolean applicableForServices() {
        return true;
    }
}

