/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.filter;

import java.io.IOException;
import java.util.Collection;
import javax.servlet.http.HttpServletRequest;
import org.geoserver.security.GeoServerRoleConverter;
import org.geoserver.security.GeoServerUserGroupService;
import org.geoserver.security.config.PreAuthenticatedUserNameFilterConfig;
import org.geoserver.security.config.RoleSource;
import org.geoserver.security.config.SecurityNamedServiceConfig;
import org.geoserver.security.filter.GeoServerPreAuthenticationFilter;
import org.geoserver.security.filter.GeoServerRoleResolvers;
import org.geoserver.security.impl.GeoServerRole;
import org.geoserver.security.impl.GeoServerUser;

public abstract class GeoServerPreAuthenticatedUserNameFilter
extends GeoServerPreAuthenticationFilter
implements GeoServerRoleResolvers.ResolverContext {
    private RoleSource roleSource;
    private String rolesHeaderAttribute;
    private String userGroupServiceName;
    private String roleConverterName;
    private String roleServiceName;
    private GeoServerRoleConverter converter;
    protected static final String UserNameAlreadyRetrieved = "org.geoserver.security.filter.usernameAlreadyRetrieved";
    protected static final String UserName = "org.geoserver.security.filter.username";

    @Override
    public RoleSource getRoleSource() {
        return this.roleSource;
    }

    public void setRoleSource(RoleSource roleSource) {
        this.roleSource = roleSource;
    }

    @Override
    public String getRolesHeaderAttribute() {
        return this.rolesHeaderAttribute;
    }

    public void setRolesHeaderAttribute(String rolesHeaderAttribute) {
        this.rolesHeaderAttribute = rolesHeaderAttribute;
    }

    @Override
    public String getUserGroupServiceName() {
        return this.userGroupServiceName;
    }

    public void setUserGroupServiceName(String userGroupServiceName) {
        this.userGroupServiceName = userGroupServiceName;
    }

    public String getRoleConverterName() {
        return this.roleConverterName;
    }

    public void setRoleConverterName(String roleConverterName) {
        this.roleConverterName = roleConverterName;
    }

    @Override
    public String getRoleServiceName() {
        return this.roleServiceName;
    }

    public void setRoleServiceName(String roleServiceName) {
        this.roleServiceName = roleServiceName;
    }

    @Override
    public void initializeFromConfig(SecurityNamedServiceConfig config) throws IOException {
        super.initializeFromConfig(config);
        PreAuthenticatedUserNameFilterConfig authConfig = (PreAuthenticatedUserNameFilterConfig)config;
        this.roleSource = authConfig.getRoleSource();
        this.rolesHeaderAttribute = authConfig.getRolesHeaderAttribute();
        this.userGroupServiceName = authConfig.getUserGroupServiceName();
        this.roleConverterName = authConfig.getRoleConverterName();
        this.roleServiceName = authConfig.getRoleServiceName();
        if (PreAuthenticatedUserNameFilterConfig.PreAuthenticatedUserNameRoleSource.Header.equals(this.getRoleSource())) {
            String converterName = authConfig.getRoleConverterName();
            GeoServerRoleConverter lConverter = GeoServerRoleResolvers.loadConverter(converterName);
            this.setConverter(lConverter);
        }
    }

    @Override
    protected String getPreAuthenticatedPrincipal(HttpServletRequest request) {
        if (request.getAttribute(UserNameAlreadyRetrieved) != null) {
            return (String)request.getAttribute(UserName);
        }
        String principal = this.getPreAuthenticatedPrincipalName(request);
        if (principal != null && principal.trim().isEmpty()) {
            principal = null;
        }
        try {
            GeoServerUserGroupService service;
            GeoServerUser u;
            if (principal != null && PreAuthenticatedUserNameFilterConfig.PreAuthenticatedUserNameRoleSource.UserGroupService.equals(this.getRoleSource()) && (u = (service = this.getSecurityManager().loadUserGroupService(this.getUserGroupServiceName())).getUserByUsername(principal)) != null && !u.isEnabled()) {
                principal = null;
                this.handleDisabledUser(u, request);
            }
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        request.setAttribute(UserNameAlreadyRetrieved, (Object)Boolean.TRUE);
        if (principal != null) {
            request.setAttribute(UserName, (Object)principal);
        }
        return principal;
    }

    protected void handleDisabledUser(GeoServerUser u, HttpServletRequest request) {
    }

    @Override
    protected Collection<GeoServerRole> getRoles(HttpServletRequest request, String principal) throws IOException {
        GeoServerRoleResolvers.RoleResolver lResolver = GeoServerRoleResolvers.PRE_AUTH_ROLE_SOURCE_RESOLVER;
        Collection roles = (Collection)lResolver.convert(new GeoServerRoleResolvers.ResolverParam(principal, request, this));
        return roles;
    }

    @Override
    public String getCacheKey(HttpServletRequest request) {
        if (PreAuthenticatedUserNameFilterConfig.PreAuthenticatedUserNameRoleSource.Header.equals(this.getRoleSource())) {
            return null;
        }
        return super.getCacheKey(request);
    }

    @Override
    public GeoServerRoleConverter getConverter() {
        return this.converter;
    }

    public void setConverter(GeoServerRoleConverter converter) {
        this.converter = converter;
    }

    protected abstract String getPreAuthenticatedPrincipalName(HttpServletRequest var1);
}

