/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.filter;

import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.geoserver.security.config.RequestHeaderAuthenticationFilterConfig;
import org.geoserver.security.config.SecurityNamedServiceConfig;
import org.geoserver.security.filter.GeoServerPreAuthenticatedUserNameFilter;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.web.authentication.preauth.PreAuthenticatedAuthenticationToken;

public class GeoServerRequestHeaderAuthenticationFilter
extends GeoServerPreAuthenticatedUserNameFilter {
    private String principalHeaderAttribute;

    public String getPrincipalHeaderAttribute() {
        return this.principalHeaderAttribute;
    }

    public void setPrincipalHeaderAttribute(String principalHeaderAttribute) {
        this.principalHeaderAttribute = principalHeaderAttribute;
    }

    @Override
    public void initializeFromConfig(SecurityNamedServiceConfig config) throws IOException {
        super.initializeFromConfig(config);
        RequestHeaderAuthenticationFilterConfig authConfig = (RequestHeaderAuthenticationFilterConfig)config;
        this.setPrincipalHeaderAttribute(authConfig.getPrincipalHeaderAttribute());
    }

    @Override
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        String principalName = this.getPreAuthenticatedPrincipalName((HttpServletRequest)request);
        Authentication preAuth = SecurityContextHolder.getContext().getAuthentication();
        if (preAuth instanceof PreAuthenticatedAuthenticationToken && (null == principalName || !principalName.equals(preAuth.getPrincipal().toString()))) {
            SecurityContextHolder.clearContext();
        }
        super.doFilter(request, response, chain);
    }

    @Override
    protected String getPreAuthenticatedPrincipalName(HttpServletRequest request) {
        return request.getHeader(this.getPrincipalHeaderAttribute());
    }
}

