/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.filter;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.platform.exception.GeoServerRuntimException;
import org.geoserver.security.GeoServerRoleConverter;
import org.geoserver.security.GeoServerRoleService;
import org.geoserver.security.GeoServerSecurityManager;
import org.geoserver.security.GeoServerUserGroupService;
import org.geoserver.security.config.PreAuthenticatedUserNameFilterConfig;
import org.geoserver.security.config.RoleSource;
import org.geoserver.security.impl.GeoServerRole;
import org.geoserver.security.impl.RoleCalculator;
import org.geotools.util.logging.Logging;
import org.springframework.core.convert.converter.Converter;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.util.StringUtils;

public class GeoServerRoleResolvers {
    private static final Logger LOGGER = Logging.getLogger(GeoServerRoleResolvers.class);
    public static final RoleResolver ROLE_SERVICE_RESOLVER = p -> {
        boolean useActiveService = p.getRoleServiceName() == null || p.getRoleServiceName().trim().isEmpty();
        try {
            GeoServerRoleService service = useActiveService ? p.getSecurityManager().getActiveRoleService() : p.getSecurityManager().loadRoleService(p.getRoleServiceName());
            RoleCalculator calc = new RoleCalculator(service);
            return calc.calculateRoles(p.principal);
        }
        catch (IOException e) {
            throw new GeoServerRuntimException("Failed to load roles for user '" + p.principal + "' from roleService '" + p.getRoleServiceName() + "'.", (Throwable)e);
        }
    };
    public static final RoleResolver USER_GROUP_SERVICE_RESOLVER = p -> {
        GeoServerUserGroupService service;
        ArrayList<GeoServerRole> roles = new ArrayList<GeoServerRole>();
        try {
            service = p.getSecurityManager().loadUserGroupService(p.getUserGroupServiceName());
        }
        catch (IOException e) {
            throw new GeoServerRuntimException("Failed to load roles for user '" + p.principal + "' from userGroupService '" + p.getUserGroupServiceName() + "'.", (Throwable)e);
        }
        UserDetails details = null;
        try {
            details = service.loadUserByUsername(p.principal);
        }
        catch (UsernameNotFoundException ex) {
            LOGGER.log(Level.WARNING, "User " + p.principal + " not found in " + p.getUserGroupServiceName());
        }
        if (details != null) {
            for (GrantedAuthority auth : details.getAuthorities()) {
                roles.add((GeoServerRole)auth);
            }
        }
        return roles;
    };
    public static final RoleResolver HTTP_HEADER_RESOLVER = p -> {
        if (p.getRequest() == null) {
            throw new GeoServerRuntimException("Resolving roles from HTTP headers failed. Request not available.");
        }
        ArrayList<GeoServerRole> roles = new ArrayList<GeoServerRole>();
        String rolesString = p.getRequest().getHeader(p.getRolesHeaderAttribute());
        if (rolesString == null || rolesString.trim().isEmpty()) {
            LOGGER.log(Level.WARNING, "No roles in header attribute: " + p.getRolesHeaderAttribute());
            return roles;
        }
        roles.addAll(p.getConverter().convertRolesFromString(rolesString, p.principal));
        LOGGER.log(Level.FINE, "for principal " + p.principal + " found roles " + StringUtils.collectionToCommaDelimitedString(roles) + " in header " + p.getRolesHeaderAttribute());
        return roles;
    };
    public static final RoleResolver PRE_AUTH_ROLE_SOURCE_RESOLVER = p -> {
        Collection roles;
        RoleSource rs = p.getRoleSource();
        if (PreAuthenticatedUserNameFilterConfig.PreAuthenticatedUserNameRoleSource.RoleService.equals(rs)) {
            roles = (Collection)ROLE_SERVICE_RESOLVER.convert(p);
        } else if (PreAuthenticatedUserNameFilterConfig.PreAuthenticatedUserNameRoleSource.UserGroupService.equals(rs)) {
            roles = (Collection)USER_GROUP_SERVICE_RESOLVER.convert(p);
        } else if (PreAuthenticatedUserNameFilterConfig.PreAuthenticatedUserNameRoleSource.Header.equals(rs)) {
            roles = (Collection)HTTP_HEADER_RESOLVER.convert(p);
        } else {
            String lMsg = "Couldn't determine roles based on the specified role source %s.";
            throw new RuntimeException(String.format(lMsg, rs));
        }
        String lMsg = "Got roles {0} from {1} for principal {2}";
        LOGGER.log(Level.FINE, lMsg, new Object[]{roles, rs, p.principal});
        return roles;
    };

    public static GeoServerRoleConverter loadConverter(String pName) {
        GeoServerRoleConverter lConverter = pName == null || pName.isEmpty() ? (GeoServerRoleConverter)GeoServerExtensions.bean(GeoServerRoleConverter.class) : (GeoServerRoleConverter)GeoServerExtensions.bean((String)pName);
        return lConverter;
    }

    public static class ResolverParam {
        private final String principal;
        private final HttpServletRequest request;
        private final ResolverContext context;

        public ResolverParam(String pPrincipal, HttpServletRequest pRequest, ResolverContext pContext) {
            this.principal = pPrincipal;
            this.request = pRequest;
            this.context = pContext;
        }

        public GeoServerSecurityManager getSecurityManager() {
            return this.context.getSecurityManager();
        }

        public String getRoleServiceName() {
            return this.context.getRoleServiceName();
        }

        public String getUserGroupServiceName() {
            return this.context.getUserGroupServiceName();
        }

        public String getRolesHeaderAttribute() {
            return this.context.getRolesHeaderAttribute();
        }

        public GeoServerRoleConverter getConverter() {
            return this.context.getConverter();
        }

        public RoleSource getRoleSource() {
            return this.context.getRoleSource();
        }

        public String getPrincipal() {
            return this.principal;
        }

        public HttpServletRequest getRequest() {
            return this.request;
        }

        public ResolverContext getContext() {
            return this.context;
        }
    }

    public static interface RoleResolver
    extends Converter<ResolverParam, Collection<GeoServerRole>> {
    }

    public static class DefaultResolverContext
    implements ResolverContext {
        private GeoServerSecurityManager securityManager;
        private String roleServiceName;
        private String userGroupServiceName;
        private String rolesHeaderAttribute;
        private GeoServerRoleConverter converter;
        private RoleSource roleSource;

        public DefaultResolverContext(GeoServerSecurityManager pSecurityManager, String pRoleServiceName, String pUserGroupServiceName, String pRolesHeaderAttribute, GeoServerRoleConverter pConverter, RoleSource pRoleSource) {
            this.securityManager = pSecurityManager;
            this.roleServiceName = pRoleServiceName;
            this.userGroupServiceName = pUserGroupServiceName;
            this.rolesHeaderAttribute = pRolesHeaderAttribute;
            this.converter = pConverter;
            this.roleSource = pRoleSource;
        }

        @Override
        public GeoServerSecurityManager getSecurityManager() {
            return this.securityManager;
        }

        @Override
        public String getRoleServiceName() {
            return this.roleServiceName;
        }

        @Override
        public String getUserGroupServiceName() {
            return this.userGroupServiceName;
        }

        @Override
        public String getRolesHeaderAttribute() {
            return this.rolesHeaderAttribute;
        }

        @Override
        public GeoServerRoleConverter getConverter() {
            return this.converter;
        }

        @Override
        public RoleSource getRoleSource() {
            return this.roleSource;
        }
    }

    public static interface ResolverContext {
        public GeoServerSecurityManager getSecurityManager();

        public String getRoleServiceName();

        public String getUserGroupServiceName();

        public String getRolesHeaderAttribute();

        public GeoServerRoleConverter getConverter();

        public RoleSource getRoleSource();
    }
}

