/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.filter;

import java.io.IOException;
import java.util.HashMap;
import java.util.logging.Level;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.geoserver.ows.util.ResponseUtils;
import org.geoserver.security.config.SSLFilterConfig;
import org.geoserver.security.config.SecurityNamedServiceConfig;
import org.geoserver.security.filter.GeoServerSecurityFilter;

public class GeoServerSSLFilter
extends GeoServerSecurityFilter {
    protected Integer sslPort;

    @Override
    public void initializeFromConfig(SecurityNamedServiceConfig config) throws IOException {
        super.initializeFromConfig(config);
        SSLFilterConfig sslConfig = (SSLFilterConfig)config;
        this.sslPort = sslConfig.getSslPort();
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (request.isSecure()) {
            chain.doFilter(request, response);
            return;
        }
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        StringBuffer buff = new StringBuffer("https://");
        buff.append(httpRequest.getServerName()).append(":").append(this.sslPort).append(httpRequest.getContextPath()).append(httpRequest.getServletPath());
        HashMap<String, String> kvp = new HashMap<String, String>();
        if (httpRequest.getQueryString() != null) {
            for (String kvpString : httpRequest.getQueryString().split("&")) {
                String[] kvpArray = kvpString.split("=");
                if (kvpArray == null || kvpArray.length != 2) {
                    LOGGER.warning("Unknown query parameter: " + kvpString);
                    continue;
                }
                kvp.put(kvpArray[0], kvpArray[1]);
            }
        }
        String redirectURL = ResponseUtils.buildURL((String)buff.toString(), (String)httpRequest.getPathInfo(), kvp, null);
        if (LOGGER.isLoggable(Level.INFO)) {
            LOGGER.info("Redirecting " + String.valueOf(httpRequest.getRequestURL()) + " to " + redirectURL);
        }
        ((HttpServletResponse)response).sendRedirect(redirectURL);
    }
}

