/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.impl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.logging.Logger;
import org.geoserver.platform.resource.Resource;
import org.geoserver.security.GeoServerRoleService;
import org.geoserver.security.GeoServerRoleStore;
import org.geoserver.security.GeoServerSecurityManager;
import org.geoserver.security.config.SecurityNamedServiceConfig;
import org.geoserver.security.event.RoleLoadedListener;
import org.geoserver.security.impl.AbstractRoleService;
import org.geoserver.security.impl.GeoServerRole;
import org.geoserver.security.impl.RoleHierarchyHelper;
import org.geoserver.security.impl.RoleStoreHelper;
import org.geotools.util.logging.Logging;

public abstract class AbstractRoleStore
implements GeoServerRoleStore {
    static Logger LOGGER = Logging.getLogger((String)"org.geoserver.security");
    private boolean modified = false;
    protected AbstractRoleService service;
    protected RoleStoreHelper helper = new RoleStoreHelper();

    @Override
    public String getName() {
        return this.service.getName();
    }

    @Override
    public void setName(String name) {
        this.service.setName(name);
    }

    @Override
    public GeoServerSecurityManager getSecurityManager() {
        return this.service.getSecurityManager();
    }

    @Override
    public void setSecurityManager(GeoServerSecurityManager securityManager) {
        this.service.setSecurityManager(securityManager);
    }

    @Override
    public boolean canCreateStore() {
        return this.service.canCreateStore();
    }

    @Override
    public GeoServerRole getAdminRole() {
        return this.service.getAdminRole();
    }

    @Override
    public GeoServerRole getGroupAdminRole() {
        return this.service.getGroupAdminRole();
    }

    @Override
    public GeoServerRoleStore createStore() throws IOException {
        return this.service.createStore();
    }

    @Override
    public void registerRoleLoadedListener(RoleLoadedListener listener) {
        this.service.registerRoleLoadedListener(listener);
    }

    @Override
    public void unregisterRoleLoadedListener(RoleLoadedListener listener) {
        this.service.unregisterRoleLoadedListener(listener);
    }

    @Override
    public GeoServerRole createRoleObject(String role) throws IOException {
        return this.service.createRoleObject(role);
    }

    public Resource getConfigRoot() throws IOException {
        return this.service.getConfigRoot();
    }

    @Override
    public boolean isModified() {
        return this.modified;
    }

    public void setModified(Boolean value) {
        this.modified = value;
    }

    @Override
    public void addRole(GeoServerRole role) throws IOException {
        if (this.helper.roleMap.containsKey(role.getAuthority())) {
            throw new IllegalArgumentException("The role " + role.getAuthority() + " already exists");
        }
        this.helper.roleMap.put(role.getAuthority(), role);
        this.setModified(true);
    }

    @Override
    public void updateRole(GeoServerRole role) throws IOException {
        if (!this.helper.roleMap.containsKey(role.getAuthority())) {
            throw new IllegalArgumentException("The role " + role.getAuthority() + " does not exist");
        }
        this.helper.roleMap.put(role.getAuthority(), role);
        this.setModified(true);
    }

    @Override
    public boolean removeRole(GeoServerRole role) throws IOException {
        if (!this.helper.roleMap.containsKey(role.getAuthority())) {
            return false;
        }
        for (SortedSet<GeoServerRole> set : this.helper.user_roleMap.values()) {
            set.remove(role);
        }
        for (SortedSet<GeoServerRole> set : this.helper.group_roleMap.values()) {
            set.remove(role);
        }
        this.helper.role_parentMap.remove(role);
        HashSet<GeoServerRole> toBeRemoved = new HashSet<GeoServerRole>();
        for (Map.Entry<GeoServerRole, GeoServerRole> entry : this.helper.role_parentMap.entrySet()) {
            if (!role.equals(entry.getValue())) continue;
            toBeRemoved.add(entry.getKey());
        }
        for (GeoServerRole ga : toBeRemoved) {
            this.helper.role_parentMap.put(ga, null);
        }
        this.helper.roleMap.remove(role.getAuthority());
        this.setModified(true);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void store() throws IOException {
        if (this.isModified()) {
            LOGGER.info("Start storing roles for service named " + this.getName());
            AbstractRoleService abstractRoleService = this.service;
            synchronized (abstractRoleService) {
                this.serialize();
            }
            this.setModified(false);
            LOGGER.info("Storing roles successful for service named " + this.getName());
            this.service.load();
        } else {
            LOGGER.info("Storing unnecessary, no change for roles");
        }
    }

    protected abstract void serialize() throws IOException;

    @Override
    public void disAssociateRoleFromGroup(GeoServerRole role, String groupname) throws IOException {
        SortedSet<GeoServerRole> roles = this.helper.group_roleMap.get(groupname);
        if (roles != null && roles.contains(role)) {
            roles.remove(role);
            this.setModified(true);
        }
        if (this.helper.group_roleMap.get(groupname) != null && roles != null && roles.isEmpty()) {
            this.helper.group_roleMap.remove(groupname);
        }
    }

    @Override
    public void associateRoleToGroup(GeoServerRole role, String groupname) throws IOException {
        SortedSet<GeoServerRole> roles = this.helper.group_roleMap.get(groupname);
        if (roles == null) {
            roles = new TreeSet<GeoServerRole>();
            this.helper.group_roleMap.put(groupname, roles);
        }
        if (!roles.contains(role)) {
            roles.add(role);
            this.setModified(true);
        }
    }

    @Override
    public void associateRoleToUser(GeoServerRole role, String username) throws IOException {
        SortedSet<GeoServerRole> roles = this.helper.user_roleMap.get(username);
        if (roles == null) {
            roles = new TreeSet<GeoServerRole>();
            this.helper.user_roleMap.put(username, roles);
        }
        if (!roles.contains(role)) {
            roles.add(role);
            this.setModified(true);
        }
    }

    @Override
    public void disAssociateRoleFromUser(GeoServerRole role, String username) throws IOException {
        SortedSet<GeoServerRole> roles = this.helper.user_roleMap.get(username);
        if (roles != null && roles.contains(role)) {
            roles.remove(role);
            this.setModified(true);
        }
        if (this.helper.user_roleMap.get(username) != null && roles != null && roles.isEmpty()) {
            this.helper.user_roleMap.remove(username);
        }
    }

    @Override
    public void setParentRole(GeoServerRole role, GeoServerRole parentRole) throws IOException {
        RoleHierarchyHelper hhelper = new RoleHierarchyHelper(this.getParentMappings());
        if (!hhelper.isValidParent(role.getAuthority(), parentRole == null ? null : parentRole.getAuthority())) {
            throw new IOException(parentRole.getAuthority() + " is not a valid parent for " + role.getAuthority());
        }
        this.checkRole(role);
        if (parentRole == null) {
            this.helper.role_parentMap.remove(role);
        } else {
            this.checkRole(parentRole);
            this.helper.role_parentMap.put(role, parentRole);
        }
        this.setModified(true);
    }

    @Override
    public void clear() throws IOException {
        this.clearMaps();
        this.setModified(true);
    }

    protected void deserialize() throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ObjectOutputStream oout = new ObjectOutputStream(out);
        oout.writeObject(this.service.helper.roleMap);
        oout.writeObject(this.service.helper.role_parentMap);
        oout.writeObject(this.service.helper.user_roleMap);
        oout.writeObject(this.service.helper.group_roleMap);
        byte[] byteArray = out.toByteArray();
        oout.close();
        this.clearMaps();
        ByteArrayInputStream in = new ByteArrayInputStream(byteArray);
        ObjectInputStream oin = new ObjectInputStream(in);
        try {
            this.helper.roleMap = (TreeMap)oin.readObject();
            this.helper.role_parentMap = (HashMap)oin.readObject();
            this.helper.user_roleMap = (TreeMap)oin.readObject();
            this.helper.group_roleMap = (TreeMap)oin.readObject();
        }
        catch (ClassNotFoundException e) {
            throw new IOException(e);
        }
        this.setModified(false);
    }

    @Override
    public void initializeFromService(GeoServerRoleService service) throws IOException {
        this.service = (AbstractRoleService)service;
        this.load();
    }

    @Override
    public void initializeFromConfig(SecurityNamedServiceConfig config) throws IOException {
        this.service.initializeFromConfig(config);
    }

    protected void checkRole(GeoServerRole role) {
        if (!this.helper.roleMap.containsKey(role.getAuthority())) {
            throw new IllegalArgumentException("Role: " + role.getAuthority() + " does not exist");
        }
    }

    protected void clearMaps() {
        this.helper.clearMaps();
    }

    @Override
    public SortedSet<String> getGroupNamesForRole(GeoServerRole role) throws IOException {
        return this.helper.getGroupNamesForRole(role);
    }

    @Override
    public SortedSet<String> getUserNamesForRole(GeoServerRole role) throws IOException {
        return this.helper.getUserNamesForRole(role);
    }

    @Override
    public SortedSet<GeoServerRole> getRolesForUser(String username) throws IOException {
        return this.helper.getRolesForUser(username);
    }

    @Override
    public SortedSet<GeoServerRole> getRolesForGroup(String groupname) throws IOException {
        return this.helper.getRolesForGroup(groupname);
    }

    @Override
    public SortedSet<GeoServerRole> getRoles() throws IOException {
        return this.helper.getRoles();
    }

    @Override
    public Map<String, String> getParentMappings() throws IOException {
        return this.helper.getParentMappings();
    }

    @Override
    public GeoServerRole getParentRole(GeoServerRole role) throws IOException {
        return this.helper.getParentRole(role);
    }

    @Override
    public GeoServerRole getRoleByName(String role) throws IOException {
        return this.helper.getRoleByName(role);
    }

    @Override
    public void load() throws IOException {
        this.deserialize();
    }

    @Override
    public Properties personalizeRoleParams(String roleName, Properties roleParams, String userName, Properties userProps) throws IOException {
        return this.service.personalizeRoleParams(roleName, roleParams, userName, userProps);
    }

    @Override
    public int getRoleCount() throws IOException {
        return this.helper.getRoleCount();
    }
}

