/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.impl;

import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.catalog.util.CloseableIterator;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.security.FileAccessManager;
import org.geoserver.security.GeoServerSecurityManager;
import org.geoserver.security.ResourceAccessManager;
import org.geoserver.security.ResourceAccessManagerWrapper;
import org.geoserver.security.SecureCatalogImpl;
import org.geoserver.security.WorkspaceAccessLimits;
import org.geoserver.security.impl.DataAccessRuleDAO;
import org.geoserver.security.impl.DefaultResourceAccessManager;
import org.geotools.api.filter.Filter;
import org.geotools.util.logging.Logging;
import org.springframework.security.core.Authentication;

public class DefaultFileAccessManager
implements FileAccessManager {
    private static final Logger LOGGER = Logging.getLogger(DefaultFileAccessManager.class);
    public static String GEOSERVER_DATA_SANDBOX = "GEOSERVER_FILESYSTEM_SANDBOX";
    private final DataAccessRuleDAO dao;
    private final GeoServerSecurityManager securityManager;
    private final ResourceAccessManager resourceAccessManager;
    private final SecureCatalogImpl catalog;
    private String systemSandbox;

    public DefaultFileAccessManager(DataAccessRuleDAO dao, SecureCatalogImpl catalog, GeoServerSecurityManager securityManager) {
        this.dao = dao;
        this.systemSandbox = GeoServerExtensions.getProperty((String)GEOSERVER_DATA_SANDBOX);
        this.catalog = catalog;
        this.securityManager = securityManager;
        this.resourceAccessManager = catalog.getResourceAccessManager();
    }

    @Override
    public List<File> getAvailableRoots() {
        String sandboxPath;
        String string = sandboxPath = this.systemSandbox != null ? this.systemSandbox : this.dao.getFilesystemSandbox();
        if (sandboxPath == null) {
            return null;
        }
        Authentication auth = this.user();
        boolean fullAdmin = this.securityManager.checkAuthenticationForAdminRole(auth);
        if (fullAdmin) {
            if (this.systemSandbox != null) {
                return List.of(new File(this.systemSandbox));
            }
            return null;
        }
        ArrayList<String> accessibleWorkspaces = new ArrayList<String>();
        try (CloseableIterator<WorkspaceInfo> workspaces = this.catalog.list(WorkspaceInfo.class, (Filter)Filter.INCLUDE);){
            while (workspaces.hasNext()) {
                WorkspaceInfo ws2 = (WorkspaceInfo)workspaces.next();
                WorkspaceAccessLimits accessLimits = this.resourceAccessManager.getAccessLimits(auth, ws2);
                if (accessLimits == null || !accessLimits.isAdminable()) continue;
                accessibleWorkspaces.add(ws2.getName());
            }
        }
        List<File> roots = accessibleWorkspaces.stream().map(ws -> new File(sandboxPath, (String)ws)).collect(Collectors.toList());
        roots.forEach(File::mkdirs);
        return roots;
    }

    @Override
    public File getSandbox() {
        String sandboxPath;
        String string = sandboxPath = this.systemSandbox != null ? this.systemSandbox : this.dao.getFilesystemSandbox();
        if (sandboxPath == null) {
            return null;
        }
        return new File(sandboxPath);
    }

    @Override
    public boolean checkAccess(File file) {
        String sandboxPath = this.systemSandbox != null ? this.systemSandbox : this.dao.getFilesystemSandbox();
        LOGGER.log(Level.FINE, () -> "Filesystem sandbox: " + sandboxPath);
        if (sandboxPath == null) {
            return true;
        }
        Path sandbox = DefaultFileAccessManager.canonical(sandboxPath);
        Path path = DefaultFileAccessManager.canonical(file);
        Authentication auth = this.user();
        boolean fullAdmin = this.securityManager.checkAuthenticationForAdminRole();
        if (fullAdmin) {
            if (this.systemSandbox != null && !path.startsWith(sandbox)) {
                LOGGER.log(Level.FINE, () -> "Checked path " + String.valueOf(path) + " does not start with " + String.valueOf(sandbox));
                return false;
            }
            return true;
        }
        if (!path.startsWith(sandbox)) {
            return false;
        }
        String workspace = sandbox.relativize(path).getName(0).toString();
        WorkspaceInfo wi = this.catalog.getWorkspaceByName(workspace);
        if (wi == null) {
            LOGGER.log(Level.FINE, () -> "Sandbox check, workspace not authorized " + workspace);
            return false;
        }
        WorkspaceAccessLimits accessLimits = this.resourceAccessManager.getAccessLimits(auth, wi);
        LOGGER.log(Level.FINE, () -> "Sandbox auth check, workspace " + workspace + " access limits " + String.valueOf(accessLimits));
        return accessLimits != null && accessLimits.isAdminable();
    }

    public void reload() {
        this.systemSandbox = GeoServerExtensions.getProperty((String)GEOSERVER_DATA_SANDBOX);
        if (this.systemSandbox != null) {
            LOGGER.log(Level.FINE, () -> "System sandbox property found: " + this.systemSandbox);
        }
        this.dao.reload();
        ResourceAccessManager ram = this.resourceAccessManager;
        while (ram instanceof ResourceAccessManagerWrapper) {
            ram = ((ResourceAccessManagerWrapper)ram).unwrap();
        }
        if (ram instanceof DefaultResourceAccessManager) {
            DefaultResourceAccessManager manager = (DefaultResourceAccessManager)ram;
            manager.reload();
        }
    }

    private static Path canonical(String fileName) {
        return Path.of(fileName, new String[0]).toAbsolutePath().normalize();
    }

    private static Path canonical(File file) {
        return file.toPath().toAbsolutePath().normalize();
    }

    public boolean isSystemSanboxEnabled() {
        return this.systemSandbox != null;
    }
}

