/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.impl;

import java.io.File;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CatalogException;
import org.geoserver.catalog.CatalogInfo;
import org.geoserver.catalog.CoverageStoreInfo;
import org.geoserver.catalog.DataStoreInfo;
import org.geoserver.catalog.HTTPStoreInfo;
import org.geoserver.catalog.ResourcePool;
import org.geoserver.catalog.StoreInfo;
import org.geoserver.catalog.event.AbstractCatalogListener;
import org.geoserver.catalog.event.CatalogBeforeAddEvent;
import org.geoserver.catalog.event.CatalogModifyEvent;
import org.geoserver.platform.GeoServerResourceLoader;
import org.geoserver.security.FileAccessManager;
import org.geotools.api.data.DataAccessFactory;
import org.geotools.util.URLs;
import org.geotools.util.factory.Hints;
import org.geotools.util.logging.Logging;

public class FileSandboxEnforcer
extends AbstractCatalogListener {
    private static final Logger LOGGER = Logging.getLogger(FileSandboxEnforcer.class);
    private final ResourcePool resourcePool;
    private final FileAccessManager fileAccessManager;

    public FileSandboxEnforcer(Catalog catalog) {
        catalog.addListener(this);
        this.resourcePool = catalog.getResourcePool();
        this.fileAccessManager = FileAccessManager.lookupFileAccessManager();
    }

    @Override
    public void handlePreAddEvent(CatalogBeforeAddEvent event) throws CatalogException {
        CatalogInfo source = event.getSource();
        if (!(source instanceof StoreInfo)) {
            return;
        }
        if (source instanceof DataStoreInfo) {
            DataStoreInfo store = (DataStoreInfo)source;
            this.checkDataStoreParameters(store, store.getConnectionParameters());
        } else if (source instanceof CoverageStoreInfo) {
            CoverageStoreInfo store = (CoverageStoreInfo)source;
            this.checkAccess(store.getURL(), store);
        } else if (source instanceof HTTPStoreInfo) {
            HTTPStoreInfo store = (HTTPStoreInfo)source;
            this.checkAccess(store.getCapabilitiesURL(), store);
        } else {
            throw new CatalogException("Unsupported store type: " + String.valueOf(source.getClass()));
        }
    }

    @Override
    public void handleModifyEvent(CatalogModifyEvent event) throws CatalogException {
        CatalogInfo source = event.getSource();
        if (!(source instanceof StoreInfo)) {
            return;
        }
        if (source instanceof DataStoreInfo) {
            Object params = this.getNewPropertyValue(event, "connectionParameters");
            if (params instanceof Map) {
                this.checkDataStoreParameters((DataStoreInfo)source, (Map)params);
            }
        } else if (source instanceof CoverageStoreInfo) {
            CoverageStoreInfo store = (CoverageStoreInfo)source;
            Object url = this.getNewPropertyValue(event, "uRL");
            if (url instanceof String) {
                String string = (String)url;
                this.checkAccess(string, store);
            }
            if (url instanceof URL) {
                this.checkAccess(url.toString(), store);
            }
        } else if (source instanceof HTTPStoreInfo) {
            HTTPStoreInfo store = (HTTPStoreInfo)source;
            String capabilitiesURL = (String)this.getNewPropertyValue(event, "capabilitiesURL");
            if (capabilitiesURL != null) {
                this.checkAccess(capabilitiesURL, store);
            }
        } else {
            throw new CatalogException("Unsupported store type: " + String.valueOf(source.getClass()));
        }
    }

    private void checkDataStoreParameters(DataStoreInfo store, Map<String, Serializable> connectionParameters) {
        try {
            GeoServerResourceLoader loader = this.resourcePool.getCatalog().getResourceLoader();
            Map<String, Serializable> params = ResourcePool.getParams(connectionParameters, loader);
            DataAccessFactory factory = this.resourcePool.getDataStoreFactory(store);
            if (factory != null) {
                for (DataAccessFactory.Param param : factory.getParametersInfo()) {
                    Serializable value;
                    if (File.class.isAssignableFrom(param.getType())) {
                        value = (File)param.lookUp(params);
                        if (value == null) continue;
                        this.checkAccess((File)value);
                        continue;
                    }
                    if (!URL.class.isAssignableFrom(param.getType()) || (value = (URL)param.lookUp(params)) == null || !"file".equals(((URL)value).getProtocol()) && ((URL)value).getProtocol() != null) continue;
                    this.checkAccess(URLs.urlToFile((URL)value));
                }
            }
        }
        catch (SandboxException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CatalogException("Error checking data store parameters", e);
        }
    }

    private Object getNewPropertyValue(CatalogModifyEvent event, String propertyName) {
        List<String> propertyNames = event.getPropertyNames();
        for (int i = 0; i < propertyNames.size(); ++i) {
            if (!propertyName.equals(propertyNames.get(i))) continue;
            return event.getNewValues().get(i);
        }
        return null;
    }

    private void checkAccess(File value) {
        if (!this.fileAccessManager.checkAccess(value)) {
            throw new SandboxException("Access to " + String.valueOf(value) + " denied by file sandboxing", value);
        }
    }

    private void checkAccess(String url, CoverageStoreInfo storeInfo) {
        Object converted = ResourcePool.getCoverageStoreSource(url, null, storeInfo, new Hints());
        if (converted instanceof File) {
            File file = (File)converted;
            this.checkAccess(file);
        } else if (converted instanceof URL) {
            URL u = (URL)converted;
            if ("file".equals(u.getProtocol()) || u.getProtocol() == null) {
                this.checkAccess(URLs.urlToFile((URL)u));
            }
        } else {
            try {
                URI uri = new URI(url);
                if (StringUtils.isEmpty((CharSequence)uri.getScheme()) || "file".equals(uri.getScheme())) {
                    this.checkAccess(new File(url));
                } else {
                    LOGGER.log(Level.FINE, "Not a file URI in coverage store, not validating it against the sandbox: {0}", uri);
                }
            }
            catch (URISyntaxException e) {
                try {
                    Path path = Path.of(url, new String[0]);
                    this.checkAccess(path.toFile());
                }
                catch (InvalidPathException ex) {
                    LOGGER.log(Level.FINEST, "Not a valid URI/Path in coverage store, not validating it", ex);
                }
            }
        }
    }

    private void checkAccess(String urlSpec, HTTPStoreInfo storeInfo) {
        try {
            URL url = new URL(urlSpec);
            if ("file".equals(url.getProtocol())) {
                this.checkAccess(URLs.urlToFile((URL)url));
            }
        }
        catch (MalformedURLException e) {
            LOGGER.log(Level.FINE, "Not a valid URL in HTTP store, not validating it", e);
        }
    }

    public static class SandboxException
    extends CatalogException {
        private final File file;

        public SandboxException(String message, File file) {
            super(message);
            this.file = file;
        }

        public File getFile() {
            return this.file;
        }
    }
}

