/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import org.geoserver.security.impl.GeoServerRole;
import org.springframework.security.core.CredentialsContainer;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.util.StringUtils;

public class GeoServerUser
implements UserDetails,
CredentialsContainer,
Comparable<GeoServerUser> {
    private static final long serialVersionUID = 1L;
    public static final String DEFAULT_ADMIN_PASSWD = "geoserver";
    public static final boolean AdminEnabled = true;
    public static final String ADMIN_USERNAME = "admin";
    public static final String ROOT_USERNAME = "root";
    public static final String ANONYMOUS_USERNAME = "anonymous";
    private String password;
    private String username;
    private boolean accountNonExpired;
    private boolean accountNonLocked;
    private boolean credentialsNonExpired;
    private boolean enabled;
    protected Properties properties;
    protected Collection<GrantedAuthority> authorities;

    public static GeoServerUser createDefaultAdmin() {
        GeoServerUser admin = new GeoServerUser(ADMIN_USERNAME);
        admin.setPassword(DEFAULT_ADMIN_PASSWD);
        admin.setEnabled(true);
        return admin;
    }

    public static GeoServerUser createRoot() {
        GeoServerUser root = new GeoServerUser(ROOT_USERNAME);
        root.setPassword(null);
        root.setEnabled(true);
        HashSet<GeoServerRole> roles = new HashSet<GeoServerRole>();
        roles.add(GeoServerRole.ADMIN_ROLE);
        root.setAuthorities(roles);
        return root;
    }

    public static GeoServerUser createAnonymous() {
        GeoServerUser anon = new GeoServerUser(ANONYMOUS_USERNAME);
        anon.setPassword(null);
        anon.setEnabled(true);
        HashSet<GeoServerRole> roles = new HashSet<GeoServerRole>();
        roles.add(GeoServerRole.ANONYMOUS_ROLE);
        anon.setAuthorities(roles);
        return anon;
    }

    public GeoServerUser(String username) {
        this.username = username;
        this.enabled = true;
        this.credentialsNonExpired = true;
        this.accountNonLocked = true;
        this.accountNonExpired = true;
        this.authorities = null;
    }

    public GeoServerUser(GeoServerUser other) {
        this.username = other.getUsername();
        this.password = other.getPassword();
        this.accountNonExpired = other.isAccountNonExpired();
        this.accountNonLocked = other.isAccountNonLocked();
        this.credentialsNonExpired = other.isCredentialsNonExpired();
        this.enabled = other.isEnabled();
        this.authorities = other.getAuthorities() != null ? new ArrayList<GrantedAuthority>(other.getAuthorities()) : null;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String passwd) {
        this.password = passwd;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isAccountNonExpired() {
        return this.accountNonExpired;
    }

    public void setAccountNonExpired(boolean accountNonExpired) {
        if (this.accountNonExpired != accountNonExpired) {
            this.accountNonExpired = accountNonExpired;
        }
    }

    public boolean isAccountNonLocked() {
        return this.accountNonLocked;
    }

    public void setAccountNonLocked(boolean accountNonLocked) {
        if (this.accountNonLocked != accountNonLocked) {
            this.accountNonLocked = accountNonLocked;
        }
    }

    public boolean isCredentialsNonExpired() {
        return this.credentialsNonExpired;
    }

    public void setCredentialsNonExpired(boolean credentialsNonExpired) {
        if (this.credentialsNonExpired != credentialsNonExpired) {
            this.credentialsNonExpired = credentialsNonExpired;
        }
    }

    public Collection<GrantedAuthority> getAuthorities() {
        if (this.authorities == null) {
            this.authorities = Collections.unmodifiableSet(new TreeSet());
        }
        return this.authorities;
    }

    public void setAuthorities(Set<? extends GrantedAuthority> roles) {
        this.authorities = Collections.unmodifiableSet(roles);
    }

    public void eraseCredentials() {
        this.password = null;
    }

    public Properties getProperties() {
        if (this.properties == null) {
            this.properties = new Properties();
        }
        return this.properties;
    }

    @Override
    public int compareTo(GeoServerUser o) {
        if (o == null) {
            return 1;
        }
        return this.getUsername().compareTo(o.getUsername());
    }

    public GeoServerUser copy() {
        return new GeoServerUser(this);
    }

    public boolean equals(Object rhs) {
        if (rhs instanceof GeoServerUser) {
            GeoServerUser user = (GeoServerUser)rhs;
            return this.username.equals(user.username);
        }
        return false;
    }

    public int hashCode() {
        return this.username.hashCode();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Username: ").append(this.username).append("; ");
        sb.append("Password: [PROTECTED]; ");
        sb.append("Enabled: ").append(this.enabled).append("; ");
        sb.append("AccountNonExpired: ").append(this.accountNonExpired).append("; ");
        sb.append("CredentialsNonExpired: ").append(this.credentialsNonExpired).append("; ");
        sb.append("AccountNonLocked: ").append(this.accountNonLocked).append("; ");
        sb.append(" [ ");
        if (this.authorities != null) {
            sb.append(StringUtils.collectionToCommaDelimitedString(this.authorities));
        }
        sb.append(" ] ");
        return sb.toString();
    }
}

