/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.impl;

import java.io.IOException;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.geoserver.config.GeoServerDataDirectory;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.security.impl.AbstractAccessRuleDAO;
import org.geotools.util.logging.Logging;

public class RESTAccessRuleDAO
extends AbstractAccessRuleDAO<String> {
    private static final Logger LOGGER = Logging.getLogger(RESTAccessRuleDAO.class);
    static final Pattern PATTERN = Pattern.compile("\\S+;(GET|POST|PUT|DELETE|HEAD|OPTIONS)(,(GET|POST|PUT|DELETE|HEAD|OPTIONS))*=\\S+(, ?\\S+)*");

    public static RESTAccessRuleDAO get() {
        return (RESTAccessRuleDAO)GeoServerExtensions.bean(RESTAccessRuleDAO.class);
    }

    protected RESTAccessRuleDAO(GeoServerDataDirectory dd) throws IOException {
        super(dd, "rest.properties");
    }

    @Override
    protected void loadRules(Properties props) {
        this.rules = Collections.synchronizedSet(new LinkedHashSet());
        for (Map.Entry<Object, Object> entry : props.entrySet()) {
            String val;
            String key = (String)entry.getKey();
            Object rule = key + "=" + (val = (String)entry.getValue());
            if (!PATTERN.matcher((CharSequence)rule).matches()) {
                LOGGER.severe("Ignoring '" + (String)rule + "' not matching " + String.valueOf(PATTERN));
                continue;
            }
            rule = ((String)rule).replaceAll(";", ":");
            this.rules.add(rule);
        }
    }

    @Override
    protected Properties toProperties() {
        Properties props = new Properties();
        for (String rule : this.rules) {
            if (!PATTERN.matcher(rule = rule.replaceAll(":", ";")).matches()) {
                LOGGER.severe("Invalid '" + rule + "' not matching " + String.valueOf(PATTERN));
                continue;
            }
            String[] parts = rule.split("=");
            props.setProperty(parts[0], parts[1]);
        }
        return props;
    }
}

