/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.password;

import java.io.IOException;
import java.security.Provider;
import java.security.Security;
import java.util.logging.Logger;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.geoserver.security.GeoServerSecurityManager;
import org.geoserver.security.GeoServerUserGroupService;
import org.geoserver.security.password.GeoServerPasswordEncoder;
import org.geoserver.security.password.PasswordEncodingType;
import org.geotools.util.logging.Logging;
import org.springframework.dao.DataAccessException;
import org.springframework.security.crypto.password.PasswordEncoder;

public abstract class AbstractGeoserverPasswordEncoder
implements GeoServerPasswordEncoder {
    protected static Logger LOGGER = Logging.getLogger((String)"org.geoserver.security");
    protected volatile PasswordEncoder stringEncoder;
    protected volatile CharArrayPasswordEncoder charEncoder;
    protected String name;
    private boolean availableWithoutStrongCryptogaphy;
    private boolean reversible = true;
    private String prefix;

    @Override
    public String getName() {
        return this.name;
    }

    public void setBeanName(String beanName) {
        this.name = beanName;
    }

    @Override
    public void initialize(GeoServerSecurityManager securityManager) throws IOException {
    }

    @Override
    public void initializeFor(GeoServerUserGroupService service) throws IOException {
    }

    public AbstractGeoserverPasswordEncoder() {
        this.setAvailableWithoutStrongCryptogaphy(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected PasswordEncoder getStringEncoder() {
        if (this.stringEncoder == null) {
            AbstractGeoserverPasswordEncoder abstractGeoserverPasswordEncoder = this;
            synchronized (abstractGeoserverPasswordEncoder) {
                if (this.stringEncoder == null) {
                    this.stringEncoder = this.createStringEncoder();
                }
            }
        }
        return this.stringEncoder;
    }

    protected abstract PasswordEncoder createStringEncoder();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CharArrayPasswordEncoder getCharEncoder() {
        if (this.charEncoder == null) {
            AbstractGeoserverPasswordEncoder abstractGeoserverPasswordEncoder = this;
            synchronized (abstractGeoserverPasswordEncoder) {
                if (this.charEncoder == null) {
                    this.charEncoder = this.createCharEncoder();
                }
            }
        }
        return this.charEncoder;
    }

    protected abstract CharArrayPasswordEncoder createCharEncoder();

    protected final PasswordEncoder getActualEncoder() {
        return null;
    }

    @Override
    public String encodePassword(String rawPass, Object salt) throws DataAccessException {
        return this.doEncodePassword(this.getStringEncoder().encode((CharSequence)rawPass));
    }

    @Override
    public String encodePassword(char[] rawPass, Object salt) throws DataAccessException {
        return this.doEncodePassword(this.getCharEncoder().encodePassword(rawPass, salt));
    }

    String doEncodePassword(String encPass) {
        if (encPass == null) {
            return encPass;
        }
        StringBuffer buff = this.initPasswordBuffer();
        buff.append(encPass);
        return buff.toString();
    }

    StringBuffer initPasswordBuffer() {
        StringBuffer buff = new StringBuffer();
        if (this.getPrefix() != null) {
            buff.append(this.getPrefix()).append(":");
        }
        return buff;
    }

    @Override
    public boolean isPasswordValid(String encPass, String rawPass, Object salt) throws DataAccessException {
        if (encPass == null) {
            return false;
        }
        return this.getStringEncoder().matches((CharSequence)rawPass, this.stripPrefix(encPass));
    }

    @Override
    public boolean isPasswordValid(String encPass, char[] rawPass, Object salt) {
        if (encPass == null) {
            return false;
        }
        return this.getCharEncoder().isPasswordValid(this.stripPrefix(encPass), rawPass, salt);
    }

    String stripPrefix(String encPass) {
        return this.getPrefix() != null ? this.removePrefix(encPass) : encPass;
    }

    protected String removePrefix(String encPass) {
        return encPass.replaceFirst(this.getPrefix() + ":", "");
    }

    @Override
    public abstract PasswordEncodingType getEncodingType();

    @Override
    public boolean isResponsibleForEncoding(String encPass) {
        if (encPass == null) {
            return false;
        }
        return encPass.startsWith(this.getPrefix() + ":");
    }

    @Override
    public String decode(String encPass) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("decoding passwords not supported");
    }

    public boolean matches(CharSequence rawPassword, String encodedPassword) {
        return this.isPasswordValid(encodedPassword, rawPassword.toString(), null);
    }

    @Override
    public char[] decodeToCharArray(String encPass) throws UnsupportedOperationException {
        return encPass.toCharArray();
    }

    @Override
    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    @Override
    public boolean isAvailableWithoutStrongCryptogaphy() {
        return this.availableWithoutStrongCryptogaphy;
    }

    public void setAvailableWithoutStrongCryptogaphy(boolean availableWithoutStrongCryptogaphy) {
        this.availableWithoutStrongCryptogaphy = availableWithoutStrongCryptogaphy;
    }

    @Override
    public boolean isReversible() {
        return this.reversible;
    }

    public void setReversible(boolean reversible) {
        this.reversible = reversible;
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }

    protected static interface CharArrayPasswordEncoder {
        public String encodePassword(char[] var1, Object var2);

        public boolean isPasswordValid(String var1, char[] var2, Object var3);
    }
}

