/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.password;

import java.util.Objects;
import org.geoserver.security.password.AbstractGeoserverPasswordEncoder;
import org.geoserver.security.password.PasswordEncodingType;
import org.jasypt.encryption.pbe.PBEStringEncryptor;
import org.jasypt.exceptions.EncryptionInitializationException;
import org.jasypt.util.text.BasicTextEncryptor;
import org.jasypt.util.text.TextEncryptor;
import org.springframework.dao.DataAccessException;
import org.springframework.security.crypto.password.PasswordEncoder;

public class JasyptPBEPasswordEncoderWrapper
extends AbstractGeoserverPasswordEncoder
implements PasswordEncoder {
    private TextEncryptor textEncryptor = null;
    private PBEStringEncryptor pbeStringEncryptor = null;
    private Boolean useTextEncryptor = null;

    @Override
    protected PasswordEncoder createStringEncoder() {
        return new PasswordEncoder(){

            public boolean matches(CharSequence encPass, String rawPass) throws DataAccessException {
                return false;
            }

            public String encode(CharSequence rawPass) throws DataAccessException {
                return "";
            }
        };
    }

    @Override
    protected AbstractGeoserverPasswordEncoder.CharArrayPasswordEncoder createCharEncoder() {
        return new AbstractGeoserverPasswordEncoder.CharArrayPasswordEncoder(){

            @Override
            public boolean isPasswordValid(String encPass, char[] rawPass, Object salt) {
                return false;
            }

            @Override
            public String encodePassword(char[] rawPass, Object salt) {
                return "";
            }
        };
    }

    public void setTextEncryptor(TextEncryptor textEncryptor) {
        this.textEncryptor = textEncryptor;
        this.useTextEncryptor = Boolean.TRUE;
    }

    public void setPbeStringEncryptor(PBEStringEncryptor pbeStringEncryptor) {
        this.pbeStringEncryptor = pbeStringEncryptor;
        this.useTextEncryptor = Boolean.FALSE;
    }

    @Override
    public String encodePassword(String rawPass, Object salt) {
        this.checkInitialization();
        return this.useTextEncryptor != false ? this.textEncryptor.encrypt(rawPass) : this.pbeStringEncryptor.encrypt(rawPass);
    }

    @Override
    public boolean isPasswordValid(String encPass, String rawPass, Object salt) {
        this.checkInitialization();
        String decPassword = null;
        decPassword = this.useTextEncryptor != false ? this.textEncryptor.decrypt(encPass) : this.pbeStringEncryptor.decrypt(encPass);
        return Objects.equals(decPassword, rawPass);
    }

    @Override
    public PasswordEncodingType getEncodingType() {
        return PasswordEncodingType.ENCRYPT;
    }

    private synchronized void checkInitialization() {
        if (this.useTextEncryptor == null) {
            this.textEncryptor = new BasicTextEncryptor();
            this.useTextEncryptor = Boolean.TRUE;
        } else if (this.useTextEncryptor.booleanValue()) {
            if (this.textEncryptor == null) {
                throw new EncryptionInitializationException("PBE Password encoder not initialized: text encryptor is null");
            }
        } else if (this.pbeStringEncryptor == null) {
            throw new EncryptionInitializationException("PBE Password encoder not initialized: PBE string encryptor is null");
        }
    }

    public String encode(CharSequence rawPassword) {
        if (rawPassword != null) {
            return this.encodePassword(rawPassword.toString(), null);
        }
        return null;
    }
}

