/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.password;

import org.geoserver.security.password.AbstractGeoserverPasswordEncoder;
import org.geoserver.security.password.PasswordEncodingType;
import org.jasypt.digest.StringDigester;
import org.jasypt.exceptions.EncryptionInitializationException;
import org.jasypt.util.password.BasicPasswordEncryptor;
import org.jasypt.util.password.PasswordEncryptor;
import org.springframework.security.crypto.factory.PasswordEncoderFactories;
import org.springframework.security.crypto.password.PasswordEncoder;

public class JasyptPasswordEncoderWrapper
extends AbstractGeoserverPasswordEncoder
implements PasswordEncoder {
    private PasswordEncryptor passwordEncryptor = null;
    private StringDigester stringDigester = null;
    private Boolean useEncryptor = null;

    public void setPasswordEncryptor(PasswordEncryptor passwordEncryptor) {
        this.passwordEncryptor = passwordEncryptor;
        this.useEncryptor = Boolean.TRUE;
    }

    public void setStringDigester(StringDigester stringDigester) {
        this.stringDigester = stringDigester;
        this.useEncryptor = Boolean.FALSE;
    }

    @Override
    public String encodePassword(String rawPass, Object salt) {
        this.checkInitialization();
        if (this.useEncryptor.booleanValue()) {
            return this.passwordEncryptor.encryptPassword(rawPass);
        }
        return this.stringDigester.digest(rawPass);
    }

    @Override
    public boolean isPasswordValid(String encPass, String rawPass, Object salt) {
        this.checkInitialization();
        if (this.useEncryptor.booleanValue()) {
            return this.passwordEncryptor.checkPassword(rawPass, encPass);
        }
        return this.stringDigester.matches(rawPass, encPass);
    }

    private synchronized void checkInitialization() {
        if (this.useEncryptor == null) {
            this.passwordEncryptor = new BasicPasswordEncryptor();
            this.useEncryptor = Boolean.TRUE;
        } else if (this.useEncryptor.booleanValue()) {
            if (this.passwordEncryptor == null) {
                throw new EncryptionInitializationException("Password encoder not initialized: password encryptor is null");
            }
        } else if (this.stringDigester == null) {
            throw new EncryptionInitializationException("Password encoder not initialized: string digester is null");
        }
    }

    @Override
    protected PasswordEncoder createStringEncoder() {
        return PasswordEncoderFactories.createDelegatingPasswordEncoder();
    }

    @Override
    protected AbstractGeoserverPasswordEncoder.CharArrayPasswordEncoder createCharEncoder() {
        return new AbstractGeoserverPasswordEncoder.CharArrayPasswordEncoder(){

            @Override
            public boolean isPasswordValid(String encPass, char[] rawPass, Object salt) {
                return encPass.equals(String.valueOf(rawPass));
            }

            @Override
            public String encodePassword(char[] rawPass, Object salt) {
                return PasswordEncoderFactories.createDelegatingPasswordEncoder().encode((CharSequence)String.valueOf(rawPass));
            }
        };
    }

    @Override
    public PasswordEncodingType getEncodingType() {
        return PasswordEncodingType.PLAIN;
    }

    @Override
    public String decode(String encPass) throws UnsupportedOperationException {
        return this.removePrefix(encPass);
    }

    @Override
    public char[] decodeToCharArray(String encPass) throws UnsupportedOperationException {
        return this.decode(encPass).toCharArray();
    }

    public String encode(CharSequence rawPassword) {
        return this.encodePassword(rawPassword.toString(), null);
    }
}

