/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.rememberme;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.HashSet;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.geoserver.security.filter.GeoServerWebAuthenticationDetails;
import org.geoserver.security.impl.GeoServerRole;
import org.geoserver.security.rememberme.RememberMeUserDetailsService;
import org.springframework.security.authentication.RememberMeAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.web.authentication.rememberme.InvalidCookieException;
import org.springframework.security.web.authentication.rememberme.TokenBasedRememberMeServices;

public class GeoServerTokenBasedRememberMeServices
extends TokenBasedRememberMeServices {
    static Cache<String, String> unauthorizedRememberMeCookieCache = CacheBuilder.newBuilder().expireAfterWrite(336L, TimeUnit.HOURS).build();

    public GeoServerTokenBasedRememberMeServices(String key, UserDetailsService userDetailsService) {
        super(key, userDetailsService);
    }

    public void logout(HttpServletRequest request, HttpServletResponse response, Authentication authentication) {
        String rememberMeCookie = this.extractRememberMeCookie(request);
        super.logout(request, response, authentication);
        if (StringUtils.isNotBlank((CharSequence)rememberMeCookie)) {
            unauthorizedRememberMeCookieCache.put((Object)rememberMeCookie, (Object)"");
        }
    }

    protected String[] decodeCookie(String cookieValue) throws InvalidCookieException {
        if (StringUtils.isEmpty((CharSequence)cookieValue)) {
            return new String[0];
        }
        if (unauthorizedRememberMeCookieCache.getIfPresent((Object)cookieValue) != null) {
            return new String[0];
        }
        return super.decodeCookie(cookieValue);
    }

    protected String makeTokenSignature(long tokenExpiryTime, String username, String password) {
        Matcher m = RememberMeUserDetailsService.TOKEN_PATTERN.matcher(username);
        String uName = !m.matches() ? username : m.group(1).replace("\\@", "@");
        return super.makeTokenSignature(tokenExpiryTime, uName, password);
    }

    protected String retrieveUserName(Authentication authentication) {
        if (authentication.getDetails() instanceof GeoServerWebAuthenticationDetails) {
            String userGroupServiceName = ((GeoServerWebAuthenticationDetails)((Object)authentication.getDetails())).getUserGroupServiceName();
            if (userGroupServiceName == null || userGroupServiceName.trim().isEmpty()) {
                return "";
            }
            return this.encode(super.retrieveUserName(authentication), userGroupServiceName);
        }
        return "";
    }

    String encode(String username, String userGroupServiceName) {
        if (userGroupServiceName == null) {
            return username;
        }
        if (username.endsWith("@" + userGroupServiceName)) {
            return username;
        }
        return username.replace("@", "\\@") + "@" + userGroupServiceName;
    }

    protected Authentication createSuccessfulAuthentication(HttpServletRequest request, UserDetails user) {
        if (user instanceof RememberMeUserDetailsService.RememberMeUserDetails) {
            RememberMeUserDetailsService.RememberMeUserDetails details = (RememberMeUserDetailsService.RememberMeUserDetails)user;
            user = details.getWrappedObject();
        }
        HashSet<GeoServerRole> roles = new HashSet<GeoServerRole>();
        if (user.getAuthorities().contains(GeoServerRole.AUTHENTICATED_ROLE)) {
            roles.addAll(user.getAuthorities());
        } else {
            roles = new HashSet();
            roles.addAll(user.getAuthorities());
            roles.add(GeoServerRole.AUTHENTICATED_ROLE);
        }
        RememberMeAuthenticationToken auth = new RememberMeAuthenticationToken(this.getKey(), (Object)user, roles);
        auth.setDetails(this.getAuthenticationDetailsSource().buildDetails((Object)request));
        return auth;
    }
}

