/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.rememberme;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.geoserver.security.GeoServerSecurityManager;
import org.geoserver.security.rememberme.RememberMeServicesConfig;
import org.geoserver.security.rememberme.RememberMeUserDetailsService;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.web.authentication.RememberMeServices;
import org.springframework.security.web.authentication.logout.LogoutHandler;
import org.springframework.security.web.authentication.rememberme.AbstractRememberMeServices;

public class RememberMeServicesFactoryBean
implements FactoryBean<RememberMeServices> {
    static final String PARAMETER_NAME = "_spring_security_remember_me";
    GeoServerSecurityManager securityManager;

    public RememberMeServicesFactoryBean(GeoServerSecurityManager securityManager) {
        this.securityManager = securityManager;
    }

    public RememberMeServices getObject() throws Exception {
        return new RememberMeServicesProxy(this.securityManager);
    }

    public Class<?> getObjectType() {
        return RememberMeServices.class;
    }

    public boolean isSingleton() {
        return true;
    }

    static class RememberMeServicesProxy
    implements RememberMeServices,
    LogoutHandler {
        GeoServerSecurityManager securityManager;
        RememberMeServices rms;

        RememberMeServicesProxy(GeoServerSecurityManager securityManager) {
            this.securityManager = securityManager;
        }

        public Authentication autoLogin(HttpServletRequest request, HttpServletResponse response) {
            return this.rms().autoLogin(request, response);
        }

        public void loginFail(HttpServletRequest request, HttpServletResponse response) {
            this.rms().loginFail(request, response);
        }

        public void loginSuccess(HttpServletRequest request, HttpServletResponse response, Authentication successfulAuthentication) {
            this.rms().loginSuccess(request, response, successfulAuthentication);
        }

        public void logout(HttpServletRequest request, HttpServletResponse response, Authentication authentication) {
            RememberMeServices rms = this.rms();
            if (rms instanceof LogoutHandler) {
                LogoutHandler handler = (LogoutHandler)rms;
                handler.logout(request, response, authentication);
            }
        }

        RememberMeServices rms() {
            if (this.rms != null) {
                return this.rms;
            }
            RememberMeServicesConfig rmsConfig = this.securityManager.getSecurityConfig().getRememberMeService();
            try {
                Class<?> rmsClass = Class.forName(rmsConfig.getClassName());
                RememberMeServices rememberMeServices = this.rms = (RememberMeServices)rmsClass.getConstructor(String.class, UserDetailsService.class).newInstance(rmsConfig.getKey(), new RememberMeUserDetailsService(this.securityManager));
                if (rememberMeServices instanceof AbstractRememberMeServices) {
                    AbstractRememberMeServices services = (AbstractRememberMeServices)rememberMeServices;
                    services.setParameter(RememberMeServicesFactoryBean.PARAMETER_NAME);
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return this.rms;
        }
    }
}

