/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.urlchecks;

import java.util.List;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.geoserver.security.urlchecks.AbstractURLCheck;
import org.geoserver.security.urlchecks.URLCheckDAO;
import org.geotools.data.ows.URLChecker;
import org.geotools.data.ows.URLCheckers;
import org.geotools.util.logging.Logging;
import org.springframework.beans.factory.DisposableBean;

public class GeoServerURLChecker
implements URLChecker,
DisposableBean {
    static final Logger LOGGER = Logging.getLogger(GeoServerURLChecker.class);
    private final URLCheckDAO dao;

    public GeoServerURLChecker(URLCheckDAO dao) {
        this.dao = dao;
        URLCheckers.register((URLChecker)this);
    }

    public String getName() {
        return "Geoserver";
    }

    public boolean isEnabled() {
        return true;
    }

    public boolean confirm(String url) {
        try {
            if (!this.dao.isEnabled()) {
                return true;
            }
            if (url == null || url.isEmpty()) {
                return false;
            }
            List<AbstractURLCheck> enabledUrlList = this.getEnabledChecks();
            if (!enabledUrlList.isEmpty()) {
                for (AbstractURLCheck u : enabledUrlList) {
                    if (!u.confirm(url)) continue;
                    LOGGER.log(Level.FINE, () -> "URL " + url + " was matched by " + String.valueOf(u));
                    return true;
                }
            }
            LOGGER.log(Level.FINE, () -> url + " did not match any check");
            return false;
        }
        catch (Exception e) {
            throw new RuntimeException("Error while checking URL " + url, e);
        }
    }

    private List<AbstractURLCheck> getEnabledChecks() throws Exception {
        return this.dao.getChecks().stream().filter(e -> e.isEnabled()).collect(Collectors.toList());
    }

    public AbstractURLCheck get(String name) throws Exception {
        Optional<AbstractURLCheck> entry = this.dao.getChecks().stream().filter(urlEntry -> urlEntry.getName().equalsIgnoreCase(name)).findFirst();
        if (entry.isPresent()) {
            return entry.get();
        }
        return null;
    }

    public void destroy() throws Exception {
        URLCheckers.deregister((URLChecker)this);
    }
}

