/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.urlchecks;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geoserver.config.GeoServerDataDirectory;
import org.geotools.data.ows.URLChecker;
import org.geotools.data.ows.URLCheckers;
import org.geotools.util.logging.Logging;
import org.springframework.beans.factory.DisposableBean;

public class StyleURLChecker
implements URLChecker,
DisposableBean {
    static final Logger LOGGER = Logging.getLogger(StyleURLChecker.class);
    private final GeoServerDataDirectory dd;

    public StyleURLChecker(GeoServerDataDirectory dd) {
        this.dd = dd;
        URLCheckers.register((URLChecker)this);
    }

    public String getName() {
        return "DataDirectoryStyles";
    }

    public boolean isEnabled() {
        return true;
    }

    public boolean confirm(String location) {
        try {
            if (location.startsWith("file://")) {
                location = location.substring(7);
            } else if (location.startsWith("file:")) {
                location = location.substring(5);
            }
            location = location.split("\\?", 2)[0].split("#", 2)[0];
            File file = new File(location);
            Path resource = file.getCanonicalFile().toPath();
            Path dataDirectory = this.dd.getRoot(new String[0]).dir().getCanonicalFile().toPath();
            if (!resource.startsWith(dataDirectory)) {
                return false;
            }
            Path relative = dataDirectory.relativize(resource);
            if (relative.getNameCount() > 1 && relative.getName(0).toString().equals("styles")) {
                return true;
            }
            if (relative.getNameCount() > 3 && relative.getName(0).toString().equals("workspaces") && relative.getName(2).toString().equals("styles")) {
                return true;
            }
        }
        catch (IOException e) {
            LOGGER.log(Level.FINE, "Unexpected error checking resource location", e);
        }
        return false;
    }

    public void destroy() throws Exception {
        URLCheckers.deregister((URLChecker)this);
    }
}

