/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.validation;

import java.io.IOException;
import org.geoserver.security.GeoServerSecurityManager;
import org.geoserver.security.config.AnonymousAuthenticationFilterConfig;
import org.geoserver.security.config.BasicAuthenticationFilterConfig;
import org.geoserver.security.config.DigestAuthenticationFilterConfig;
import org.geoserver.security.config.ExceptionTranslationFilterConfig;
import org.geoserver.security.config.J2eeAuthenticationBaseFilterConfig;
import org.geoserver.security.config.J2eeAuthenticationFilterConfig;
import org.geoserver.security.config.LogoutFilterConfig;
import org.geoserver.security.config.PreAuthenticatedUserNameFilterConfig;
import org.geoserver.security.config.RememberMeAuthenticationFilterConfig;
import org.geoserver.security.config.RequestHeaderAuthenticationFilterConfig;
import org.geoserver.security.config.RoleFilterConfig;
import org.geoserver.security.config.SecurityContextPersistenceFilterConfig;
import org.geoserver.security.config.SecurityFilterConfig;
import org.geoserver.security.config.SecurityInterceptorFilterConfig;
import org.geoserver.security.config.SecurityNamedServiceConfig;
import org.geoserver.security.config.UsernamePasswordAuthenticationFilterConfig;
import org.geoserver.security.config.X509CertificateAuthenticationFilterConfig;
import org.geoserver.security.validation.FilterConfigException;
import org.geoserver.security.validation.SecurityConfigException;
import org.geoserver.security.validation.SecurityConfigValidator;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;

public class FilterConfigValidator
extends SecurityConfigValidator {
    public FilterConfigValidator(GeoServerSecurityManager securityManager) {
        super(securityManager);
    }

    protected FilterConfigException createFilterException(String errorid, Object ... args) {
        return new FilterConfigException(errorid, args);
    }

    @Override
    public void validateAddFilter(SecurityNamedServiceConfig config) throws SecurityConfigException {
        super.validateAddFilter(config);
        this.validateFilterConfig(config);
    }

    @Override
    public void validateModifiedFilter(SecurityNamedServiceConfig config, SecurityNamedServiceConfig oldConfig) throws SecurityConfigException {
        super.validateModifiedFilter(config, oldConfig);
        this.validateFilterConfig(config);
    }

    @Override
    public void validateRemoveFilter(SecurityNamedServiceConfig config) throws SecurityConfigException {
        super.validateRemoveFilter(config);
    }

    public void validateFilterConfig(SecurityNamedServiceConfig config) throws FilterConfigException {
        SecurityFilterConfig filterConfig;
        if (config instanceof BasicAuthenticationFilterConfig) {
            filterConfig = (BasicAuthenticationFilterConfig)config;
            this.validateFilterConfig((BasicAuthenticationFilterConfig)filterConfig);
        }
        if (config instanceof DigestAuthenticationFilterConfig) {
            filterConfig = (DigestAuthenticationFilterConfig)config;
            this.validateFilterConfig((DigestAuthenticationFilterConfig)filterConfig);
        }
        if (config instanceof RoleFilterConfig) {
            filterConfig = (RoleFilterConfig)config;
            this.validateFilterConfig((RoleFilterConfig)filterConfig);
        }
        if (config instanceof X509CertificateAuthenticationFilterConfig) {
            filterConfig = (X509CertificateAuthenticationFilterConfig)config;
            this.validateFilterConfig((X509CertificateAuthenticationFilterConfig)filterConfig);
        }
        if (config instanceof UsernamePasswordAuthenticationFilterConfig) {
            filterConfig = (UsernamePasswordAuthenticationFilterConfig)config;
            this.validateFilterConfig((UsernamePasswordAuthenticationFilterConfig)filterConfig);
        }
        if (config instanceof RequestHeaderAuthenticationFilterConfig) {
            filterConfig = (RequestHeaderAuthenticationFilterConfig)config;
            this.validateFilterConfig((RequestHeaderAuthenticationFilterConfig)filterConfig);
        }
        if (config instanceof J2eeAuthenticationFilterConfig) {
            filterConfig = (J2eeAuthenticationFilterConfig)config;
            this.validateFilterConfig((J2eeAuthenticationFilterConfig)filterConfig);
        }
        if (config instanceof ExceptionTranslationFilterConfig) {
            filterConfig = (ExceptionTranslationFilterConfig)config;
            this.validateFilterConfig((ExceptionTranslationFilterConfig)filterConfig);
        }
        if (config instanceof SecurityContextPersistenceFilterConfig) {
            filterConfig = (SecurityContextPersistenceFilterConfig)config;
            this.validateFilterConfig((SecurityContextPersistenceFilterConfig)filterConfig);
        }
        if (config instanceof RememberMeAuthenticationFilterConfig) {
            filterConfig = (RememberMeAuthenticationFilterConfig)config;
            this.validateFilterConfig((RememberMeAuthenticationFilterConfig)filterConfig);
        }
        if (config instanceof AnonymousAuthenticationFilterConfig) {
            filterConfig = (AnonymousAuthenticationFilterConfig)config;
            this.validateFilterConfig((AnonymousAuthenticationFilterConfig)filterConfig);
        }
        if (config instanceof SecurityInterceptorFilterConfig) {
            filterConfig = (SecurityInterceptorFilterConfig)config;
            this.validateFilterConfig((SecurityInterceptorFilterConfig)filterConfig);
        }
        if (config instanceof LogoutFilterConfig) {
            filterConfig = (LogoutFilterConfig)config;
            this.validateFilterConfig((LogoutFilterConfig)filterConfig);
        }
    }

    protected void checkExistingUGService(String ugServiceName) throws FilterConfigException {
        if (!this.isNotEmpty(ugServiceName)) {
            throw this.createFilterException("USER_GROUP_SERVICE_NEEDED", new Object[0]);
        }
        try {
            if (!this.manager.listUserGroupServices().contains(ugServiceName)) {
                throw this.createFilterException("UNKNOWN_USER_GROUP_SERVICE", ugServiceName);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected void checkExistingRoleService(String roleServiceName) throws FilterConfigException {
        if (!this.isNotEmpty(roleServiceName)) {
            return;
        }
        try {
            if (!this.manager.listRoleServices().contains(roleServiceName)) {
                throw this.createFilterException("UNKNOWN_ROLE_SERVICE", roleServiceName);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void validateFilterConfig(LogoutFilterConfig config) throws FilterConfigException {
    }

    public void validateFilterConfig(BasicAuthenticationFilterConfig config) throws FilterConfigException {
    }

    public void validateFilterConfig(SecurityContextPersistenceFilterConfig config) throws FilterConfigException {
    }

    public void validateFilterConfig(RememberMeAuthenticationFilterConfig config) throws FilterConfigException {
    }

    public void validateFilterConfig(AnonymousAuthenticationFilterConfig config) throws FilterConfigException {
    }

    public void validateFilterConfig(SecurityInterceptorFilterConfig config) throws FilterConfigException {
        if (!this.isNotEmpty(config.getSecurityMetadataSource())) {
            throw this.createFilterException("SECURITY_METADATA_SOURCE_NEEDED", new Object[0]);
        }
        try {
            this.lookupBean(config.getSecurityMetadataSource());
        }
        catch (NoSuchBeanDefinitionException ex) {
            throw this.createFilterException("UNKNOWN_SECURITY_METADATA_SOURCE", config.getSecurityMetadataSource());
        }
    }

    public void validateFilterConfig(DigestAuthenticationFilterConfig config) throws FilterConfigException {
        this.checkExistingUGService(config.getUserGroupServiceName());
        if (config.getNonceValiditySeconds() < 0) {
            throw this.createFilterException("INVALID_SECONDS", new Object[0]);
        }
    }

    public void validateFilterConfig(RoleFilterConfig config) throws FilterConfigException {
        if (!this.isNotEmpty(config.getHttpResponseHeaderAttrForIncludedRoles())) {
            throw this.createFilterException("HEADER_ATTRIBUTE_NAME_REQUIRED", new Object[0]);
        }
        if (this.isNotEmpty(config.getRoleConverterName())) {
            try {
                this.lookupBean(config.getRoleConverterName());
            }
            catch (NoSuchBeanDefinitionException ex) {
                throw this.createFilterException("UNKNOWN_ROLE_CONVERTER", config.getRoleConverterName());
            }
        }
    }

    public void validateFilterConfig(X509CertificateAuthenticationFilterConfig config) throws FilterConfigException {
        this.validateFilterConfig((J2eeAuthenticationBaseFilterConfig)config);
    }

    public void validateFilterConfig(UsernamePasswordAuthenticationFilterConfig config) throws FilterConfigException {
        if (!this.isNotEmpty(config.getUsernameParameterName())) {
            throw this.createFilterException("USER_PARAMETER_NAME_NEEDED", new Object[0]);
        }
        if (!this.isNotEmpty(config.getPasswordParameterName())) {
            throw this.createFilterException("PASSWORD_PARAMETER_NAME_NEEDED", new Object[0]);
        }
    }

    public void validateFilterConfig(J2eeAuthenticationBaseFilterConfig config) throws FilterConfigException {
        this.validateFilterConfig((PreAuthenticatedUserNameFilterConfig)config);
        if (config.getRoleSource().equals(J2eeAuthenticationBaseFilterConfig.J2EERoleSource.J2EE)) {
            this.checkExistingRoleService(config.getRoleServiceName());
        }
    }

    public void validateFilterConfig(RequestHeaderAuthenticationFilterConfig config) throws FilterConfigException {
        if (!this.isNotEmpty(config.getPrincipalHeaderAttribute())) {
            throw this.createFilterException("PRINCIPAL_HEADER_ATTRIBUTE_NEEDED", new Object[0]);
        }
        this.validateFilterConfig((PreAuthenticatedUserNameFilterConfig)config);
    }

    public void validateFilterConfig(PreAuthenticatedUserNameFilterConfig config) throws FilterConfigException {
        if (config.getRoleSource() == null) {
            throw this.createFilterException("ROLE_SOURCE_NEEDED", new Object[0]);
        }
        if (config.getRoleSource().equals(PreAuthenticatedUserNameFilterConfig.PreAuthenticatedUserNameRoleSource.RoleService)) {
            this.checkExistingRoleService(config.getRoleServiceName());
        }
        if (config.getRoleSource().equals(PreAuthenticatedUserNameFilterConfig.PreAuthenticatedUserNameRoleSource.UserGroupService)) {
            this.checkExistingUGService(config.getUserGroupServiceName());
        }
        if (config.getRoleSource().equals(PreAuthenticatedUserNameFilterConfig.PreAuthenticatedUserNameRoleSource.Header)) {
            if (!this.isNotEmpty(config.getRolesHeaderAttribute())) {
                throw this.createFilterException("ROLES_HEADER_ATTRIBUTE_NEEDED", new Object[0]);
            }
            if (this.isNotEmpty(config.getRoleConverterName())) {
                try {
                    this.lookupBean(config.getRoleConverterName());
                }
                catch (NoSuchBeanDefinitionException ex) {
                    throw this.createFilterException("UNKNOWN_ROLE_CONVERTER", config.getRoleConverterName());
                }
            }
        }
    }

    public void validateFilterConfig(J2eeAuthenticationFilterConfig config) throws FilterConfigException {
        this.validateFilterConfig((J2eeAuthenticationBaseFilterConfig)config);
    }

    public void validateFilterConfig(ExceptionTranslationFilterConfig config) throws FilterConfigException {
        if (this.isNotEmpty(config.getAuthenticationFilterName())) {
            try {
                SecurityFilterConfig securityFilterConfig;
                SecurityFilterConfig filterConfig = this.manager.loadFilterConfig(config.getAuthenticationFilterName(), true);
                if (filterConfig == null) {
                    throw this.createFilterException("INVALID_ENTRY_POINT", config.getAuthenticationFilterName());
                }
                boolean valid = false;
                if (filterConfig instanceof SecurityFilterConfig && (securityFilterConfig = filterConfig).providesAuthenticationEntryPoint()) {
                    valid = true;
                }
                if (!valid) {
                    throw this.createFilterException("NO_AUTH_ENTRY_POINT", config.getAuthenticationFilterName());
                }
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
    }
}

