/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.validation;

import java.io.IOException;
import org.geoserver.security.GeoServerUserGroupService;
import org.geoserver.security.GeoServerUserGroupStore;
import org.geoserver.security.impl.GeoServerUser;
import org.geoserver.security.impl.GeoServerUserGroup;
import org.geoserver.security.validation.PasswordPolicyException;
import org.geoserver.security.validation.UserGroupServiceValidationWrapper;

public class UserGroupStoreValidationWrapper
extends UserGroupServiceValidationWrapper
implements GeoServerUserGroupStore {
    public UserGroupStoreValidationWrapper(GeoServerUserGroupStore store) {
        super(store);
    }

    GeoServerUserGroupStore getStore() {
        return (GeoServerUserGroupStore)this.service;
    }

    @Override
    public void initializeFromService(GeoServerUserGroupService service) throws IOException {
        this.getStore().initializeFromService(service);
    }

    @Override
    public void clear() throws IOException {
        this.getStore().clear();
    }

    @Override
    public void addUser(GeoServerUser user) throws IOException, PasswordPolicyException {
        this.checkNotExistingUserName(user.getUsername());
        this.getStore().addUser(user);
    }

    @Override
    public void updateUser(GeoServerUser user) throws IOException, PasswordPolicyException {
        this.checkExistingUserName(user.getUsername());
        this.getStore().updateUser(user);
    }

    @Override
    public boolean removeUser(GeoServerUser user) throws IOException {
        return this.getStore().removeUser(user);
    }

    @Override
    public void addGroup(GeoServerUserGroup group) throws IOException {
        this.checkNotExistingGroupName(group.getGroupname());
        this.getStore().addGroup(group);
    }

    @Override
    public void updateGroup(GeoServerUserGroup group) throws IOException {
        this.checkExistingGroupName(group.getGroupname());
        this.getStore().updateGroup(group);
    }

    @Override
    public boolean removeGroup(GeoServerUserGroup group) throws IOException {
        return this.getStore().removeGroup(group);
    }

    @Override
    public void store() throws IOException {
        this.getStore().store();
    }

    @Override
    public void associateUserToGroup(GeoServerUser user, GeoServerUserGroup group) throws IOException {
        this.checkExistingUserName(user.getUsername());
        this.checkExistingGroupName(group.getGroupname());
        this.getStore().associateUserToGroup(user, group);
    }

    @Override
    public void disAssociateUserFromGroup(GeoServerUser user, GeoServerUserGroup group) throws IOException {
        this.checkExistingUserName(user.getUsername());
        this.checkExistingGroupName(group.getGroupname());
        this.getStore().disAssociateUserFromGroup(user, group);
    }

    @Override
    public boolean isModified() {
        return this.getStore().isModified();
    }
}

