/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.xml;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Properties;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import org.geoserver.platform.resource.Files;
import org.geoserver.platform.resource.Resource;
import org.geoserver.security.GeoServerUserGroupStore;
import org.geoserver.security.KeyStoreProvider;
import org.geoserver.security.config.FileBasedSecurityServiceConfig;
import org.geoserver.security.config.SecurityNamedServiceConfig;
import org.geoserver.security.config.SecurityUserGroupServiceConfig;
import org.geoserver.security.impl.AbstractUserGroupService;
import org.geoserver.security.impl.GeoServerUser;
import org.geoserver.security.impl.GeoServerUserGroup;
import org.geoserver.security.impl.Util;
import org.geoserver.security.password.GeoServerPasswordEncoder;
import org.geoserver.security.password.PasswordEncodingType;
import org.geoserver.security.xml.UserGroupXMLXpath;
import org.geoserver.security.xml.XMLGeoserverUser;
import org.geoserver.security.xml.XMLSecurityServiceConfig;
import org.geoserver.security.xml.XMLUserGroupStore;
import org.geoserver.security.xml.XMLValidator;
import org.geoserver.security.xml.XMLXpathFactory;
import org.geoserver.util.IOUtils;
import org.geotools.util.logging.Logging;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class XMLUserGroupService
extends AbstractUserGroupService {
    static Logger LOGGER = Logging.getLogger((String)"org.geoserver.security.xml");
    protected DocumentBuilder builder;
    protected Resource userResource;
    private boolean validatingXMLSchema = true;

    public XMLUserGroupService() throws IOException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        factory.setIgnoringComments(true);
        try {
            this.builder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void initializeFromConfig(SecurityNamedServiceConfig config) throws IOException {
        FileBasedSecurityServiceConfig serviceConfig;
        String alias;
        KeyStoreProvider prov;
        this.name = config.getName();
        this.validatingXMLSchema = false;
        this.passwordEncoderName = ((SecurityUserGroupServiceConfig)config).getPasswordEncoderName();
        this.passwordValidatorName = ((SecurityUserGroupServiceConfig)config).getPasswordPolicyName();
        GeoServerPasswordEncoder enc = this.getSecurityManager().loadPasswordEncoder(this.passwordEncoderName);
        if (enc.getEncodingType() == PasswordEncodingType.ENCRYPT && !(prov = this.getSecurityManager().getKeyStoreProvider()).containsAlias(alias = prov.aliasForGroupService(this.name))) {
            prov.setUserGroupKey(this.name, this.getSecurityManager().getRandomPassworddProvider().getRandomPasswordWithDefaultLength());
            prov.storeKeyStore();
        }
        enc.initializeFor(this);
        if (config instanceof XMLSecurityServiceConfig) {
            serviceConfig = (XMLSecurityServiceConfig)config;
            this.validatingXMLSchema = ((XMLSecurityServiceConfig)serviceConfig).isValidating();
            Resource xsdFile = this.getConfigRoot().get("users.xsd");
            if (xsdFile.getType() == Resource.Type.UNDEFINED) {
                IOUtils.copy((InputStream)this.getClass().getResourceAsStream("users.xsd"), (OutputStream)xsdFile.out());
            }
        }
        if (config instanceof FileBasedSecurityServiceConfig) {
            serviceConfig = (FileBasedSecurityServiceConfig)config;
            String fileName = serviceConfig.getFileName();
            File userFile = new File(fileName);
            this.userResource = userFile.isAbsolute() ? Files.asResource((File)userFile) : this.getConfigRoot().get(fileName);
            if (this.userResource.getType() == Resource.Type.UNDEFINED) {
                IOUtils.copy((InputStream)this.getClass().getResourceAsStream("usersTemplate.xml"), (OutputStream)this.userResource.out());
            }
        } else {
            throw new IOException("Cannot initialize from " + config.getClass().getName());
        }
        this.deserialize();
    }

    @Override
    public boolean canCreateStore() {
        return true;
    }

    @Override
    public GeoServerUserGroupStore createStore() throws IOException {
        XMLUserGroupStore store = new XMLUserGroupStore();
        store.initializeFromService(this);
        return store;
    }

    public boolean isValidatingXMLSchema() {
        return this.validatingXMLSchema;
    }

    public void setValidatingXMLSchema(boolean validatingXMLSchema) {
        this.validatingXMLSchema = validatingXMLSchema;
    }

    @Override
    protected void deserialize() throws IOException {
        try {
            Document doc = null;
            try (InputStream is = this.userResource.in();){
                doc = this.builder.parse(is);
            }
            catch (SAXException e) {
                throw new IOException(e);
            }
            if (this.isValidatingXMLSchema()) {
                XMLValidator.Singleton.validateUserGroupRegistry(doc);
            }
            XPathExpression expr = XMLXpathFactory.Singleton.getVersionExpressionUR();
            String versionNummer = expr.evaluate(doc);
            UserGroupXMLXpath xmlXPath = XMLXpathFactory.Singleton.getUserGroupXMLXpath(versionNummer);
            this.clearMaps();
            NodeList userNodes = (NodeList)xmlXPath.getUserListExpression().evaluate(doc, XPathConstants.NODESET);
            for (int i = 0; i < userNodes.getLength(); ++i) {
                Node userNode = userNodes.item(i);
                boolean userEnabled = Util.convertToBoolean(xmlXPath.getUserEnabledExpression().evaluate(userNode), true);
                String userPassword = null;
                if (userNode.getAttributes().getNamedItem("password") != null) {
                    userPassword = xmlXPath.getUserPasswordExpression().evaluate(userNode);
                }
                String userName = xmlXPath.getUserNameExpression().evaluate(userNode);
                NodeList propertyNodes = (NodeList)xmlXPath.getUserPropertiesExpression().evaluate(userNode, XPathConstants.NODESET);
                Properties userProps = new Properties();
                for (int j = 0; j < propertyNodes.getLength(); ++j) {
                    Node propertyNode = propertyNodes.item(j);
                    String string = xmlXPath.getPropertyNameExpression().evaluate(propertyNode);
                    String propertyValue = xmlXPath.getPropertyValueExpression().evaluate(propertyNode);
                    userProps.put(string, propertyValue);
                }
                GeoServerUser user = this.createUserObject(userName, userPassword, userEnabled);
                this.helper.userMap.put(user.getUsername(), user);
                user.getProperties().clear();
                for (Object e : userProps.keySet()) {
                    user.getProperties().put(e, userProps.get(e));
                    SortedSet<GeoServerUser> propUsers = this.helper.propertyMap.get(e);
                    if (propUsers == null) {
                        propUsers = new TreeSet<GeoServerUser>();
                        this.helper.propertyMap.put((String)e, propUsers);
                    }
                    propUsers.add(user);
                }
            }
            NodeList groupNodes = (NodeList)xmlXPath.getGroupListExpression().evaluate(doc, XPathConstants.NODESET);
            for (int i = 0; i < groupNodes.getLength(); ++i) {
                Node groupNode = groupNodes.item(i);
                String groupName = xmlXPath.getGroupNameExpression().evaluate(groupNode);
                boolean groupEnabled = Util.convertToBoolean(xmlXPath.getGroupEnabledExpression().evaluate(groupNode), true);
                GeoServerUserGroup group = this.createGroupObject(groupName, groupEnabled);
                this.helper.groupMap.put(groupName, group);
                NodeList memberNodes = (NodeList)xmlXPath.getGroupMemberListExpression().evaluate(groupNode, XPathConstants.NODESET);
                for (int j = 0; j < memberNodes.getLength(); ++j) {
                    Node memberNode = memberNodes.item(j);
                    String string = xmlXPath.getGroupMemberNameExpression().evaluate(memberNode);
                    GeoServerUser member = this.helper.userMap.get(string);
                    SortedSet<GeoServerUser> members = this.helper.group_userMap.get(group);
                    if (members == null) {
                        members = new TreeSet<GeoServerUser>();
                        this.helper.group_userMap.put(group, members);
                    }
                    members.add(member);
                    SortedSet<GeoServerUserGroup> userGroups = this.helper.user_groupMap.get(member);
                    if (userGroups == null) {
                        userGroups = new TreeSet<GeoServerUserGroup>();
                        this.helper.user_groupMap.put(member, userGroups);
                    }
                    userGroups.add(group);
                }
            }
        }
        catch (XPathExpressionException ex) {
            throw new IOException(ex);
        }
    }

    @Override
    public GeoServerUser createUserObject(String username, String password, boolean isEnabled) throws IOException {
        XMLGeoserverUser user = new XMLGeoserverUser(username);
        user.setEnabled(isEnabled);
        user.setPassword(password);
        return user;
    }
}

