/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.xml;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.NamespaceContext;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;

public abstract class XMLXpath {
    protected NamespaceContextImpl urContext = new NamespaceContextImpl();
    protected NamespaceContextImpl rrContext;

    protected XMLXpath() {
        this.urContext.register("gsu", "http://www.geoserver.org/security/users");
        this.rrContext = new NamespaceContextImpl();
        this.rrContext.register("gsr", "http://www.geoserver.org/security/roles");
    }

    protected XPathExpression compile(XPath xpath, String expression) {
        try {
            return xpath.compile(expression);
        }
        catch (XPathExpressionException e) {
            throw new RuntimeException(e);
        }
    }

    protected XPathExpression compileRelativeAttribute(XPath xpath, String attrName, String prefix) {
        return this.compile(xpath, "@" + attrName);
    }

    public static class NamespaceContextImpl
    implements NamespaceContext {
        private Map<String, String> prefix_ns_Map = new HashMap<String, String>();
        private Map<String, String> ns_prefix_Map = new HashMap<String, String>();

        @Override
        public String getNamespaceURI(String prefix) {
            return this.prefix_ns_Map.get(prefix);
        }

        @Override
        public String getPrefix(String namespaceURI) {
            return this.ns_prefix_Map.get(namespaceURI);
        }

        public Iterator getPrefixes(String namespaceURI) {
            return this.prefix_ns_Map.keySet().iterator();
        }

        public void register(String prefix, String ns) {
            this.prefix_ns_Map.put(prefix, ns);
            this.ns_prefix_Map.put(ns, prefix);
        }
    }
}

