/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.system.status;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geoserver.system.status.MetricInfo;
import org.geoserver.system.status.MetricValue;
import org.geotools.util.logging.Logging;
import oshi.SystemInfo;
import oshi.hardware.CentralProcessor;
import oshi.hardware.GlobalMemory;
import oshi.hardware.HardwareAbstractionLayer;
import oshi.hardware.NetworkIF;
import oshi.hardware.Sensors;
import oshi.software.os.FileSystem;
import oshi.software.os.OSFileStore;
import oshi.software.os.OSProcess;
import oshi.software.os.OperatingSystem;

public class OSHISystemInfoCollector
extends Thread {
    public static final int INTERVAL = 1000;
    private static final Logger logger = Logging.getLogger(OSHISystemInfoCollector.class);
    private final OperatingSystem os;
    private final HardwareAbstractionLayer hal;
    private final CentralProcessor pr;
    private final GlobalMemory mm;
    private final Sensors ss;
    private final FileSystem fs;
    private double cpuUsage = 0.0;
    private long[][] oldTicks;
    private long[] oldLoadTicks;

    public OSHISystemInfoCollector() {
        SystemInfo si = new SystemInfo();
        this.os = si.getOperatingSystem();
        this.hal = si.getHardware();
        this.pr = this.hal.getProcessor();
        this.mm = this.hal.getMemory();
        this.ss = this.hal.getSensors();
        this.fs = this.os.getFileSystem();
        this.oldTicks = this.pr.getProcessorCpuLoadTicks();
        this.oldLoadTicks = this.pr.getSystemCpuLoadTicks();
    }

    @Override
    public void run() {
        try {
            OSProcess process = this.os.getProcess(this.os.getProcessId());
            long previousCPUTime = process.getKernelTime() + process.getUserTime();
            while (!this.isInterrupted()) {
                Thread.sleep(1000L);
                long currentCPUTime = process.getKernelTime() + process.getUserTime();
                double timeDifference = currentCPUTime - previousCPUTime;
                int processors = this.pr.getLogicalProcessorCount();
                if (processors < 0) {
                    processors = 1;
                }
                this.cpuUsage = 100.0 * timeDifference / 1000.0 / (double)processors;
                previousCPUTime = currentCPUTime;
            }
        }
        catch (InterruptedException e) {
            this.interrupt();
        }
    }

    List<MetricValue> retrieveSystemInfo(MetricInfo info) {
        List<Object> si = Collections.emptyList();
        try {
            switch (info) {
                case OPERATING_SYSTEM: {
                    MetricValue mv = new MetricValue(info);
                    mv.setAvailable(true);
                    mv.setValue(this.os.getFamily() + " " + this.os.getVersionInfo().getVersion());
                    si = Collections.singletonList(mv);
                    break;
                }
                case SYSTEM_UPTIME: {
                    MetricValue mv = new MetricValue(info);
                    mv.setAvailable(true);
                    mv.setValue(this.os.getSystemUptime());
                    si = Collections.singletonList(mv);
                    break;
                }
                case SYSTEM_AVERAGE_LOAD_1: {
                    MetricValue mv = new MetricValue(info);
                    double lv = this.pr.getSystemLoadAverage(1)[0];
                    if (!(lv > 0.0)) break;
                    mv.setAvailable(true);
                    mv.setValue(lv);
                    si = Collections.singletonList(mv);
                    break;
                }
                case SYSTEM_AVERAGE_LOAD_5: {
                    MetricValue mv = new MetricValue(info);
                    double lv = this.pr.getSystemLoadAverage(2)[1];
                    if (!(lv > 0.0)) break;
                    mv.setAvailable(true);
                    mv.setValue(lv);
                    si = Collections.singletonList(mv);
                    break;
                }
                case SYSTEM_AVERAGE_LOAD_15: {
                    MetricValue mv = new MetricValue(info);
                    double lv = this.pr.getSystemLoadAverage(3)[2];
                    if (!(lv > 0.0)) break;
                    mv.setAvailable(true);
                    mv.setValue(lv);
                    si = Collections.singletonList(mv);
                    break;
                }
                case PHYSICAL_CPUS: {
                    MetricValue mv = new MetricValue(info);
                    mv.setAvailable(true);
                    mv.setValue(this.pr.getPhysicalProcessorCount());
                    si = Collections.singletonList(mv);
                    break;
                }
                case LOGICAL_CPUS: {
                    MetricValue mv = new MetricValue(info);
                    mv.setAvailable(true);
                    mv.setValue(this.pr.getLogicalProcessorCount());
                    si = Collections.singletonList(mv);
                    break;
                }
                case RUNNING_PROCESS: {
                    MetricValue mv = new MetricValue(info);
                    mv.setAvailable(true);
                    mv.setValue(this.os.getProcessCount());
                    si = Collections.singletonList(mv);
                    break;
                }
                case RUNNING_THREADS: {
                    MetricValue mv = new MetricValue(info);
                    mv.setAvailable(true);
                    mv.setValue(this.os.getThreadCount());
                    si = Collections.singletonList(mv);
                    break;
                }
                case CPU_LOAD: {
                    MetricValue mv = new MetricValue(info);
                    double cpuLoad = this.pr.getSystemCpuLoadBetweenTicks(this.oldLoadTicks);
                    this.oldLoadTicks = this.pr.getSystemCpuLoadTicks();
                    if (!(cpuLoad >= 0.0)) break;
                    mv.setAvailable(true);
                    mv.setValue(cpuLoad * 100.0);
                    mv.setDescription("CPU load average");
                    si = Collections.singletonList(mv);
                    break;
                }
                case PER_CPU_LOAD: {
                    si = new ArrayList<MetricValue>();
                    double[] loads = this.pr.getProcessorCpuLoadBetweenTicks(this.oldTicks);
                    this.oldTicks = this.pr.getProcessorCpuLoadTicks();
                    if (loads.length <= 0) break;
                    for (int i = 0; i < loads.length; ++i) {
                        double value = loads[i] * 100.0;
                        String description = "CPU " + (i + 1) + " load";
                        MetricValue mv = new MetricValue(info);
                        mv.setValue(value);
                        mv.setAvailable(true);
                        mv.setDescription(description);
                        mv.setPriority(info.getPriority() + i);
                        mv.setIdentifier("CPU " + (i + 1));
                        si.add(mv);
                    }
                    break;
                }
                case MEMORY_USED: {
                    MetricValue mv = new MetricValue(info);
                    mv.setAvailable(true);
                    double total = this.mm.getTotal();
                    if (total > 0.0) {
                        double used = total - (double)this.mm.getAvailable();
                        mv.setValue(used / total * 100.0);
                    } else {
                        mv.setValue(0);
                    }
                    si = Collections.singletonList(mv);
                    break;
                }
                case MEMORY_TOTAL: {
                    MetricValue mv = new MetricValue(info);
                    mv.setAvailable(true);
                    mv.setValue(this.mm.getTotal());
                    si = Collections.singletonList(mv);
                    break;
                }
                case MEMORY_FREE: {
                    MetricValue mv = new MetricValue(info);
                    mv.setAvailable(true);
                    mv.setValue(this.mm.getAvailable());
                    si = Collections.singletonList(mv);
                    break;
                }
                case SWAP_USED: {
                    MetricValue mv = new MetricValue(info);
                    mv.setAvailable(true);
                    double total = this.mm.getVirtualMemory().getSwapTotal();
                    if (total > 0.0) {
                        double used = this.mm.getVirtualMemory().getSwapUsed();
                        mv.setValue(used / total * 100.0);
                    } else {
                        mv.setValue(0);
                    }
                    si = Collections.singletonList(mv);
                    break;
                }
                case SWAP_TOTAL: {
                    MetricValue mv = new MetricValue(info);
                    mv.setAvailable(true);
                    mv.setValue(this.mm.getVirtualMemory().getSwapTotal());
                    si = Collections.singletonList(mv);
                    break;
                }
                case SWAP_FREE: {
                    MetricValue mv = new MetricValue(info);
                    mv.setAvailable(true);
                    long total = this.mm.getVirtualMemory().getSwapTotal();
                    long free = total - this.mm.getVirtualMemory().getSwapUsed();
                    mv.setValue(free);
                    si = Collections.singletonList(mv);
                    break;
                }
                case FILE_SYSTEM_TOTAL_USAGE: {
                    List fss = this.fs.getFileStores();
                    if (fss.isEmpty()) break;
                    double total = 0.0;
                    double used = 0.0;
                    for (OSFileStore fs : fss) {
                        double fsTotal = fs.getTotalSpace();
                        total += fsTotal;
                        used += fsTotal - (double)fs.getUsableSpace();
                    }
                    MetricValue mv = new MetricValue(info);
                    if (total > 0.0) {
                        mv.setValue(used / total * 100.0);
                    } else {
                        mv.setValue(0);
                    }
                    mv.setAvailable(true);
                    si = Collections.singletonList(mv);
                    break;
                }
                case PARTITION_USED: {
                    List fss = this.fs.getFileStores();
                    if (fss.isEmpty()) break;
                    si = new ArrayList<MetricValue>();
                    int i = 0;
                    for (OSFileStore fs : fss) {
                        MetricValue mv = new MetricValue(info);
                        double total = fs.getTotalSpace();
                        if (total > 0.0) {
                            double used = total - (double)fs.getUsableSpace();
                            mv.setValue(used / total * 100.0);
                        } else {
                            mv.setValue(0);
                        }
                        mv.setAvailable(true);
                        mv.setDescription("Partition [" + fs.getName() + "] used space");
                        mv.setPriority(info.getPriority() + (i + 1) * 3);
                        mv.setIdentifier(fs.getName());
                        si.add(mv);
                    }
                    break;
                }
                case PARTITION_TOTAL: {
                    List fss = this.fs.getFileStores();
                    if (fss.isEmpty()) break;
                    si = new ArrayList<MetricValue>();
                    int i = 0;
                    for (OSFileStore fs : fss) {
                        MetricValue mv = new MetricValue(info);
                        mv.setValue(fs.getTotalSpace());
                        mv.setAvailable(true);
                        mv.setDescription("Partition [" + fs.getName() + "] total space");
                        mv.setPriority(info.getPriority() + (i + 1) * 3);
                        mv.setIdentifier(fs.getName());
                        si.add(mv);
                    }
                    break;
                }
                case PARTITION_FREE: {
                    List fss = this.fs.getFileStores();
                    if (fss.isEmpty()) break;
                    si = new ArrayList<MetricValue>();
                    int i = 0;
                    for (OSFileStore fs : fss) {
                        MetricValue mv = new MetricValue(info);
                        mv.setValue(fs.getUsableSpace());
                        mv.setAvailable(true);
                        mv.setDescription("Partition [" + fs.getName() + "] free space");
                        mv.setPriority(info.getPriority() + (i + 1) * 3);
                        mv.setIdentifier(fs.getName());
                        si.add(mv);
                    }
                    break;
                }
                case NETWORK_INTERFACES_SEND: {
                    List nis = this.hal.getNetworkIFs();
                    if (nis.isEmpty()) break;
                    double total = 0.0;
                    for (NetworkIF ni : nis) {
                        ni.updateAttributes();
                        total += (double)ni.getBytesSent();
                    }
                    MetricValue mv = new MetricValue(info);
                    mv.setValue(total);
                    mv.setAvailable(true);
                    si = Collections.singletonList(mv);
                    break;
                }
                case NETWORK_INTERFACES_RECEIVED: {
                    List nis = this.hal.getNetworkIFs();
                    if (nis.isEmpty()) break;
                    double total = 0.0;
                    for (NetworkIF ni : nis) {
                        ni.updateAttributes();
                        total += (double)ni.getBytesRecv();
                    }
                    MetricValue mv = new MetricValue(info);
                    mv.setValue(total);
                    mv.setAvailable(true);
                    si = Collections.singletonList(mv);
                    break;
                }
                case NETWORK_INTERFACE_SEND: {
                    List nis = this.hal.getNetworkIFs();
                    if (nis.isEmpty()) break;
                    si = new ArrayList<MetricValue>();
                    int i = 0;
                    for (NetworkIF ni : nis) {
                        ni.updateAttributes();
                        MetricValue mv = new MetricValue(info);
                        mv.setValue(ni.getBytesSent());
                        mv.setAvailable(true);
                        mv.setDescription("Network interface [" + ni.getName() + "] send");
                        mv.setPriority(info.getPriority() + (i + 1) * 3);
                        mv.setIdentifier(ni.getName());
                        si.add(mv);
                    }
                    break;
                }
                case NETWORK_INTERFACE_RECEIVED: {
                    List nis = this.hal.getNetworkIFs();
                    if (nis.isEmpty()) break;
                    si = new ArrayList<MetricValue>();
                    int i = 0;
                    for (NetworkIF ni : nis) {
                        ni.updateAttributes();
                        MetricValue mv = new MetricValue(info);
                        mv.setValue(ni.getBytesRecv());
                        mv.setAvailable(true);
                        mv.setDescription("Network interface [" + ni.getName() + "] received");
                        mv.setPriority(info.getPriority() + i++ * 3);
                        mv.setIdentifier(ni.getName());
                        si.add(mv);
                    }
                    break;
                }
                case TEMPERATURE: {
                    double value = this.ss.getCpuTemperature();
                    if (!(value > 0.0)) break;
                    MetricValue mv = new MetricValue(info);
                    mv.setAvailable(true);
                    mv.setValue(value);
                    si = Collections.singletonList(mv);
                    break;
                }
                case VOLTAGE: {
                    double value = this.ss.getCpuVoltage();
                    if (!(value > 0.0)) break;
                    MetricValue mv = new MetricValue(info);
                    mv.setAvailable(true);
                    mv.setValue(value);
                    si = Collections.singletonList(mv);
                    break;
                }
                case FAN_SPEED: {
                    int[] speeds = this.ss.getFanSpeeds();
                    if (speeds.length <= 0) break;
                    ArrayList<MetricValue> tmp = new ArrayList<MetricValue>(speeds.length);
                    for (int i = 0; i < speeds.length; ++i) {
                        if (speeds[i] <= 0) continue;
                        int value = speeds[i];
                        String name = info.name() + "_" + (i + 1);
                        String description = "Speed fan " + (i + 1);
                        MetricValue mv = new MetricValue(info);
                        mv.setValue(value);
                        mv.setAvailable(true);
                        mv.setDescription(description);
                        mv.setName(name);
                        tmp.add(mv);
                    }
                    if (!tmp.isEmpty()) {
                        si = tmp;
                    }
                    break;
                }
                case GEOSERVER_CPU_USAGE: {
                    if (!(this.cpuUsage >= 0.0)) break;
                    MetricValue mv = new MetricValue(info);
                    mv.setAvailable(true);
                    mv.setValue(this.cpuUsage);
                    si = Collections.singletonList(mv);
                    break;
                }
                case GEOSERVER_THREADS: {
                    OSProcess gsProc = this.os.getProcess(this.os.getProcessId());
                    MetricValue mv = new MetricValue(info);
                    mv.setAvailable(true);
                    mv.setValue(gsProc.getThreadCount());
                    si = Collections.singletonList(mv);
                    break;
                }
                case GEOSERVER_JVM_MEMORY_USAGE: {
                    OSProcess gsProc = this.os.getProcess(this.os.getProcessId());
                    MetricValue mv = new MetricValue(info);
                    mv.setAvailable(true);
                    double total = this.mm.getTotal();
                    if (total > 0.0) {
                        double value = 100.0 * (double)gsProc.getResidentSetSize() / total;
                        mv.setValue(value);
                    } else {
                        mv.setValue(0);
                    }
                    si = Collections.singletonList(mv);
                    break;
                }
            }
        }
        catch (Throwable e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
        return si;
    }
}

