/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.template;

import com.google.common.base.Splitter;
import freemarker.ext.beans.ClassMemberAccessPolicy;
import freemarker.ext.beans.DefaultMemberAccessPolicy;
import freemarker.ext.beans.MemberAccessPolicy;
import freemarker.template.Version;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.util.List;
import java.util.function.Predicate;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.xml.namespace.QName;
import org.geoserver.catalog.Catalog;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.platform.resource.ResourceStore;
import org.geoserver.template.TemplateUtils;
import org.geotools.api.coverage.grid.GridCoverageReader;
import org.geotools.api.coverage.grid.GridCoverageWriter;
import org.geotools.api.data.DataAccess;
import org.geotools.util.logging.Logging;

public final class GeoServerMemberAccessPolicy
implements MemberAccessPolicy {
    private static final Logger LOGGER = Logging.getLogger(GeoServerMemberAccessPolicy.class);
    public static final String FREEMARKER_ALLOW_LIST = "GEOSERVER_FREEMARKER_ALLOW_LIST";
    public static final String FREEMARKER_BLOCK_LIST = "GEOSERVER_FREEMARKER_BLOCK_LIST";
    public static final String FREEMARKER_API_EXPOSED = "GEOSERVER_FREEMARKER_API_EXPOSED";
    private static final DefaultMemberAccessPolicy DEFAULT_POLICY = DefaultMemberAccessPolicy.getInstance((Version)TemplateUtils.FM_VERSION);
    private static final List<Object> DEFAULT_ALLOW = List.of("java.", QName.class, "net.opengis.", "org.geoserver.", "org.geotools.", "org.locationtech.jts.geom.");
    private static final List<Object> DEFAULT_BLOCK = List.of(InputStream.class, OutputStream.class, Class.class, ClassLoader.class, InvocationHandler.class, "java.lang.reflect.", "java.security.", Catalog.class, ResourceStore.class, DataAccess.class, GridCoverageReader.class, GridCoverageWriter.class);
    private static final Predicate<Class<?>> DEFAULT_STATIC_ACCESS = clazz -> false;
    public static final GeoServerMemberAccessPolicy DEFAULT_ACCESS = new GeoServerMemberAccessPolicy(null, null, null);
    public static final GeoServerMemberAccessPolicy FULL_ACCESS = new GeoServerMemberAccessPolicy(true, null, null);
    public static final GeoServerMemberAccessPolicy LIMIT_ACCESS = new GeoServerMemberAccessPolicy(false, null, null);
    private final Boolean forceApiExposed;
    private final List<Object> forceAllowList;
    private final Predicate<Class<?>> staticAccess;
    private volatile List<Object> allowList = null;
    private volatile List<Object> blockList = null;
    private volatile Boolean apiExposed = null;

    private GeoServerMemberAccessPolicy(Boolean apiExposed, List<Object> allowList, Predicate<Class<?>> staticAccess) {
        this.apiExposed = this.forceApiExposed = apiExposed;
        this.forceAllowList = allowList != null ? allowList : List.of();
        this.staticAccess = staticAccess != null ? staticAccess : DEFAULT_STATIC_ACCESS;
    }

    public GeoServerMemberAccessPolicy withAllowList(Object ... allowList) {
        return new GeoServerMemberAccessPolicy(this.forceApiExposed, List.of(allowList), this.staticAccess);
    }

    public GeoServerMemberAccessPolicy withStaticAccess(Predicate<Class<?>> staticAccess) {
        return new GeoServerMemberAccessPolicy(this.forceApiExposed, this.forceAllowList, staticAccess);
    }

    public ClassMemberAccessPolicy forClass(Class<?> contextClass) {
        return new GeoServerClassMemberAccessPolicy(contextClass);
    }

    public boolean isToStringAlwaysExposed() {
        return true;
    }

    public synchronized void reset() {
        this.allowList = null;
        this.blockList = null;
        this.apiExposed = this.forceApiExposed;
    }

    private List<Object> getAllowList() {
        if (this.allowList == null) {
            this.init();
        }
        return this.allowList;
    }

    private List<Object> getBlockList() {
        if (this.blockList == null) {
            this.init();
        }
        return this.blockList;
    }

    private boolean isApiExposed() {
        if (this.apiExposed == null) {
            this.init();
        }
        return this.apiExposed;
    }

    private synchronized void init() {
        if (this.allowList == null) {
            List<Object> list2 = DEFAULT_ALLOW;
            if (!this.forceAllowList.isEmpty()) {
                list2 = Stream.concat(list2.stream(), this.forceAllowList.stream()).collect(Collectors.toUnmodifiableList());
            }
            this.allowList = GeoServerMemberAccessPolicy.parseList(FREEMARKER_ALLOW_LIST, list2);
        }
        if (this.blockList == null) {
            this.blockList = GeoServerMemberAccessPolicy.parseList(FREEMARKER_BLOCK_LIST, DEFAULT_BLOCK);
        }
        if (this.apiExposed == null) {
            this.apiExposed = Boolean.parseBoolean(GeoServerExtensions.getProperty((String)FREEMARKER_API_EXPOSED));
        }
    }

    private static List<Object> parseList(String key, List<Object> defaults) {
        String value = GeoServerExtensions.getProperty((String)key);
        if (value == null || value.isBlank()) {
            return defaults;
        }
        Stream<Object> stream = Splitter.on((char)',').trimResults().omitEmptyStrings().splitToStream((CharSequence)value).map(name -> {
            try {
                return Class.forName(name);
            }
            catch (ClassNotFoundException e) {
                return name;
            }
        });
        return Stream.concat(defaults.stream(), stream).collect(Collectors.toUnmodifiableList());
    }

    private final class GeoServerClassMemberAccessPolicy
    implements ClassMemberAccessPolicy {
        private final Class<?> contextClass;
        private final boolean isContextClassAllowed;
        private final ClassMemberAccessPolicy defaultPolicy;

        private GeoServerClassMemberAccessPolicy(Class<?> contextClass) {
            this.contextClass = contextClass;
            this.isContextClassAllowed = this.isClassAllowed(contextClass);
            this.defaultPolicy = DEFAULT_POLICY.forClass(contextClass);
        }

        public boolean isConstructorExposed(Constructor<?> constructor) {
            return false;
        }

        public boolean isFieldExposed(Field field) {
            boolean exposed;
            if (!this.defaultPolicy.isFieldExposed(field)) {
                return false;
            }
            boolean bl = exposed = this.isContextClassAllowed && Modifier.isFinal(field.getModifiers()) && GeoServerMemberAccessPolicy.this.staticAccess.test(this.contextClass) && this.isClassAllowed(field.getType());
            if (!exposed) {
                LOGGER.finer(() -> "Blocked access to field " + this.contextClass.getName() + "." + field.getName());
            }
            return exposed;
        }

        public boolean isMethodExposed(Method method) {
            if (!this.defaultPolicy.isMethodExposed(method)) {
                return false;
            }
            if (method.getParameterCount() == 0 && method.getName().equals("toString")) {
                return true;
            }
            boolean exposed = false;
            if (this.isClassAllowed(method.getReturnType())) {
                exposed = !Modifier.isStatic(method.getModifiers()) ? this.isContextClassAllowed && this.checkGetterMethod(method) : GeoServerMemberAccessPolicy.this.staticAccess.test(this.contextClass);
            }
            if (!exposed) {
                LOGGER.finer(() -> "Blocked access to method " + this.contextClass.getName() + "." + method.getName());
            }
            return exposed;
        }

        private boolean checkGetterMethod(Method method) {
            if (GeoServerMemberAccessPolicy.this.isApiExposed()) {
                return true;
            }
            boolean exposed = false;
            if (method.getParameterCount() == 0) {
                String name = method.getName();
                Class<?> type = method.getReturnType();
                if (name.startsWith("get") && name.length() > 3) {
                    exposed = !type.equals(Void.TYPE);
                } else if (name.startsWith("is") && name.length() > 2) {
                    exposed = type.equals(Boolean.TYPE) || type.equals(Boolean.class);
                }
            }
            return exposed;
        }

        private boolean isClassAllowed(Class<?> clazz) {
            if (clazz.equals(Void.TYPE)) {
                return false;
            }
            if (Proxy.isProxyClass(clazz)) {
                List interfaces = Stream.of(clazz.getInterfaces()).filter(c -> c.getName().startsWith("org.geoserver.")).collect(Collectors.toUnmodifiableList());
                return !interfaces.isEmpty() && interfaces.stream().noneMatch(c -> this.matchesAny((Class<?>)c, GeoServerMemberAccessPolicy.this.getBlockList()));
            }
            Class<?> actual = clazz;
            while (actual.isArray()) {
                actual = actual.getComponentType();
            }
            return actual.isPrimitive() || this.matchesAny(actual, GeoServerMemberAccessPolicy.this.getAllowList()) && !this.matchesAny(actual, GeoServerMemberAccessPolicy.this.getBlockList());
        }

        private boolean matchesAny(Class<?> clazz, List<Object> list2) {
            String name = clazz.getName();
            return list2.stream().anyMatch(object -> {
                boolean bl;
                if (object instanceof Class) {
                    Class c = (Class)object;
                    bl = c.isAssignableFrom(clazz);
                } else {
                    bl = name.startsWith((String)object);
                }
                return bl;
            });
        }
    }
}

