/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.util;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.SystemUtils;
import org.geoserver.config.GeoServer;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.platform.GeoServerResourceLoader;
import org.geoserver.util.EntityResolverProvider;
import org.geotools.util.logging.Logging;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.ext.EntityResolver2;

public class AllowListEntityResolver
implements EntityResolver2,
Serializable {
    public static final String ENTITY_RESOLUTION_UNRESTRICTED_INTERNAL = "ENTITY_RESOLUTION_UNRESTRICTED_INTERNAL";
    public static String UNRESTRICTED = "*";
    public static String OGC1 = "schemas.opengis.net";
    public static String OGC2 = "www.opengis.net";
    public static String OGC = OGC1 + "|" + OGC2;
    public static String INSPIRE = "inspire.ec.europa.eu/schemas";
    public static String W3C = "www.w3.org";
    private static final String ERROR_MESSAGE_BASE = "Entity resolution disallowed for ";
    protected static final Logger LOGGER = Logging.getLogger(AllowListEntityResolver.class);
    private static final Pattern INTERNAL_URIS = Pattern.compile("(?i)(jar:file|vfs)[^?#;]*\\.xsd");
    private static final Pattern XSD_URIS = Pattern.compile("(?i)^[^?#;]*\\.xsd$");
    private static final Pattern BANNED_ESCAPES = Pattern.compile("(?i)^.*%(2e|2f|5c).*$");
    private static final Pattern WINDOWS_DRIVE = Pattern.compile("^/[a-zA-Z]:/.*$");
    private final Pattern ALLOWED_URIS;
    private final String baseURL;
    private final GeoServer geoServer;
    private final String geoServerLib;

    public AllowListEntityResolver(GeoServer geoServer) {
        this(geoServer, null);
    }

    public AllowListEntityResolver(GeoServer geoServer, String baseURL) {
        this.geoServer = geoServer;
        this.baseURL = baseURL;
        if (EntityResolverProvider.ALLOW_LIST == null || EntityResolverProvider.ALLOW_LIST.isEmpty()) {
            this.ALLOWED_URIS = Pattern.compile("(?i)(http|https)://(" + Pattern.quote(W3C) + "|" + Pattern.quote(OGC1) + "|" + Pattern.quote(OGC2) + "|" + Pattern.quote(INSPIRE) + ")/[^?#;]*\\.xsd");
        } else {
            StringBuilder pattern = new StringBuilder("(?i)(http|https)://(");
            boolean first = true;
            for (String allow : EntityResolverProvider.ALLOW_LIST) {
                if (first) {
                    first = false;
                } else {
                    pattern.append('|');
                }
                pattern.append(Pattern.quote(allow));
            }
            pattern.append(")/[^?#;]*\\.xsd");
            String regex = pattern.toString();
            LOGGER.fine("ENTITY_RESOLUTION_ALLOWLIST processed:" + regex);
            this.ALLOWED_URIS = Pattern.compile(regex);
        }
        this.geoServerLib = this.getGeoServerLibDir();
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
        return this.resolveEntity(null, publicId, null, systemId);
    }

    @Override
    public InputSource getExternalSubset(String name, String baseURI) throws SAXException, IOException {
        return this.resolveEntity(name, null, baseURI, null);
    }

    @Override
    public InputSource resolveEntity(String name, String publicId, String baseURI, String systemId) throws SAXException, IOException {
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest("resolveEntity request: name=%s, publicId=%s, baseURI=%s, systemId=%s".formatted(name, publicId, baseURI, systemId));
        }
        try {
            String proxyBase;
            Object uri;
            if (systemId == null) {
                if (name != null) {
                    LOGGER.finest("resolveEntity name: " + name);
                    return null;
                }
                throw new SAXException("External entity systemId not provided");
            }
            if (URI.create(systemId).isAbsolute()) {
                uri = systemId;
            } else {
                if (baseURI == null) {
                    throw new SAXException(ERROR_MESSAGE_BASE + systemId);
                }
                uri = (baseURI.endsWith(".xsd") || baseURI.endsWith(".XSD")) && baseURI.lastIndexOf(47) != -1 ? baseURI.substring(0, baseURI.lastIndexOf(47)) + "/" + systemId : baseURI + "/" + systemId;
            }
            uri = AllowListEntityResolver.normalize((String)uri);
            if (INTERNAL_URIS.matcher((CharSequence)uri).matches() && ((String)uri).startsWith(this.geoServerLib)) {
                LOGGER.finest("resolveEntity internal: " + (String)uri);
                return null;
            }
            if (this.ALLOWED_URIS.matcher((CharSequence)uri).matches()) {
                LOGGER.finest("resolveEntity allowed: " + (String)uri);
                return null;
            }
            String string = GeoServerExtensions.getProperty((String)"PROXY_BASE_URL") != null ? GeoServerExtensions.getProperty((String)"PROXY_BASE_URL") : (proxyBase = this.geoServer != null ? this.geoServer.getSettings().getProxyBaseUrl() : null);
            if (AllowListEntityResolver.urlStartsWith((String)uri, proxyBase)) {
                LOGGER.finest("resolveEntity proxy base: " + (String)uri);
                return null;
            }
            if (this.geoServer != null && this.isDataDirectorySchema(systemId)) {
                LOGGER.finest("resolveEntity data directory: " + systemId);
                return null;
            }
            if (AllowListEntityResolver.urlStartsWith((String)uri, this.baseURL)) {
                LOGGER.finest("resolveEntity base url: " + (String)uri);
                return null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        throw new SAXException(ERROR_MESSAGE_BASE + systemId);
    }

    private String getGeoServerLibDir() {
        if (Boolean.parseBoolean(GeoServerExtensions.getProperty((String)ENTITY_RESOLUTION_UNRESTRICTED_INTERNAL))) {
            return "";
        }
        String url = this.getClass().getResource("/DEFAULT_LOGGING.xml").toString();
        url = url.substring(0, url.lastIndexOf(47));
        return url.substring(0, url.lastIndexOf(47) + 1);
    }

    private boolean isDataDirectorySchema(String systemId) throws IOException {
        String uri = AllowListEntityResolver.normalize(systemId);
        if (!uri.startsWith("file:")) {
            return false;
        }
        GeoServerResourceLoader resourceLoader = this.geoServer.getCatalog().getResourceLoader();
        String path = resourceLoader.get("workspaces").dir().getPath();
        return AllowListEntityResolver.urlStartsWith(uri, AllowListEntityResolver.normalize("file:", AllowListEntityResolver.toAbsolutePath(path), true, false));
    }

    private static String normalize(String uri) throws IOException {
        if (!URI.create((String)uri).isAbsolute()) {
            uri = "file:" + (String)uri;
        }
        if (!((String)uri).startsWith("vfs:/")) {
            new URL((String)uri);
        }
        String lower = ((String)uri).toLowerCase();
        if (!XSD_URIS.matcher((CharSequence)uri).matches() || BANNED_ESCAPES.matcher((CharSequence)uri).matches()) {
            throw new IllegalArgumentException("Invalid XSD URI: " + (String)uri);
        }
        if (lower.startsWith("jar:file:/")) {
            uri = AllowListEntityResolver.normalize("jar:file:", ((String)uri).substring(9), SystemUtils.IS_OS_WINDOWS, true);
        } else if (lower.startsWith("vfs:/")) {
            uri = AllowListEntityResolver.normalize("vfs:", ((String)uri).substring(4), SystemUtils.IS_OS_WINDOWS, false);
        } else if (lower.startsWith("https://")) {
            uri = AllowListEntityResolver.normalize("https:", ((String)uri).substring(6), true, false);
        } else if (lower.startsWith("http://")) {
            uri = AllowListEntityResolver.normalize("http:", ((String)uri).substring(5), true, false);
        } else if (SystemUtils.IS_OS_WINDOWS && lower.startsWith("file:////")) {
            uri = AllowListEntityResolver.normalize("file:", ((String)uri).substring(7), true, false);
        } else if (lower.startsWith("file:///")) {
            uri = AllowListEntityResolver.normalize("file:", AllowListEntityResolver.toAbsolutePath(((String)uri).substring(7)), false, false);
        } else if (SystemUtils.IS_OS_WINDOWS && lower.startsWith("file://")) {
            uri = AllowListEntityResolver.normalize("file:", ((String)uri).substring(5), true, false);
        } else if (lower.startsWith("file:")) {
            uri = AllowListEntityResolver.normalize("file:", AllowListEntityResolver.toAbsolutePath(((String)uri).substring(5)), false, false);
        } else {
            throw new IllegalArgumentException("Unsupported XSD URI protocol: " + (String)uri);
        }
        return uri;
    }

    private static String normalize(String scheme, String path, boolean allowHost, boolean archive) {
        String prefix = "/";
        if (allowHost && path.startsWith("//") && !path.startsWith("///")) {
            prefix = path.substring(0, path.indexOf(47, 2) + 1);
        } else if (SystemUtils.IS_OS_WINDOWS && WINDOWS_DRIVE.matcher(path).find()) {
            prefix = path.substring(0, 4);
        }
        path = path.substring(prefix.length());
        String suffix = "";
        if (archive) {
            suffix = path.substring(path.indexOf(33));
            path = path.substring(0, path.length() - suffix.length());
        }
        List names = Arrays.stream(path.split("/")).filter(Predicate.not(String::isEmpty)).filter(Predicate.not("."::equals)).collect(Collectors.toList());
        int index = names.indexOf("..");
        while (index >= 0) {
            names.remove(index);
            if (index > 0) {
                names.remove(index - 1);
            }
            index = names.indexOf("..");
        }
        return scheme + prefix + String.join((CharSequence)"/", names) + suffix;
    }

    private static String toAbsolutePath(String path) {
        return ((path = new File(path).getAbsolutePath().replace(File.separator, "/")).startsWith("/") ? "" : "/") + path;
    }

    private static boolean urlStartsWith(String url, String allowedUrl) {
        if (allowedUrl == null) {
            return false;
        }
        allowedUrl = ((String)allowedUrl).endsWith("/") ? allowedUrl : (String)allowedUrl + "/";
        return url.toLowerCase().startsWith(((String)allowedUrl).toLowerCase());
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("AllowListEntityResolver:( ");
        builder.append(this.baseURL);
        builder.append(" ");
        builder.append(this.ALLOWED_URIS);
        builder.append(")");
        return builder.toString();
    }
}

