/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.util;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.geoserver.config.GeoServer;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.util.AllowListEntityResolver;
import org.geotools.util.PreventLocalEntityResolver;
import org.xml.sax.EntityResolver;

public class EntityResolverProvider {
    public static final String ENTITY_RESOLUTION_UNRESTRICTED = "ENTITY_RESOLUTION_UNRESTRICTED";
    private static final String ENTITY_RESOLUTION_ALLOWLIST = "ENTITY_RESOLUTION_ALLOWLIST";
    static Set<String> ALLOW_LIST = EntityResolverProvider.entityResolutionAllowlist();
    private static EntityResolver entityResolver = null;
    private final AllowListEntityResolver ALLOWLIST_ENTITY_RESOLVER;
    public static final EntityResolverProvider RESOLVE_DISABLED_PROVIDER = new EntityResolverProvider(null);

    public EntityResolverProvider(GeoServer geoServer) {
        this.ALLOWLIST_ENTITY_RESOLVER = new AllowListEntityResolver(geoServer);
    }

    public static void setEntityResolver(EntityResolver resolver) {
        entityResolver = resolver;
    }

    public EntityResolver getEntityResolver() {
        if (Boolean.parseBoolean(GeoServerExtensions.getProperty((String)ENTITY_RESOLUTION_UNRESTRICTED))) {
            return null;
        }
        if (entityResolver != null) {
            return entityResolver;
        }
        if (ALLOW_LIST != null) {
            return this.ALLOWLIST_ENTITY_RESOLVER;
        }
        return PreventLocalEntityResolver.INSTANCE;
    }

    public static Set<String> entityResolutionAllowlist() {
        String allowed = GeoServerExtensions.getProperty((String)ENTITY_RESOLUTION_ALLOWLIST);
        return EntityResolverProvider.entityResolutionAllowlist(allowed);
    }

    static Set<String> entityResolutionAllowlist(String allowed) {
        String[] DEFAULT_LIST = new String[]{AllowListEntityResolver.W3C, AllowListEntityResolver.OGC1, AllowListEntityResolver.OGC2, AllowListEntityResolver.INSPIRE};
        if (allowed == null || allowed.trim().isEmpty()) {
            return new HashSet<String>(Arrays.asList(DEFAULT_LIST));
        }
        if (allowed.equals(AllowListEntityResolver.UNRESTRICTED)) {
            return null;
        }
        HashSet<String> allowedList = new HashSet<String>(Arrays.asList(DEFAULT_LIST));
        for (String domain : allowed.split("\\s*,\\s*|\\s+")) {
            if (domain.isEmpty()) continue;
            allowedList.add(domain);
        }
        return allowedList;
    }
}

