/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.util;

import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import org.geotools.util.DateRange;

public class ISO8601Formatter {
    private final GregorianCalendar cal = new GregorianCalendar(TimeZone.getTimeZone("GMT"));

    private void pad(StringBuilder buf, int value, int amt) {
        if (amt == 2 && value < 10) {
            buf.append('0');
        } else if (amt == 4 && value < 1000) {
            if (value >= 100) {
                buf.append("0");
            } else if (value >= 10) {
                buf.append("00");
            } else {
                buf.append("000");
            }
        } else if (amt == 3 && value < 100) {
            if (value >= 10) {
                buf.append('0');
            } else {
                buf.append("00");
            }
        }
        buf.append(value);
    }

    public String format(Object date) {
        if (date instanceof Date) {
            Date date1 = (Date)date;
            return this.format(date1);
        }
        if (date instanceof DateRange) {
            DateRange range = (DateRange)date;
            StringBuilder sb = new StringBuilder();
            this.format(range.getMinValue(), sb);
            sb.append("/");
            this.format(range.getMaxValue(), sb);
            sb.append("/PT1S");
            return sb.toString();
        }
        throw new IllegalArgumentException("Date argument should be either a Date or a DateRange, however this one is neither: " + String.valueOf(date));
    }

    public String format(Date date) {
        return this.format(date, new StringBuilder()).toString();
    }

    public StringBuilder format(Date date, StringBuilder buf) {
        this.cal.setTime(date);
        int year = this.cal.get(1);
        if (this.cal.get(0) == 0) {
            if (year > 1) {
                buf.append('-');
            }
            --year;
        }
        this.pad(buf, year, 4);
        buf.append('-');
        this.pad(buf, this.cal.get(2) + 1, 2);
        buf.append('-');
        this.pad(buf, this.cal.get(5), 2);
        buf.append('T');
        this.pad(buf, this.cal.get(11), 2);
        buf.append(':');
        this.pad(buf, this.cal.get(12), 2);
        buf.append(':');
        this.pad(buf, this.cal.get(13), 2);
        buf.append('.');
        this.pad(buf, this.cal.get(14), 3);
        buf.append('Z');
        return buf;
    }
}

