/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.util;

import java.awt.RenderingHints;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.TreeSet;
import org.geoserver.catalog.AcceptableRange;
import org.geoserver.catalog.CoverageInfo;
import org.geoserver.catalog.DimensionInfo;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.StructuredCoverageViewReader;
import org.geoserver.catalog.util.ReaderDimensionsAccessor;
import org.geoserver.ows.Dispatcher;
import org.geoserver.ows.Request;
import org.geoserver.platform.ServiceException;
import org.geoserver.util.DimensionWarning;
import org.geoserver.util.HTTPWarningAppender;
import org.geotools.api.coverage.grid.GridCoverageReader;
import org.geotools.api.data.FeatureSource;
import org.geotools.api.data.Query;
import org.geotools.api.feature.FeatureVisitor;
import org.geotools.api.filter.Filter;
import org.geotools.api.filter.FilterFactory;
import org.geotools.api.filter.IncludeFilter;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.filter.expression.Literal;
import org.geotools.api.filter.expression.PropertyName;
import org.geotools.coverage.grid.io.DimensionDescriptor;
import org.geotools.coverage.grid.io.GranuleSource;
import org.geotools.coverage.grid.io.GridCoverage2DReader;
import org.geotools.coverage.grid.io.StructuredGridCoverage2DReader;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.visitor.MaxVisitor;
import org.geotools.feature.visitor.MinVisitor;
import org.geotools.feature.visitor.NearestVisitor;
import org.geotools.util.Range;
import org.geotools.util.factory.Hints;

public abstract class NearestMatchFinder {
    public static boolean ENABLE_STRUCTURED_READER_SUPPORT = true;
    static final FilterFactory FF = CommonFactoryFinder.getFilterFactory();
    PropertyName attribute;
    PropertyName endAttribute;
    AcceptableRange acceptableRange;
    Class<?> dataType;
    DimensionInfo.NearestFailBehavior nearestFailBehavior;

    public static NearestMatchFinder get(ResourceInfo info, DimensionInfo dimensionInfo, String dimensionName) throws IOException {
        Class<?> dataType = NearestMatchFinder.getDataTypeFromDimension(info, dimensionName);
        try {
            AcceptableRange acceptableRange = AcceptableRange.getAcceptableRange(dimensionInfo.getAcceptableInterval(), dataType);
            DimensionInfo.NearestFailBehavior nearestFailBehavior = dimensionInfo.getNearestFailBehavior();
            if (info instanceof FeatureTypeInfo) {
                FeatureTypeInfo featureType = (FeatureTypeInfo)info;
                return new Vector(featureType, dimensionInfo.getAttribute(), dimensionInfo.getEndAttribute(), acceptableRange, nearestFailBehavior, dataType);
            }
            if (info instanceof CoverageInfo) {
                CoverageInfo coverageInfo = (CoverageInfo)info;
                GridCoverageReader reader = coverageInfo.getGridCoverageReader(null, null);
                if (reader instanceof StructuredGridCoverage2DReader) {
                    StructuredGridCoverage2DReader structured = (StructuredGridCoverage2DReader)reader;
                    if (ENABLE_STRUCTURED_READER_SUPPORT) {
                        DimensionDescriptor dd = NearestMatchFinder.getDimensionDescriptor(structured, dimensionName);
                        return new StructuredReader(structured, dd.getStartAttribute(), dd.getEndAttribute(), acceptableRange, nearestFailBehavior, dataType);
                    }
                }
                if (reader instanceof GridCoverage2DReader) {
                    GridCoverage2DReader dReader = (GridCoverage2DReader)reader;
                    return new Reader(dReader, acceptableRange, nearestFailBehavior, dimensionName, dataType);
                }
            }
        }
        catch (ParseException e) {
            throw new ServiceException("Failed to apply nearest match search on " + info.prefixedName(), (Throwable)e);
        }
        throw new IllegalArgumentException("No nearest match support for " + String.valueOf(info));
    }

    private static DimensionDescriptor getDimensionDescriptor(StructuredGridCoverage2DReader structured, String dimensionName) throws IOException {
        String coverageName = structured.getGridCoverageNames()[0];
        return structured.getDimensionDescriptors(coverageName).stream().filter(dd -> dimensionName.equalsIgnoreCase(dd.getName())).findFirst().orElseThrow(() -> new IllegalArgumentException("Could not find dimension" + dimensionName + "in grid coverage reader"));
    }

    private static Class<?> getDataTypeFromDimension(ResourceInfo info, String dimensionName) {
        if (dimensionName.equalsIgnoreCase("time")) {
            return Date.class;
        }
        if (dimensionName.equalsIgnoreCase("elevation")) {
            return Double.class;
        }
        throw new IllegalArgumentException("Dimension " + dimensionName + " not supported for nearest match yet");
    }

    public NearestMatchFinder(String startAttribute, String endAttribute, AcceptableRange acceptableRange, DimensionInfo.NearestFailBehavior nearestFailBehavior, Class<?> dataType) {
        this.attribute = FF.property(startAttribute);
        this.endAttribute = endAttribute == null ? null : FF.property(endAttribute);
        this.acceptableRange = acceptableRange;
        this.nearestFailBehavior = Optional.ofNullable(nearestFailBehavior).orElse(DimensionInfo.DEFAULT_NEAREST_FAIL);
        this.dataType = dataType;
    }

    public Object getNearest(Object value) throws IOException {
        if (value == null) {
            return null;
        }
        if (this.endAttribute == null && (!(value instanceof Range) || ((Range)value).getMinValue().equals(((Range)value).getMaxValue()))) {
            Object object;
            if (value instanceof Range) {
                Range r = (Range)value;
                object = r.getMinValue();
            } else {
                object = value;
            }
            Date date = (Date)object;
            NearestVisitor visitor = new NearestVisitor((Expression)this.attribute, (Object)date);
            IncludeFilter filter = Filter.INCLUDE;
            if (this.acceptableRange != null) {
                Range searchRange = this.acceptableRange.getSearchRange(date);
                filter = FF.between((Expression)this.attribute, (Expression)FF.literal((Object)searchRange.getMinValue()), (Expression)FF.literal((Object)searchRange.getMaxValue()));
            }
            FeatureCollection features = this.getMatches((Filter)filter);
            features.accepts((FeatureVisitor)visitor, null);
            Object result = visitor.getResult().getValue();
            if (date.equals(result)) {
                return value;
            }
            return result;
        }
        Filter lowerFilter = this.buildComparisonFilter(value, FilterDirection.HIGHEST_AMONG_LOWERS);
        FeatureCollection lowers = this.getMatches(lowerFilter);
        MaxVisitor lowersVisitor = new MaxVisitor((Expression)(this.endAttribute == null ? this.attribute : this.endAttribute));
        lowers.accepts((FeatureVisitor)lowersVisitor, null);
        Comparable maxOfSmallers = (Comparable)lowersVisitor.getResult().getValue();
        Filter higherFilter = this.buildComparisonFilter(value, FilterDirection.LOWEST_AMONG_HIGHER);
        FeatureCollection highers = this.getMatches(higherFilter);
        MinVisitor highersVisitor = new MinVisitor((Expression)this.attribute);
        highers.accepts((FeatureVisitor)highersVisitor, null);
        Comparable minOfGreater = (Comparable)highersVisitor.getResult().getValue();
        return this.closest(value, maxOfSmallers, minOfGreater);
    }

    protected Object closest(Object value, Object maxOfSmallers, Object minOfGreater) {
        Range range;
        Object result;
        Range range2;
        if (maxOfSmallers instanceof Range) {
            range2 = (Range)maxOfSmallers;
            maxOfSmallers = range2.getMaxValue();
        }
        if (minOfGreater instanceof Range) {
            range2 = (Range)minOfGreater;
            minOfGreater = range2.getMinValue();
        }
        if (maxOfSmallers == null) {
            result = minOfGreater == null ? null : minOfGreater;
        } else if (minOfGreater == null) {
            result = maxOfSmallers;
        } else if (value instanceof Range) {
            double distanceAbove;
            range = (Range)value;
            Comparable min = range.getMinValue();
            Comparable max = range.getMaxValue();
            double distanceBelow = this.distance(min, maxOfSmallers);
            result = distanceBelow < (distanceAbove = this.distance(max, minOfGreater)) ? maxOfSmallers : minOfGreater;
        } else {
            double distanceAbove;
            double distanceBelow = this.distance(value, minOfGreater);
            Object object = result = distanceBelow < (distanceAbove = this.distance(value, maxOfSmallers)) ? minOfGreater : maxOfSmallers;
        }
        if (result instanceof Range) {
            range = (Range)result;
            if (result == minOfGreater) {
                return range.getMaxValue();
            }
            return range.getMinValue();
        }
        return result;
    }

    protected double distance(Object a, Object b) {
        if (Number.class.isAssignableFrom(this.dataType)) {
            Number na = (Number)a;
            Number nb = (Number)b;
            return Math.abs(na.doubleValue() - nb.doubleValue());
        }
        if (Date.class.isAssignableFrom(this.dataType)) {
            Date da = (Date)a;
            Date db = (Date)b;
            return Math.abs(da.getTime() - db.getTime());
        }
        throw new IllegalArgumentException("Nearest calculations on data type " + String.valueOf(this.dataType) + " are not supported");
    }

    protected Filter buildComparisonFilter(Object value, FilterDirection direction) {
        if (value instanceof Range) {
            Range range = (Range)value;
            Literal qlower = FF.literal((Object)range.getMinValue());
            Literal qupper = FF.literal((Object)range.getMaxValue());
            return this.buildComparisonFilter(direction, qlower, qupper);
        }
        Literal valueReference = FF.literal(value);
        return this.buildComparisonFilter(direction, valueReference, valueReference);
    }

    public List<Object> getMatches(ResourceInfo resource, String dimensionName, List<Object> values, int maxOutputTime) throws IOException {
        long maxTime = maxOutputTime > 0 ? System.currentTimeMillis() + (long)(maxOutputTime * 1000) : -1L;
        ArrayList<Object> result = new ArrayList<Object>();
        for (Object value : values) {
            Object nearest = this.getNearest(value);
            if (nearest == null) {
                this.handleNearestFail(resource, dimensionName, value, result);
            } else if (value.equals(nearest)) {
                result.add(value);
            } else {
                HTTPWarningAppender.addWarning(DimensionWarning.nearest(resource, dimensionName, nearest));
                result.add(nearest);
            }
            if (maxTime <= 0L || System.currentTimeMillis() <= maxTime) continue;
            throw new ServiceException("Nearest matching dimension values required more time than allowed and has been forcefully stopped. The max time is " + maxOutputTime + "s");
        }
        return result;
    }

    private void handleNearestFail(ResourceInfo resource, String dimensionName, Object value, List<Object> result) {
        if (this.nearestFailBehavior == DimensionInfo.NearestFailBehavior.EXCEPTION && NearestMatchFinder.isWMSRequest().booleanValue()) {
            throw new ServiceException("No nearest match found on " + resource.prefixedName() + " for " + dimensionName + " dimension", "InvalidDimensionValue", DimensionInfo.getDimensionKey(dimensionName));
        }
        HTTPWarningAppender.addWarning(DimensionWarning.notFound(resource, dimensionName));
        result.add(value);
    }

    private static Boolean isWMSRequest() {
        return Optional.of((Request)Dispatcher.REQUEST.get()).map(r -> r.getService()).map(s -> "WMS".equalsIgnoreCase((String)s)).orElse(false);
    }

    private Filter buildComparisonFilter(FilterDirection direction, Literal qlower, Literal qupper) {
        PropertyName comparisonAttribute = this.getComparisonAttribute(direction);
        if (direction == FilterDirection.HIGHEST_AMONG_LOWERS) {
            if (this.acceptableRange != null) {
                Range searchRange = this.acceptableRange.getSearchRange(qlower.getValue());
                return FF.between((Expression)comparisonAttribute, (Expression)FF.literal((Object)searchRange.getMinValue()), (Expression)qlower);
            }
            return FF.lessOrEqual((Expression)comparisonAttribute, (Expression)qlower);
        }
        if (this.acceptableRange != null) {
            Range searchRange = this.acceptableRange.getSearchRange(qupper.getValue());
            return FF.between((Expression)comparisonAttribute, (Expression)qupper, (Expression)FF.literal((Object)searchRange.getMaxValue()));
        }
        return FF.greaterOrEqual((Expression)comparisonAttribute, (Expression)qupper);
    }

    private PropertyName getComparisonAttribute(FilterDirection direction) {
        if (this.endAttribute != null && direction == FilterDirection.HIGHEST_AMONG_LOWERS) {
            return this.endAttribute;
        }
        return this.attribute;
    }

    protected abstract FeatureCollection getMatches(Filter var1) throws IOException;

    private static class Vector
    extends NearestMatchFinder {
        private final FeatureSource featureSource;

        public Vector(FeatureTypeInfo ftInfo, String attribute, String endAttribute, AcceptableRange acceptableRange, DimensionInfo.NearestFailBehavior nearestFailBehavior, Class<?> dataType) throws IOException {
            super(attribute, endAttribute, acceptableRange, nearestFailBehavior, dataType);
            this.featureSource = ftInfo.getFeatureSource(null, null);
        }

        @Override
        protected FeatureCollection getMatches(Filter filter) throws IOException {
            return this.featureSource.getFeatures(filter);
        }
    }

    private static class StructuredReader
    extends NearestMatchFinder {
        private final StructuredGridCoverage2DReader reader;

        public StructuredReader(StructuredGridCoverage2DReader reader, String startAttribute, String endAttribute, AcceptableRange acceptableRange, DimensionInfo.NearestFailBehavior nearestFailBehavior, Class<?> dataType) {
            super(startAttribute, endAttribute, acceptableRange, nearestFailBehavior, dataType);
            this.reader = reader;
        }

        @Override
        protected FeatureCollection getMatches(Filter filter) throws IOException {
            GranuleSource granules = this.reader.getGranules(null, true);
            Query q = new Query(null, filter);
            q.setHints(new Hints((RenderingHints.Key)StructuredCoverageViewReader.QUERY_FIRST_BAND, (Object)true));
            return granules.getGranules(q);
        }
    }

    private static class Reader
    extends NearestMatchFinder {
        private final GridCoverage2DReader reader;
        private final String dimensionName;

        public Reader(GridCoverage2DReader reader, AcceptableRange acceptableRange, DimensionInfo.NearestFailBehavior nearestFailBehavior, String dimensionName, Class<?> dataType) {
            super(null, null, acceptableRange, nearestFailBehavior, dataType);
            this.reader = reader;
            this.dimensionName = dimensionName;
        }

        @Override
        public Object getNearest(Object value) throws IOException {
            TreeSet<Object> domain = this.getDimensionDomain();
            if (domain.isEmpty()) {
                return null;
            }
            Object maxOfSmallers = null;
            Object minOfGreater = null;
            Range rangeFilter = this.acceptableRange != null ? this.acceptableRange.getSearchRange(value) : null;
            for (Object d : domain) {
                if (!this.rangeFilterAccepts(rangeFilter, d)) continue;
                int result = this.compare(d, value);
                if (result < 0) {
                    maxOfSmallers = d;
                    continue;
                }
                if (result == 0) {
                    return value;
                }
                minOfGreater = d;
                break;
            }
            return this.closest(value, maxOfSmallers, minOfGreater);
        }

        private boolean rangeFilterAccepts(Range rangeFilter, Object domainValue) {
            if (rangeFilter == null) {
                return true;
            }
            if (domainValue instanceof Range) {
                Range range = (Range)domainValue;
                return rangeFilter.intersects(range);
            }
            return rangeFilter.contains((Comparable)domainValue);
        }

        private int compare(Object a, Object b) {
            if (!(a instanceof Range)) {
                if (!(b instanceof Range)) {
                    return ((Comparable)a).compareTo(b);
                }
                return this.compare((Range)b, a) * -1;
            }
            if (a instanceof Range) {
                if (b instanceof Range) {
                    Range ra = (Range)a;
                    Range rb = (Range)b;
                    if (ra.intersects(rb)) {
                        return 0;
                    }
                    if (ra.getMinValue().compareTo(rb.getMaxValue()) >= 0) {
                        return 1;
                    }
                    return -1;
                }
                return this.compare((Range)a, b);
            }
            throw new IllegalArgumentException("boo");
        }

        private int compare(Range a, Object b) {
            Range ra = a;
            if (ra.getMinValue().compareTo(b) > 0) {
                return 1;
            }
            if (ra.getMaxValue().compareTo(b) < 0) {
                return -1;
            }
            return 0;
        }

        private TreeSet<Object> getDimensionDomain() throws IOException {
            ReaderDimensionsAccessor accessor = new ReaderDimensionsAccessor(this.reader);
            if ("time".equals(this.dimensionName)) {
                return accessor.getTimeDomain();
            }
            throw new IllegalArgumentException("Nearest match support on simple grid readers is supported only for time at the moment");
        }

        @Override
        protected FeatureCollection getMatches(Filter filter) throws IOException {
            throw new UnsupportedOperationException();
        }
    }

    static enum FilterDirection {
        HIGHEST_AMONG_LOWERS,
        LOWEST_AMONG_HIGHER;

    }
}

