/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.crs;

import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.logging.Level;
import org.geotools.api.referencing.FactoryException;
import org.geotools.api.referencing.IdentifiedObject;
import org.geotools.api.referencing.NoSuchAuthorityCodeException;
import org.geotools.api.referencing.ReferenceIdentifier;
import org.geotools.api.referencing.crs.CRSFactory;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.api.referencing.crs.GeographicCRS;
import org.geotools.metadata.iso.citation.Citations;
import org.geotools.referencing.AbstractIdentifiedObject;
import org.geotools.referencing.CRS;
import org.geotools.referencing.NamedIdentifier;
import org.geotools.referencing.ReferencingFactoryFinder;
import org.geotools.referencing.factory.wms.WebCRSFactory;

public class GeoServerOverridingWebFactory
extends WebCRSFactory {
    private static final Map<Integer, String> CRS_TO_EPSG = Map.of(84, "EPSG:4326", 83, "EPSG:4269", 27, "EPSG:4267");

    public GeoServerOverridingWebFactory() {
        super(null);
    }

    public int getPriority() {
        return 100;
    }

    public CoordinateReferenceSystem createCoordinateReferenceSystem(String code) throws FactoryException {
        int i = this.getIntegerCode(code);
        if (CRS_TO_EPSG.containsKey(i)) {
            try {
                GeographicCRS crs = (GeographicCRS)CRS.decode((String)CRS_TO_EPSG.get(i), (boolean)true);
                CRSFactory crsFactory = ReferencingFactoryFinder.getCRSFactory(null);
                HashMap<String, Object> properties = new HashMap<String, Object>(AbstractIdentifiedObject.getProperties((IdentifiedObject)crs));
                LinkedHashSet<NamedIdentifier> identifiers = new LinkedHashSet<NamedIdentifier>();
                identifiers.add(new NamedIdentifier(Citations.CRS, String.valueOf(i)));
                identifiers.addAll(crs.getIdentifiers());
                properties.put("identifiers", identifiers.toArray(ReferenceIdentifier[]::new));
                properties.put("name", crs.getName().getCode() + " longitude-latitude");
                return crsFactory.createGeographicCRS(properties, crs.getDatum(), crs.getCoordinateSystem());
            }
            catch (NoSuchAuthorityCodeException e) {
                LOGGER.log(Level.WARNING, "Could not decode EPSG code: {0}", code);
            }
        }
        LOGGER.log(Level.WARNING, "Could not find a EPSG equivalent for code: {0}, falling back to default implementation", code);
        return super.createCoordinateReferenceSystem(code);
    }
}

