/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.global;

import java.io.IOException;
import java.util.List;
import java.util.stream.Stream;
import org.geoserver.feature.RetypingFeatureCollection;
import org.geotools.api.data.FeatureReader;
import org.geotools.api.data.FeatureSource;
import org.geotools.api.data.FeatureStore;
import org.geotools.api.data.SimpleFeatureStore;
import org.geotools.api.data.Transaction;
import org.geotools.api.feature.IllegalAttributeException;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.feature.type.AttributeDescriptor;
import org.geotools.api.feature.type.Name;
import org.geotools.api.filter.Filter;
import org.geotools.api.filter.identity.FeatureId;
import org.geotools.data.DataUtilities;
import org.geotools.data.complex.feature.type.Types;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.util.Converters;
import org.vfny.geoserver.global.GeoServerFeatureSource;

public class GeoServerFeatureStore
extends GeoServerFeatureSource
implements SimpleFeatureStore {
    GeoServerFeatureStore(FeatureStore<SimpleFeatureType, SimpleFeature> store, GeoServerFeatureSource.Settings settings) {
        super((FeatureSource<SimpleFeatureType, SimpleFeature>)store, settings);
    }

    SimpleFeatureStore store() {
        return (SimpleFeatureStore)this.source;
    }

    public List<FeatureId> addFeatures(FeatureCollection<SimpleFeatureType, SimpleFeature> fc) throws IOException {
        this.enforceFeatureInsertValidation((FeatureCollection<SimpleFeatureType, SimpleFeature>)fc);
        SimpleFeatureStore store = this.store();
        if (!((SimpleFeatureType)store.getSchema()).equals(fc.getSchema())) {
            fc = new RetypingFeatureCollection(DataUtilities.simple(fc), (SimpleFeatureType)store.getSchema());
        }
        return this.store().addFeatures(fc);
    }

    private void enforceFeatureInsertValidation(FeatureCollection<SimpleFeatureType, SimpleFeature> fc) {
        try (FeatureIterator features = fc.features();){
            while (features.hasNext()) {
                SimpleFeature feature = (SimpleFeature)features.next();
                feature.getType().getAttributeDescriptors().forEach(attributeDescriptor -> this.validateFeatureAttributeValue((AttributeDescriptor)attributeDescriptor, feature));
            }
        }
    }

    private void validateFeatureAttributeValue(AttributeDescriptor attributeDescriptor, SimpleFeature feature) {
        try {
            Object value = feature.getAttribute(attributeDescriptor.getName());
            Types.validate((AttributeDescriptor)attributeDescriptor, (Object)value);
        }
        catch (IllegalAttributeException ex) {
            throw new IllegalArgumentException(String.format("Restriction evaluation failed for attribute '%s' of feature '%s' (%s)", attributeDescriptor.getName(), feature.getID(), ex.getMessage()), ex);
        }
    }

    public void removeFeatures(Filter filter) throws IOException {
        filter = this.makeDefinitionFilter(filter);
        this.store().removeFeatures(filter);
    }

    public void setFeatures(FeatureReader<SimpleFeatureType, SimpleFeature> reader) throws IOException {
        SimpleFeatureStore store = this.store();
        if (!((SimpleFeatureType)store.getSchema()).equals(reader.getFeatureType())) {
            reader = new RetypingFeatureCollection.RetypingFeatureReader(reader, (SimpleFeatureType)store.getSchema());
        }
        this.store().setFeatures(reader);
    }

    public void setTransaction(Transaction transaction) {
        this.store().setTransaction(transaction);
    }

    public Transaction getTransaction() {
        return this.store().getTransaction();
    }

    public void modifyFeatures(String name, Object attributeValue, Filter filter) throws IOException {
        this.enforceFeatureUpdateValidation(name, attributeValue);
        filter = this.makeDefinitionFilter(filter);
        this.store().modifyFeatures(name, attributeValue, filter);
    }

    public void modifyFeatures(String[] names, Object[] attributeValues, Filter filter) throws IOException {
        this.enforceFeatureUpdateValidation(names, attributeValues);
        filter = this.makeDefinitionFilter(filter);
        this.store().modifyFeatures(names, attributeValues, filter);
    }

    public void modifyFeatures(Name[] attributeNames, Object[] attributeValues, Filter filter) throws IOException {
        String[] names = (String[])Stream.of(attributeNames).map(Name::getLocalPart).toArray(String[]::new);
        this.enforceFeatureUpdateValidation(names, attributeValues);
        filter = this.makeDefinitionFilter(filter);
        this.store().modifyFeatures(attributeNames, attributeValues, filter);
    }

    public void modifyFeatures(Name attributeName, Object attributeValue, Filter filter) throws IOException {
        this.enforceFeatureUpdateValidation(attributeName.getLocalPart(), attributeValue);
        filter = this.makeDefinitionFilter(filter);
        this.store().modifyFeatures(attributeName, attributeValue, filter);
    }

    private void enforceFeatureUpdateValidation(String name, Object attributeValue) {
        this.enforceFeatureUpdateValidation(new String[]{name}, new Object[]{attributeValue});
    }

    private void enforceFeatureUpdateValidation(String[] attributeNames, Object[] attributeValues) {
        for (int i = 0; i < attributeNames.length; ++i) {
            String name = attributeNames[i];
            Object value = attributeValues[i];
            AttributeDescriptor attributeDescriptor = this.schema.getDescriptor(name);
            Class binding = attributeDescriptor.getType().getBinding();
            Object convertedValue = Converters.convert((Object)value, (Class)binding);
            this.validateAttributeValue(attributeDescriptor, convertedValue);
        }
    }

    private void validateAttributeValue(AttributeDescriptor attributeDescriptor, Object value) {
        try {
            Types.validate((AttributeDescriptor)attributeDescriptor, (Object)value);
        }
        catch (IllegalAttributeException ex) {
            throw new IllegalArgumentException(String.format("Restriction evaluation failed for the value of attribute '%s' (%s)", attributeDescriptor.getName(), ex.getMessage()), ex);
        }
    }
}

