/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.util;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.WMSLayerInfo;
import org.geoserver.catalog.WMTSLayerInfo;
import org.geoserver.data.DataAccessFactoryProducer;
import org.geoserver.data.DataStoreFactoryInitializer;
import org.geoserver.feature.retype.RetypingDataStore;
import org.geoserver.platform.GeoServerExtensions;
import org.geotools.api.data.DataAccess;
import org.geotools.api.data.DataAccessFactory;
import org.geotools.api.data.DataAccessFinder;
import org.geotools.api.data.DataStore;
import org.geotools.api.feature.Feature;
import org.geotools.api.feature.type.FeatureType;
import org.geotools.api.feature.type.Name;
import org.geotools.api.util.ProgressListener;
import org.geotools.data.util.NullProgressListener;
import org.geotools.feature.NameImpl;
import org.geotools.ows.wms.Layer;
import org.geotools.ows.wmts.model.WMTSLayer;
import org.geotools.util.logging.Logging;

public abstract class DataStoreUtils {
    static Logger LOGGER = Logging.getLogger((String)"org.geoserver.data");

    public static DataAccess<? extends FeatureType, ? extends Feature> getDataAccess(Map<String, Serializable> params) throws IOException {
        DataAccessFactory factory = DataStoreUtils.aquireFactory(params);
        if (factory == null) {
            return null;
        }
        return DataStoreUtils.getDataAccess(factory, params);
    }

    public static DataAccess<? extends FeatureType, ? extends Feature> getDataAccess(DataAccessFactory factory, Map<String, Serializable> params) throws IOException {
        DataAccess store = factory.createDataStore(params);
        if (store == null) {
            return null;
        }
        if (store instanceof DataStore) {
            DataStore dataStore = (DataStore)store;
            try {
                String[] names;
                for (String name : names = dataStore.getTypeNames()) {
                    if (name.indexOf(":") < 0) continue;
                    return new RetypingDataStore(dataStore);
                }
            }
            catch (IOException | RuntimeException e) {
                store.dispose();
                throw e;
            }
        }
        return store;
    }

    public static DataAccessFactory aquireFactory(Map<String, Serializable> params) {
        for (DataAccessFactory factory : DataStoreUtils.getAvailableDataStoreFactories()) {
            DataStoreUtils.initializeDataStoreFactory(factory);
            if (!factory.canProcess(params)) continue;
            return factory;
        }
        return null;
    }

    public static DataAccessFactory aquireFactory(String displayName) {
        if (displayName == null) {
            return null;
        }
        for (DataAccessFactory factory : DataStoreUtils.getAvailableDataStoreFactories()) {
            DataStoreUtils.initializeDataStoreFactory(factory);
            if (displayName.equals(factory.getDisplayName())) {
                return factory;
            }
            if (!displayName.equals(factory.getClass().toString())) continue;
            return factory;
        }
        return null;
    }

    static DataAccessFactory initializeDataStoreFactory(DataAccessFactory factory) {
        List initializers = GeoServerExtensions.extensions(DataStoreFactoryInitializer.class);
        for (DataStoreFactoryInitializer initer : initializers) {
            if (!initer.getFactoryClass().isAssignableFrom(factory.getClass())) continue;
            try {
                initer.initialize(factory);
            }
            catch (Throwable t) {
                Logger LOGGER2 = Logging.getLogger((String)"org.geoserver.platform");
                String msg = "Error occured processing extension: " + initer.getClass().getName();
                LOGGER2.log(Level.WARNING, msg, t);
            }
        }
        return factory;
    }

    public static DataAccessFactory.Param find(DataAccessFactory.Param[] params, String key) {
        for (DataAccessFactory.Param param : params) {
            if (!key.equalsIgnoreCase(param.key)) continue;
            return param;
        }
        return null;
    }

    public static List<String> listDataStoresDescriptions() {
        ArrayList<String> list2 = new ArrayList<String>();
        for (DataAccessFactory factory : DataStoreUtils.getAvailableDataStoreFactories()) {
            DataStoreUtils.initializeDataStoreFactory(factory);
            list2.add(factory.getDisplayName());
        }
        return list2;
    }

    public static Map<String, Serializable> defaultParams(String description) {
        return DataStoreUtils.defaultParams(DataStoreUtils.aquireFactory(description));
    }

    public static Map<String, Serializable> defaultParams(DataAccessFactory factory) {
        DataAccessFactory.Param[] params;
        HashMap<String, Serializable> defaults = new HashMap<String, Serializable>();
        for (DataAccessFactory.Param param : params = factory.getParametersInfo()) {
            String key = param.key;
            String value = null;
            if (param.sample != null) {
                value = param.text(param.sample);
            }
            if (value == null) {
                value = "";
            }
            if (value == null) continue;
            defaults.put(key, (Serializable)((Object)value));
        }
        return defaults;
    }

    public static Map<String, Object> toConnectionParams(DataAccessFactory factory, Map<String, ?> params) throws IOException {
        HashMap<String, Object> map = new HashMap<String, Object>(params.size());
        DataAccessFactory.Param[] info = factory.getParametersInfo();
        for (String key : params.keySet()) {
            Object value = DataStoreUtils.find(info, key).lookUp(params);
            if (value == null) continue;
            map.put(key, value);
        }
        return map;
    }

    public static Collection<DataAccessFactory> getAvailableDataStoreFactories() {
        List<DataAccessFactory> factories = DataAccessFactoryCache.INSTANCE.getFactories();
        return factories;
    }

    public static List<String> getOtherSRSFromWfsNg(FeatureTypeInfo resourceInfo) {
        if (resourceInfo.getStore().getType() == null) {
            return Collections.emptyList();
        }
        if (!resourceInfo.getStore().getType().equalsIgnoreCase("Web Feature Server (NG)")) {
            return Collections.emptyList();
        }
        try {
            FeatureTypeInfo featureType = resourceInfo;
            NameImpl nativeName = new NameImpl(featureType.getNativeName());
            org.geotools.data.wfs.internal.FeatureTypeInfo info = (org.geotools.data.wfs.internal.FeatureTypeInfo)featureType.getStore().getDataStore(null).getFeatureSource((Name)nativeName).getInfo();
            if (info.getOtherSRS() != null) {
                return info.getOtherSRS();
            }
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, e.getMessage(), e);
        }
        return Collections.emptyList();
    }

    public static List<String> getOtherSRSFromWMSStore(WMSLayerInfo wmsLayerInfo) {
        try {
            Layer wmsLayer = wmsLayerInfo.getWMSLayer((ProgressListener)new NullProgressListener());
            Set supportedSRS = wmsLayer.getSrs();
            if (supportedSRS.size() == 1) {
                return Collections.emptyList();
            }
            List<String> otherSRS = supportedSRS.stream().collect(Collectors.toList());
            return otherSRS;
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, "Error while reading other SRS from WMS Layer :" + wmsLayerInfo.getNativeName(), e);
            return Collections.emptyList();
        }
    }

    public static List<String> getOtherSRSFromWMTSStore(WMTSLayerInfo wmtsLayerInfo) {
        List<String> otherSRS = Collections.emptyList();
        try {
            WMTSLayer wmtsLayer = wmtsLayerInfo.getWMTSLayer((ProgressListener)new NullProgressListener());
            Set supportedSRS = wmtsLayer.getSrs();
            if (supportedSRS.size() != 1) {
                otherSRS = supportedSRS.stream().collect(Collectors.toList());
            }
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, "Error while reading other SRS from WMS Layer :" + wmtsLayerInfo.getNativeName(), e);
        }
        return otherSRS;
    }

    static enum DataAccessFactoryCache {
        INSTANCE;

        private List<DataAccessFactory> factories = new ArrayList<DataAccessFactory>();

        private DataAccessFactoryCache() {
            Iterator it = DataAccessFinder.getAvailableDataStores();
            while (it.hasNext()) {
                this.factories.add((DataAccessFactory)it.next());
            }
            for (DataAccessFactoryProducer producer : GeoServerExtensions.extensions(DataAccessFactoryProducer.class)) {
                try {
                    this.factories.addAll(producer.getDataStoreFactories());
                }
                catch (Throwable t) {
                    LOGGER.log(Level.WARNING, "Error occurred loading data access factories. Ignoring producer", t);
                }
            }
        }

        public List<DataAccessFactory> getFactories() {
            return this.factories;
        }
    }
}

