/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imagen.media.bandcombine;

import java.awt.RenderingHints;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.renderable.ParameterBlock;
import java.awt.image.renderable.RenderableImage;
import org.eclipse.imagen.ImageN;
import org.eclipse.imagen.OperationDescriptorImpl;
import org.eclipse.imagen.ParameterBlockImageN;
import org.eclipse.imagen.ROI;
import org.eclipse.imagen.RenderableOp;
import org.eclipse.imagen.RenderedOp;
import org.eclipse.imagen.media.bandcombine.JaiI18N;
import org.eclipse.imagen.media.range.Range;

public class BandCombineDescriptor
extends OperationDescriptorImpl {
    private static final String[][] resources = new String[][]{{"GlobalName", "BandCombine"}, {"LocalName", "BandCombine"}, {"Vendor", "org.eclipse.imagen.media"}, {"Description", JaiI18N.getString("BandCombineDescriptor0")}, {"DocURL", "http://java.sun.com/products/java-media/jai/forDevelopers/jai-apidocs/javax/media/jai/operator/BandCombineDescriptor.html"}, {"Version", JaiI18N.getString("DescriptorVersion")}, {"arg0Desc", JaiI18N.getString("BandCombineDescriptor2")}, {"arg1Desc", JaiI18N.getString("BandCombineDescriptor3")}, {"arg2Desc", JaiI18N.getString("BandCombineDescriptor4")}, {"arg3Desc", JaiI18N.getString("BandCombineDescriptor5")}};
    private static final Class[] paramClasses = new Class[]{double[][].class, ROI.class, Range.class, Double.class};
    private static final String[] paramNames = new String[]{"matrix", "roi", "nodata", "destNoData"};
    private static final Object[] paramDefaults = new Object[]{NO_PARAMETER_DEFAULT, null, null, 0.0};
    private static final String[] supportedModes = new String[]{"rendered", "renderable"};

    public BandCombineDescriptor() {
        super(resources, supportedModes, 1, paramNames, paramClasses, paramDefaults, null);
    }

    public boolean validateArguments(String modeName, ParameterBlock args, StringBuffer message) {
        if (!super.validateArguments(modeName, args, message)) {
            return false;
        }
        if (!modeName.equalsIgnoreCase("rendered")) {
            return true;
        }
        RenderedImage src = args.getRenderedSource(0);
        double[][] matrix = (double[][])args.getObjectParameter(0);
        SampleModel sm = src.getSampleModel();
        int rowLength = sm.getNumBands() + 1;
        if (matrix.length < 1) {
            message.append(this.getName() + ": " + JaiI18N.getString("BandCombineDescriptor1"));
            return false;
        }
        for (int i = 0; i < matrix.length; ++i) {
            if (matrix[i].length == rowLength) continue;
            message.append(this.getName() + ": " + JaiI18N.getString("BandCombineDescriptor1"));
            return false;
        }
        return true;
    }

    public static RenderedOp create(RenderedImage source0, double[][] matrix, RenderingHints hints) {
        ParameterBlockImageN pb = new ParameterBlockImageN("BandCombine", "rendered");
        pb.setSource("source0", (Object)source0);
        pb.setParameter("matrix", (Object)matrix);
        return ImageN.create((String)"BandCombine", (ParameterBlock)pb, (RenderingHints)hints);
    }

    public static RenderedOp create(RenderedImage source0, double[][] matrix, ROI roi, Range nodata, double destinationNoData, RenderingHints hints) {
        ParameterBlockImageN pb = new ParameterBlockImageN("BandCombine", "rendered");
        pb.setSource("source0", (Object)source0);
        pb.setParameter("matrix", (Object)matrix);
        pb.setParameter("roi", (Object)roi);
        pb.setParameter("nodata", (Object)nodata);
        pb.setParameter("destNoData", destinationNoData);
        return ImageN.create((String)"BandCombine", (ParameterBlock)pb, (RenderingHints)hints);
    }

    public static RenderableOp createRenderable(RenderableImage source0, double[][] matrix, ROI roi, Range nodata, double destinationNoData, RenderingHints hints) {
        ParameterBlockImageN pb = new ParameterBlockImageN("BandCombine", "renderable");
        pb.setSource("source0", (Object)source0);
        pb.setParameter("matrix", (Object)matrix);
        pb.setParameter("roi", (Object)roi);
        pb.setParameter("nodata", (Object)nodata);
        pb.setParameter("destNoData", destinationNoData);
        return ImageN.createRenderable((String)"BandCombine", (ParameterBlock)pb, (RenderingHints)hints);
    }
}

