/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imagen.media.border;

import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.Area;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import org.eclipse.imagen.BorderExtender;
import org.eclipse.imagen.ImageN;
import org.eclipse.imagen.OperationDescriptorImpl;
import org.eclipse.imagen.OperationNode;
import org.eclipse.imagen.ParameterBlockImageN;
import org.eclipse.imagen.RenderedOp;
import org.eclipse.imagen.media.range.Range;

public class BorderDescriptor
extends OperationDescriptorImpl {
    private static final String[][] resources = new String[][]{{"GlobalName", "Border"}, {"LocalName", "Border"}, {"Vendor", "org.eclipse.imagen.media"}, {"Description", "Operation which adds borders to the input image"}, {"DocURL", "Not Defined"}, {"Version", "1.0"}, {"arg0Desc", "Image's left padding"}, {"arg1Desc", "Image's right padding"}, {"arg2Desc", "Image's top padding"}, {"arg3Desc", "Image's bottom padding"}, {"arg4Desc", "Border Extender used"}, {"arg5Desc", "No Data Range used"}, {"arg6Desc", "Destination No Data value"}};
    private static final String[] paramNames = new String[]{"leftPad", "rightPad", "topPad", "bottomPad", "type", "noData", "destNoData"};
    private static final Class[] paramClasses = new Class[]{Integer.class, Integer.class, Integer.class, Integer.class, BorderExtender.class, Range.class, Double.class};
    private static final Object[] paramDefaults = new Object[]{0, 0, 0, 0, BorderExtender.createInstance((int)0), null, 0.0};

    public BorderDescriptor() {
        super(resources, 1, paramClasses, paramNames, paramDefaults);
    }

    public Object getInvalidRegion(String modeName, ParameterBlock oldParamBlock, RenderingHints oldHints, ParameterBlock newParamBlock, RenderingHints newHints, OperationNode node) {
        if (modeName == null || (this.getNumSources() > 0 || this.getNumParameters() > 0) && (oldParamBlock == null || newParamBlock == null)) {
            throw new IllegalArgumentException("Some parameters are null");
        }
        int numSources = this.getNumSources();
        if (numSources > 0 && (oldParamBlock.getNumSources() != numSources || newParamBlock.getNumSources() != numSources)) {
            throw new IllegalArgumentException("The number of source images is different");
        }
        int numParams = this.getParameterListDescriptor(modeName).getNumParameters();
        if (numParams > 0 && (oldParamBlock.getNumParameters() != numParams || newParamBlock.getNumParameters() != numParams)) {
            throw new IllegalArgumentException("The number of input parameters is different");
        }
        if (!modeName.equalsIgnoreCase("rendered") || oldHints == null && newHints != null || oldHints != null && newHints == null || oldHints != null && !oldHints.equals(newHints) || !oldParamBlock.getSource(0).equals(newParamBlock.getSource(0)) || oldParamBlock.getIntParameter(0) != newParamBlock.getIntParameter(0) || oldParamBlock.getIntParameter(2) != newParamBlock.getIntParameter(2)) {
            return null;
        }
        Shape invalidRegion = null;
        if (!oldParamBlock.getObjectParameter(4).equals(newParamBlock.getObjectParameter(4))) {
            RenderedImage src = oldParamBlock.getRenderedSource(0);
            int leftPad = oldParamBlock.getIntParameter(0);
            int topPad = oldParamBlock.getIntParameter(2);
            Rectangle srcBounds = new Rectangle(src.getMinX(), src.getMinY(), src.getWidth(), src.getHeight());
            Rectangle dstBounds = new Rectangle(srcBounds.x - leftPad, srcBounds.y - topPad, srcBounds.width + leftPad + oldParamBlock.getIntParameter(1), srcBounds.height + topPad + oldParamBlock.getIntParameter(3));
            Area invalidArea = new Area(dstBounds);
            invalidArea.subtract(new Area(srcBounds));
            invalidRegion = invalidArea;
        } else if (newParamBlock.getIntParameter(1) < oldParamBlock.getIntParameter(1) && newParamBlock.getIntParameter(3) <= oldParamBlock.getIntParameter(3) || newParamBlock.getIntParameter(3) < oldParamBlock.getIntParameter(3) && newParamBlock.getIntParameter(1) <= oldParamBlock.getIntParameter(1)) {
            RenderedImage src = oldParamBlock.getRenderedSource(0);
            int leftPad = oldParamBlock.getIntParameter(0);
            int topPad = oldParamBlock.getIntParameter(2);
            Rectangle srcBounds = new Rectangle(src.getMinX(), src.getMinY(), src.getWidth(), src.getHeight());
            Rectangle oldBounds = new Rectangle(srcBounds.x - leftPad, srcBounds.y - topPad, srcBounds.width + leftPad + oldParamBlock.getIntParameter(1), srcBounds.height + topPad + oldParamBlock.getIntParameter(3));
            Rectangle newBounds = new Rectangle(srcBounds.x - leftPad, srcBounds.y - topPad, srcBounds.width + leftPad + newParamBlock.getIntParameter(1), srcBounds.height + topPad + newParamBlock.getIntParameter(3));
            Area invalidArea = new Area(oldBounds);
            invalidArea.subtract(new Area(newBounds));
            invalidRegion = invalidArea;
        } else {
            invalidRegion = new Rectangle();
        }
        return invalidRegion;
    }

    public static RenderedOp create(RenderedImage source0, int leftPad, int rightPad, int topPad, int bottomPad, BorderExtender type, Range noData, double destinationNoData, RenderingHints hints) {
        ParameterBlockImageN pb = new ParameterBlockImageN("Border", "rendered");
        pb.setSource("source0", (Object)source0);
        pb.setParameter("leftPad", leftPad);
        pb.setParameter("rightPad", rightPad);
        pb.setParameter("topPad", topPad);
        pb.setParameter("bottomPad", bottomPad);
        pb.setParameter("type", (Object)type);
        pb.setParameter("noData", (Object)noData);
        pb.setParameter("destNoData", destinationNoData);
        return ImageN.create((String)"Border", (ParameterBlock)pb, (RenderingHints)hints);
    }

    public static RenderedOp create(RenderedImage source0, Integer leftPad, Integer rightPad, Integer topPad, Integer bottomPad, BorderExtender type, RenderingHints hints) {
        ParameterBlockImageN pb = new ParameterBlockImageN("Border", "rendered");
        pb.setSource("source0", (Object)source0);
        pb.setParameter("leftPad", (Object)leftPad);
        pb.setParameter("rightPad", (Object)rightPad);
        pb.setParameter("topPad", (Object)topPad);
        pb.setParameter("bottomPad", (Object)bottomPad);
        pb.setParameter("type", (Object)type);
        return ImageN.create((String)"Border", (ParameterBlock)pb, (RenderingHints)hints);
    }
}

