/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.crs;

import java.io.IOException;
import java.util.Iterator;
import org.geotools.api.feature.FeatureVisitor;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.api.util.ProgressListener;
import org.geotools.data.crs.ForceCoordinateSystemIterator;
import org.geotools.data.crs.ReprojectFeatureResults;
import org.geotools.data.store.ReprojectingFeatureCollection;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureTypes;
import org.geotools.feature.SchemaException;
import org.geotools.feature.collection.AbstractFeatureCollection;
import org.geotools.geometry.jts.ReferencedEnvelope;

public class ForceCoordinateSystemFeatureResults
extends AbstractFeatureCollection {
    FeatureCollection<SimpleFeatureType, SimpleFeature> results;

    public ForceCoordinateSystemFeatureResults(FeatureCollection<SimpleFeatureType, SimpleFeature> results, CoordinateReferenceSystem forcedCS) throws IOException, SchemaException {
        this(results, forcedCS, false);
    }

    public ForceCoordinateSystemFeatureResults(FeatureCollection<SimpleFeatureType, SimpleFeature> results, CoordinateReferenceSystem forcedCS, boolean forceOnlyMissing) throws IOException, SchemaException {
        super(ForceCoordinateSystemFeatureResults.forceType(ForceCoordinateSystemFeatureResults.origionalType(results), forcedCS, forceOnlyMissing));
        this.results = results;
    }

    private static SimpleFeatureType origionalType(FeatureCollection<SimpleFeatureType, SimpleFeature> results) {
        AbstractFeatureCollection featureResults;
        if (results instanceof ReprojectFeatureResults) {
            featureResults = (ReprojectFeatureResults)results;
            results = ((ReprojectFeatureResults)featureResults).getOrigin();
        }
        if (results instanceof ForceCoordinateSystemFeatureResults) {
            featureResults = (ForceCoordinateSystemFeatureResults)results;
            results = ((ForceCoordinateSystemFeatureResults)featureResults).getOrigin();
        }
        return results.getSchema();
    }

    @Override
    public Iterator<SimpleFeature> openIterator() {
        return new ForceCoordinateSystemIterator(this.results.features(), this.getSchema());
    }

    public void closeIterator(Iterator close) {
        if (close instanceof ForceCoordinateSystemIterator) {
            ForceCoordinateSystemIterator iterator = (ForceCoordinateSystemIterator)close;
            iterator.close();
        }
    }

    @Override
    public int size() {
        return this.results.size();
    }

    private static SimpleFeatureType forceType(SimpleFeatureType startingType, CoordinateReferenceSystem forcedCS, boolean forceOnlyMissing) throws SchemaException {
        CoordinateReferenceSystem originalCs;
        if (forcedCS == null) {
            throw new NullPointerException("CoordinateSystem required");
        }
        CoordinateReferenceSystem coordinateReferenceSystem = originalCs = startingType.getGeometryDescriptor() != null ? startingType.getGeometryDescriptor().getCoordinateReferenceSystem() : null;
        if (forcedCS.equals(originalCs)) {
            return startingType;
        }
        return FeatureTypes.transform(startingType, forcedCS, forceOnlyMissing);
    }

    @Override
    public ReferencedEnvelope getBounds() {
        ReferencedEnvelope env = this.results.getBounds();
        if (env == null) {
            return null;
        }
        env = new ReferencedEnvelope(env, this.getSchema().getCoordinateReferenceSystem());
        return env;
    }

    public FeatureCollection<SimpleFeatureType, SimpleFeature> getOrigin() {
        return this.results;
    }

    @Override
    public void accepts(FeatureVisitor visitor, ProgressListener progress) throws IOException {
        if (this.canDelegate(visitor)) {
            this.results.accepts(visitor, progress);
        } else {
            super.accepts(visitor, progress);
        }
    }

    protected boolean canDelegate(FeatureVisitor visitor) {
        return ReprojectingFeatureCollection.isGeometryless(visitor, this.schema);
    }
}

