/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.store;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import org.geotools.api.data.FeatureEvent;
import org.geotools.api.data.FeatureListener;
import org.geotools.api.data.Transaction;
import org.geotools.api.feature.type.Name;
import org.geotools.data.store.ContentDataStore;
import org.geotools.data.store.ContentState;

public class ContentEntry {
    Name typeName;
    Map<Transaction, ContentState> state;
    ContentDataStore dataStore;

    public ContentEntry(ContentDataStore dataStore, Name typeName) {
        this.typeName = typeName;
        this.dataStore = dataStore;
        this.state = new ConcurrentHashMap<Transaction, ContentState>();
        ContentState autoState = dataStore.createContentState(this);
        autoState.setTransaction(Transaction.AUTO_COMMIT);
        this.state.put(Transaction.AUTO_COMMIT, autoState);
    }

    public Name getName() {
        return this.typeName;
    }

    public String getTypeName() {
        return this.typeName.getLocalPart();
    }

    public ContentDataStore getDataStore() {
        return this.dataStore;
    }

    public ContentState getState(Transaction transaction) {
        if (transaction != null && this.state.containsKey(transaction)) {
            return this.state.get(transaction);
        }
        ContentState auto = this.state.get(Transaction.AUTO_COMMIT);
        ContentState copy = auto.copy();
        Transaction t = transaction != null ? transaction : Transaction.AUTO_COMMIT;
        copy.setTransaction(t);
        this.state.put(t, copy);
        return copy;
    }

    void notifiyFeatureEvent(ContentState source, FeatureEvent notification) {
        for (ContentState entry : this.state.values()) {
            if (entry == source) continue;
            for (FeatureListener listener : entry.listeners) {
                try {
                    listener.changed(notification);
                }
                catch (Throwable t) {
                    this.dataStore.LOGGER.log(Level.WARNING, "Problem issuing feature event " + String.valueOf(notification), t);
                }
            }
        }
    }

    public void dispose() {
        for (ContentState s : this.state.values()) {
            s.close();
        }
    }

    public void clearTransaction(Transaction transaction) {
        if (this.state.containsKey(transaction)) {
            this.state.remove(transaction);
        }
    }

    public String toString() {
        return "ContentEntry " + this.getTypeName();
    }
}

