/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.util;

import java.io.File;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.TimeZone;
import org.geotools.data.util.DataUrlHandler;
import org.geotools.util.Converter;
import org.geotools.util.ConverterFactory;
import org.geotools.util.factory.Hints;

public class CommonsConverterFactory
implements ConverterFactory {
    private static HashMap<Class<?>, Converter> register = new HashMap();

    public Converter createConverter(Class<?> source, Class<?> target, Hints hints) {
        if (source == null || !source.equals(String.class)) {
            return null;
        }
        Converter converter = register.get(target);
        if (converter != null) {
            return converter;
        }
        return null;
    }

    static {
        register.put(URI.class, new URIConverter());
        register.put(Number.class, new NumberConverter());
        register.put(Byte.class, new ByteConverter());
        register.put(Byte.TYPE, new ByteConverter());
        register.put(Short.class, new ShortConverter());
        register.put(Short.TYPE, new ShortConverter());
        register.put(Integer.class, new IntegerConverter());
        register.put(Integer.TYPE, new IntegerConverter());
        register.put(Long.class, new LongConverter());
        register.put(Long.TYPE, new LongConverter());
        register.put(BigInteger.class, new BigIntegerConverter());
        register.put(Float.class, new FloatConverter());
        register.put(Float.TYPE, new FloatConverter());
        register.put(Double.class, new DoubleConverter());
        register.put(Double.TYPE, new DoubleConverter());
        register.put(BigDecimal.class, new BigDecimalConverter());
        register.put(Boolean.class, new BooleanConverter());
        register.put(Boolean.TYPE, new BooleanConverter());
        register.put(Character.class, new CharacterConverter());
        register.put(Character.TYPE, new CharacterConverter());
        register.put(File.class, new FileConverter());
        register.put(URL.class, new URLConverter());
        register.put(Date.class, new SQLDateConverter());
        register.put(Time.class, new SQLTimeConverter());
        register.put(Timestamp.class, new SQLTimestampConverter());
        register.put(TimeZone.class, new TimeZoneConverter());
        register.put(java.util.Date.class, new DateConverter());
    }

    static class URIConverter
    implements Converter {
        URIConverter() {
        }

        public <T> T convert(Object source, Class<T> target) throws Exception {
            if (source == null) {
                return null;
            }
            String string = (String)source;
            try {
                URI uri = new URI(string);
                return target.cast(uri);
            }
            catch (URISyntaxException uRISyntaxException) {
                return null;
            }
        }
    }

    static class NumberConverter
    implements Converter {
        NumberConverter() {
        }

        public <T> T convert(Object source, Class<T> target) throws Exception {
            if (source == null) {
                return null;
            }
            String string = (String)source;
            Number parsed = null;
            try {
                parsed = new IntegerConverter().convert(string, Integer.class);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (parsed == null) {
                parsed = new DoubleConverter().convert(string, Double.class);
            }
            return (T)parsed;
        }
    }

    static class ByteConverter
    implements Converter {
        ByteConverter() {
        }

        public <T> T convert(Object source, Class<T> target) throws Exception {
            if (source == null) {
                return null;
            }
            String string = (String)source;
            try {
                Byte parsed = Byte.valueOf(string);
                return (T)parsed;
            }
            catch (Exception e) {
                return null;
            }
        }
    }

    static class ShortConverter
    implements Converter {
        ShortConverter() {
        }

        public <T> T convert(Object source, Class<T> target) throws Exception {
            if (source == null) {
                return null;
            }
            String string = (String)source;
            try {
                Short parsed = Short.valueOf(string);
                return (T)parsed;
            }
            catch (Exception e) {
                return null;
            }
        }
    }

    static class IntegerConverter
    implements Converter {
        IntegerConverter() {
        }

        public <T> T convert(Object source, Class<T> target) throws Exception {
            if (source == null) {
                return null;
            }
            String string = (String)source;
            try {
                Integer parsed = Integer.valueOf(string);
                return (T)parsed;
            }
            catch (Exception e) {
                return null;
            }
        }
    }

    static class LongConverter
    implements Converter {
        LongConverter() {
        }

        public <T> T convert(Object source, Class<T> target) throws Exception {
            if (source == null) {
                return null;
            }
            String string = (String)source;
            try {
                Long parsed = Long.valueOf(string);
                return (T)parsed;
            }
            catch (Exception e) {
                return null;
            }
        }
    }

    static class BigIntegerConverter
    implements Converter {
        BigIntegerConverter() {
        }

        public <T> T convert(Object source, Class<T> target) throws Exception {
            if (source == null) {
                return null;
            }
            String string = (String)source;
            try {
                BigInteger parsed = new BigInteger(string);
                return target.cast(parsed);
            }
            catch (Exception e) {
                return null;
            }
        }
    }

    static class FloatConverter
    implements Converter {
        FloatConverter() {
        }

        public <T> T convert(Object source, Class<T> target) throws Exception {
            if (source == null) {
                return null;
            }
            String string = (String)source;
            try {
                Float parsed = Float.valueOf(string);
                return (T)parsed;
            }
            catch (Exception e) {
                return null;
            }
        }
    }

    static class DoubleConverter
    implements Converter {
        DoubleConverter() {
        }

        public <T> T convert(Object source, Class<T> target) throws Exception {
            if (source == null) {
                return null;
            }
            String string = (String)source;
            try {
                Double parsed = Double.valueOf(string);
                return (T)parsed;
            }
            catch (Exception e) {
                return null;
            }
        }
    }

    static class BigDecimalConverter
    implements Converter {
        BigDecimalConverter() {
        }

        public <T> T convert(Object source, Class<T> target) throws Exception {
            if (source == null) {
                return null;
            }
            String string = (String)source;
            try {
                BigDecimal parsed = new BigDecimal(string);
                return target.cast(parsed);
            }
            catch (Exception e) {
                return null;
            }
        }
    }

    static class BooleanConverter
    implements Converter {
        BooleanConverter() {
        }

        public <T> T convert(Object source, Class<T> target) throws Exception {
            if (source == null) {
                return null;
            }
            String string = (String)source;
            if (string.equalsIgnoreCase("yes") || string.equalsIgnoreCase("y") || string.equalsIgnoreCase("true") || string.equalsIgnoreCase("on") || string.equalsIgnoreCase("1")) {
                return (T)Boolean.TRUE;
            }
            if (string.equalsIgnoreCase("no") || string.equalsIgnoreCase("n") || string.equalsIgnoreCase("false") || string.equalsIgnoreCase("off") || string.equalsIgnoreCase("0")) {
                return (T)Boolean.FALSE;
            }
            return null;
        }
    }

    static class CharacterConverter
    implements Converter {
        CharacterConverter() {
        }

        public <T> T convert(Object source, Class<T> target) throws Exception {
            if (source == null) {
                return null;
            }
            String string = (String)source;
            if (string.length() > 0) {
                return target.cast(Character.valueOf(string.charAt(0)));
            }
            return null;
        }
    }

    static class FileConverter
    implements Converter {
        FileConverter() {
        }

        public <T> T convert(Object source, Class<T> target) throws Exception {
            if (source == null) {
                return null;
            }
            String string = (String)source;
            try {
                File parsed = new File(string);
                return target.cast(parsed);
            }
            catch (Exception e) {
                return null;
            }
        }
    }

    static class URLConverter
    implements Converter {
        URLConverter() {
        }

        public <T> T convert(Object source, Class<T> target) throws Exception {
            if (source == null) {
                return null;
            }
            String string = (String)source;
            try {
                URL parsed = new URL(string);
                return target.cast(parsed);
            }
            catch (Exception e) {
                return this.tryGetDataURL(string, target);
            }
        }

        private <T> T tryGetDataURL(String string, Class<T> target) {
            if (string.startsWith("data:")) {
                try {
                    URL parsed = new URL(null, string, new DataUrlHandler());
                    return target.cast(parsed);
                }
                catch (Exception e2) {
                    return null;
                }
            }
            return null;
        }
    }

    static class SQLDateConverter
    implements Converter {
        SQLDateConverter() {
        }

        public <T> T convert(Object source, Class<T> target) throws Exception {
            if (source == null) {
                return null;
            }
            String string = (String)source;
            try {
                Date parsed = Date.valueOf(string);
                return target.cast(parsed);
            }
            catch (Exception e) {
                return null;
            }
        }
    }

    static class SQLTimeConverter
    implements Converter {
        SQLTimeConverter() {
        }

        public <T> T convert(Object source, Class<T> target) throws Exception {
            if (source == null) {
                return null;
            }
            String string = (String)source;
            try {
                Time parsed = Time.valueOf(string);
                return target.cast(parsed);
            }
            catch (Exception e) {
                return null;
            }
        }
    }

    static class SQLTimestampConverter
    implements Converter {
        SQLTimestampConverter() {
        }

        public <T> T convert(Object source, Class<T> target) throws Exception {
            if (source == null) {
                return null;
            }
            String string = (String)source;
            try {
                Timestamp parsed = Timestamp.valueOf(string);
                return target.cast(parsed);
            }
            catch (Exception e) {
                return null;
            }
        }
    }

    static class TimeZoneConverter
    implements Converter {
        TimeZoneConverter() {
        }

        public <T> T convert(Object source, Class<T> target) throws Exception {
            if (source == null) {
                return null;
            }
            String string = (String)source;
            TimeZone timezone = TimeZone.getTimeZone(string);
            if (!string.equals(timezone.getID())) {
                return null;
            }
            return target.cast(timezone);
        }
    }

    static class DateConverter
    implements Converter {
        public static List<String> formats = Arrays.asList("yyyy-MM-dd HH:mm:ss.S a", "yyyy-MM-dd HH:mm:ssa", "yyyy-MM-dd'T'HH:mm:ss.SSSX");

        DateConverter() {
        }

        public <T> T convert(Object source, Class<T> target) throws Exception {
            if (source == null) {
                return null;
            }
            String string = (String)source;
            for (String format : formats) {
                try {
                    return target.cast(new SimpleDateFormat(format).parse(string));
                }
                catch (Exception exception) {
                }
            }
            return null;
        }
    }
}

