/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.util;

import java.util.Collection;
import org.geotools.api.feature.Attribute;
import org.geotools.api.feature.ComplexAttribute;
import org.geotools.api.feature.GeometryAttribute;
import org.geotools.api.filter.identity.FeatureId;
import org.geotools.feature.AttributeImpl;
import org.geotools.filter.identity.FeatureIdImpl;
import org.geotools.util.Converter;
import org.geotools.util.ConverterFactory;
import org.geotools.util.Converters;
import org.geotools.util.factory.Hints;

public class ComplexAttributeConverterFactory
implements ConverterFactory {
    public Converter createConverter(Class<?> source, Class<?> target, Hints hints) {
        if (ComplexAttribute.class.isAssignableFrom(source)) {
            return new Converter(){

                public <T> T convert(Object source, Class<T> target) throws Exception {
                    if (source instanceof ComplexAttribute) {
                        Collection valueMap = ((ComplexAttribute)source).getValue();
                        if (valueMap.isEmpty() || valueMap.size() > 1) {
                            return null;
                        }
                        source = valueMap.iterator().next();
                        if (AttributeImpl.class.equals(source.getClass())) {
                            return (T)Converters.convert((Object)((Attribute)source).getValue(), target);
                        }
                    }
                    return null;
                }
            };
        }
        if (GeometryAttribute.class.isAssignableFrom(source)) {
            return new Converter(){

                public <T> T convert(Object source, Class<T> target) throws Exception {
                    if (source instanceof GeometryAttribute) {
                        GeometryAttribute attribute = (GeometryAttribute)source;
                        return (T)Converters.convert((Object)attribute.getValue(), target);
                    }
                    return null;
                }
            };
        }
        if (FeatureId.class.isAssignableFrom(target) && String.class.isAssignableFrom(source)) {
            return new Converter(){

                public <T> T convert(Object source, Class<T> target) throws Exception {
                    if (source != null) {
                        return target.cast(new FeatureIdImpl((String)source));
                    }
                    return null;
                }
            };
        }
        if (Attribute.class.isAssignableFrom(source)) {
            return new Converter(){

                public <T> T convert(Object source, Class<T> target) throws Exception {
                    if (source instanceof Attribute) {
                        Attribute attribute = (Attribute)source;
                        Object value = attribute.getValue();
                        return target.cast(Converters.convert((Object)value, target));
                    }
                    return null;
                }
            };
        }
        if (Collection.class.isAssignableFrom(source) && target == String.class) {
            return new Converter(){

                public <T> T convert(Object source, Class<T> target) throws Exception {
                    if (!ComplexAttributeConverterFactory.this.isCollectionOf(source, Attribute.class)) {
                        return null;
                    }
                    StringBuilder builder = new StringBuilder();
                    Collection collection = (Collection)source;
                    for (Object element : collection) {
                        if (element == null) {
                            builder.append("NULL, ");
                            continue;
                        }
                        builder.append((String)Converters.convert(element, String.class));
                        builder.append(", ");
                    }
                    if (builder.length() == 0) {
                        return target.cast("");
                    }
                    builder.delete(builder.length() - 2, builder.length());
                    return target.cast(builder.toString());
                }
            };
        }
        return null;
    }

    private boolean isCollectionOf(Object source, Class<?> expected) {
        if (!(source instanceof Collection)) {
            return false;
        }
        Collection collection = (Collection)source;
        for (Object element : collection) {
            if (element != null && expected.isAssignableFrom(element.getClass())) continue;
            return false;
        }
        return true;
    }
}

