/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.feature.visitor;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.geotools.api.feature.Feature;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.filter.FilterFactory;
import org.geotools.api.filter.expression.Expression;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.visitor.AbstractCalcResult;
import org.geotools.feature.visitor.CalcResult;
import org.geotools.feature.visitor.CalcUtil;
import org.geotools.feature.visitor.FeatureAttributeVisitor;
import org.geotools.feature.visitor.FeatureCalc;
import org.geotools.filter.IllegalFilterException;

public class MaxVisitor
implements FeatureCalc,
FeatureAttributeVisitor {
    private Expression expr;
    Comparable maxvalue;
    boolean visited = false;
    int countNull = 0;
    int countNaN = 0;

    public MaxVisitor(String attributeTypeName) {
        FilterFactory factory = CommonFactoryFinder.getFilterFactory(null);
        this.expr = factory.property(attributeTypeName);
    }

    public MaxVisitor(int attributeTypeIndex, SimpleFeatureType type) throws IllegalFilterException {
        FilterFactory factory = CommonFactoryFinder.getFilterFactory(null);
        this.expr = factory.property(type.getDescriptor(attributeTypeIndex).getLocalName());
    }

    public MaxVisitor(String attrName, SimpleFeatureType type) throws IllegalFilterException {
        FilterFactory factory = CommonFactoryFinder.getFilterFactory(null);
        this.expr = factory.property(type.getDescriptor(attrName).getLocalName());
    }

    public MaxVisitor(Expression expr) throws IllegalFilterException {
        this.expr = expr;
    }

    public void init(SimpleFeatureCollection collection) {
    }

    @Override
    public List<Expression> getExpressions() {
        return Arrays.asList(this.expr);
    }

    @Override
    public Optional<List<Class>> getResultType(List<Class> inputTypes) {
        return CalcUtil.reflectInputTypes(1, inputTypes);
    }

    public void visit(SimpleFeature feature) {
        this.visit((Feature)feature);
    }

    public void visit(Feature feature) {
        Double double1;
        double doubleVal;
        Object attribValue = this.expr.evaluate((Object)feature);
        if (attribValue == null) {
            ++this.countNull;
            return;
        }
        if (attribValue instanceof Double && (Double.isNaN(doubleVal = (double1 = (Double)attribValue).doubleValue()) || Double.isInfinite(doubleVal))) {
            ++this.countNaN;
            return;
        }
        Comparable curvalue = (Comparable)attribValue;
        if (!this.visited || this.compare(curvalue)) {
            this.maxvalue = curvalue;
            this.visited = true;
        }
    }

    private boolean compare(Comparable curvalue) {
        if (this.maxvalue == null) {
            throw new IllegalStateException("maxvalue shouldn't be null when visited = true");
        }
        return curvalue.compareTo(this.maxvalue) > 0;
    }

    public Comparable getMax() {
        if (!this.visited) {
            throw new IllegalStateException("Must visit before max value is ready!");
        }
        return this.maxvalue;
    }

    public int getNaNCount() {
        return this.countNaN;
    }

    public int getNullCount() {
        return this.countNull;
    }

    public void reset() {
        this.visited = false;
        this.maxvalue = null;
        this.countNaN = 0;
        this.countNull = 0;
    }

    public Expression getExpression() {
        return this.expr;
    }

    @Override
    public CalcResult getResult() {
        if (!this.visited) {
            return CalcResult.NULL_RESULT;
        }
        return new MaxResult(this.maxvalue);
    }

    public void setValue(Object result) {
        this.visited = true;
        this.maxvalue = (Comparable)result;
    }

    public static class MaxResult
    extends AbstractCalcResult {
        private Comparable maxValue;

        public MaxResult(Comparable newMaxValue) {
            this.maxValue = newMaxValue;
        }

        @Override
        public Object getValue() {
            Comparable max = this.maxValue;
            return max;
        }

        @Override
        public boolean isCompatible(CalcResult targetResults) {
            return targetResults instanceof MaxResult || targetResults == CalcResult.NULL_RESULT;
        }

        @Override
        public CalcResult merge(CalcResult resultsToAdd) {
            if (!this.isCompatible(resultsToAdd)) {
                throw new IllegalArgumentException("Parameter is not a compatible type");
            }
            if (resultsToAdd == CalcResult.NULL_RESULT) {
                return this;
            }
            if (resultsToAdd instanceof MaxResult) {
                Comparable toAdd = (Comparable)resultsToAdd.getValue();
                Comparable newMax = this.maxValue;
                if (newMax.getClass() != toAdd.getClass()) {
                    Class bestClass = CalcUtil.bestClass(toAdd, newMax);
                    if (bestClass != toAdd.getClass()) {
                        toAdd = (Comparable)CalcUtil.convert(toAdd, bestClass);
                    }
                    if (bestClass != newMax.getClass()) {
                        newMax = (Comparable)CalcUtil.convert(newMax, bestClass);
                    }
                }
                if (newMax.compareTo(toAdd) < 0) {
                    newMax = toAdd;
                }
                return new MaxResult(newMax);
            }
            throw new IllegalArgumentException("The CalcResults claim to be compatible, but the appropriate merge method has not been implemented.");
        }
    }
}

