/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.logging.Logger;
import org.geotools.api.filter.FilterFactory;
import org.geotools.api.filter.FilterVisitor;
import org.geotools.api.filter.Id;
import org.geotools.api.filter.identity.Identifier;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.filter.AbstractFilter;
import org.geotools.filter.identity.FeatureIdImpl;
import org.geotools.util.logging.Logging;

public class FidFilterImpl
extends AbstractFilter
implements Id {
    private static final Logger LOGGER = Logging.getLogger(FidFilterImpl.class);
    private Set<Identifier> fids = new LinkedHashSet<Identifier>();
    private Set<String> ids = new LinkedHashSet<String>();

    protected FidFilterImpl(Set<? extends Identifier> fids) {
        for (Identifier identifier : fids) {
            if (identifier instanceof Identifier) continue;
            throw new ClassCastException("Fids must implement Identifier, " + String.valueOf(identifier.getClass()) + " does not");
        }
        this.fids = new LinkedHashSet<Identifier>(fids);
        for (Identifier identifier : this.fids) {
            this.ids.add(identifier.getID().toString());
        }
    }

    public Set<Object> getIDs() {
        return new HashSet<Object>(this.getFidsSet());
    }

    public Set<Identifier> getIdentifiers() {
        return this.fids;
    }

    public void setIDs(Set ids) {
        this.fids = new HashSet<Identifier>();
        this.addAllFids(ids);
    }

    public Set<String> getFidsSet() {
        return this.fids();
    }

    private Set<String> fids() {
        return new HashSet<String>(this.ids);
    }

    public final void addFid(String fid) {
        LOGGER.finest("got fid: " + fid);
        this.fids.add((Identifier)new FeatureIdImpl(fid));
        this.ids.add(fid);
    }

    public void addAllFids(Collection fidsToAdd) {
        if (fidsToAdd == null) {
            return;
        }
        for (Object o : fidsToAdd) {
            String fid = (String)o;
            this.addFid(fid);
        }
    }

    public final void removeFid(String fid) {
        if (fid == null) {
            return;
        }
        Iterator<Identifier> f = this.fids.iterator();
        while (f.hasNext()) {
            Identifier featureId = f.next();
            if (!fid.equals(featureId.getID().toString())) continue;
            f.remove();
            this.ids.remove(fid);
        }
    }

    public void removeAllFids(Collection fidsToRemove) {
        if (fidsToRemove == null) {
            return;
        }
        for (Object o : fidsToRemove) {
            String fid = (String)o;
            this.removeFid(fid);
        }
    }

    public boolean evaluate(Object feature) {
        if (feature == null) {
            return false;
        }
        FilterFactory ff = CommonFactoryFinder.getFilterFactory(null);
        String evaluate = (String)ff.property("@id").evaluate(feature, String.class);
        if (evaluate == null) {
            return false;
        }
        return this.ids.contains(evaluate);
    }

    public String toString() {
        StringBuffer fidFilter = new StringBuffer();
        Iterator<Identifier> fidIterator = this.fids.iterator();
        while (fidIterator.hasNext()) {
            fidFilter.append(fidIterator.next().toString());
            if (!fidIterator.hasNext()) continue;
            fidFilter.append(", ");
        }
        return "[ " + fidFilter.toString() + " ]";
    }

    public Object accept(FilterVisitor visitor, Object extraData) {
        return visitor.visit((Id)this, extraData);
    }

    public boolean equals(Object filter) {
        LOGGER.finest("condition: " + String.valueOf(filter));
        if (filter != null && filter.getClass() == this.getClass()) {
            FidFilterImpl other = (FidFilterImpl)filter;
            return this.fids.equals(other.fids);
        }
        return false;
    }

    public int hashCode() {
        return this.fids.hashCode();
    }
}

