/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter;

import java.util.ArrayList;
import java.util.Collection;
import org.geotools.api.feature.Attribute;
import org.geotools.api.feature.ComplexAttribute;
import org.geotools.api.feature.Property;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.feature.type.Name;
import org.geotools.api.filter.Filter;
import org.geotools.api.filter.expression.Expression;
import org.geotools.feature.NameImpl;

public abstract class FilterAbstract
implements Filter {
    protected FilterAbstract() {
    }

    public boolean accepts(SimpleFeature feature) {
        return this.evaluate(feature);
    }

    private Object unpack(Object value) {
        if (value instanceof ComplexAttribute) {
            ComplexAttribute attribute = (ComplexAttribute)value;
            Property simpleContent = attribute.getProperty((Name)new NameImpl("simpleContent"));
            if (simpleContent == null) {
                return null;
            }
            return simpleContent.getValue();
        }
        if (value instanceof Attribute) {
            Attribute attribute = (Attribute)value;
            return attribute.getValue();
        }
        return value;
    }

    protected Object eval(Expression expression, Object object) {
        if (expression == null) {
            return null;
        }
        Object value = expression.evaluate(object);
        if (value instanceof Collection) {
            ArrayList<Object> list = new ArrayList<Object>();
            for (Object member : (Collection)value) {
                list.add(this.unpack(member));
            }
            return list;
        }
        return this.unpack(value);
    }

    protected Object eval(Expression expression, Object object, Class<?> context) {
        if (expression == null) {
            return null;
        }
        return expression.evaluate(object, context);
    }
}

