/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.logging.Logger;
import org.geotools.api.filter.BinaryComparisonOperator;
import org.geotools.api.filter.Filter;
import org.geotools.api.filter.FilterFactory;
import org.geotools.api.filter.Id;
import org.geotools.api.filter.PropertyIsBetween;
import org.geotools.api.filter.PropertyIsLike;
import org.geotools.api.filter.PropertyIsNull;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.filter.expression.Literal;
import org.geotools.api.filter.identity.FeatureId;
import org.geotools.api.filter.spatial.BBOX;
import org.geotools.api.filter.spatial.Beyond;
import org.geotools.api.filter.spatial.BinarySpatialOperator;
import org.geotools.api.filter.spatial.DWithin;
import org.geotools.api.geometry.BoundingBox;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.filter.ExpressionDOMParser;
import org.geotools.filter.IllegalFilterException;
import org.geotools.geometry.jts.JTS;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.util.logging.Logging;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class FilterDOMParser {
    private static final Logger LOGGER = Logging.getLogger(FilterDOMParser.class);
    private static final FilterFactory FILTER_FACT = CommonFactoryFinder.getFilterFactory(null);
    private static final int NUM_BETWEEN_CHILDREN = 3;
    private static Map<String, Integer> comparisons = new HashMap<String, Integer>();
    private static Map<String, Integer> spatial = new HashMap<String, Integer>();
    private static Map<String, Integer> logical = new HashMap<String, Integer>();

    private FilterDOMParser() {
    }

    public static Filter parseFilter(Node root) {
        if (root == null || root.getNodeType() != 1) {
            LOGGER.finest("bad node input ");
            return null;
        }
        LOGGER.finest("processing root " + root.getLocalName() + " " + root.getNodeName());
        Node child = root;
        String childName = child.getLocalName();
        if (childName == null) {
            childName = child.getNodeName();
        }
        if (childName.indexOf(58) != -1) {
            childName = childName.substring(childName.indexOf(58) + 1);
        }
        LOGGER.finest("looking up " + childName);
        if (comparisons.containsKey(childName)) {
            return FilterDOMParser.parseComparisonFilter(child, childName);
        }
        if (spatial.containsKey(childName)) {
            return FilterDOMParser.parseSpatialFilter(child, childName);
        }
        if (logical.containsKey(childName)) {
            return FilterDOMParser.parseLogicalFilter(child, childName);
        }
        LOGGER.warning("unknown filter " + String.valueOf(root));
        return null;
    }

    private static Filter parseComparisonFilter(Node child, String childName) {
        LOGGER.finer("a comparision filter " + childName);
        ExpressionDOMParser expressionDOMParser = new ExpressionDOMParser(FILTER_FACT);
        try {
            short type = comparisons.get(childName).shortValue();
            LOGGER.finer("type is " + type);
            if (type == 22) {
                return FilterDOMParser.parseFidFilter((Element)child);
            }
            if (type == 19) {
                return FilterDOMParser.parseBetweenFilter(expressionDOMParser, child);
            }
            if (type == 20) {
                return FilterDOMParser.parseLikeFilter(expressionDOMParser, child);
            }
            if (type == 21) {
                return FilterDOMParser.parseNullFilter(child);
            }
            return FilterDOMParser.parseSimpleComparison(expressionDOMParser, child, childName, type);
        }
        catch (IllegalFilterException ife) {
            LOGGER.warning("Unable to build filter: " + String.valueOf(ife));
            return null;
        }
    }

    private static Filter parseLogicalFilter(Node child, String childName) {
        LOGGER.finest("a logical filter " + childName);
        try {
            ArrayList<Filter> children = new ArrayList<Filter>();
            NodeList map = child.getChildNodes();
            for (int i = 0; i < map.getLength(); ++i) {
                Node kid = map.item(i);
                if (kid == null || kid.getNodeType() != 1) continue;
                LOGGER.finest("adding to logic filter " + kid.getLocalName());
                children.add(FilterDOMParser.parseFilter(kid));
            }
            if (childName.equals("And")) {
                return FILTER_FACT.and(children);
            }
            if (childName.equals("Or")) {
                return FILTER_FACT.or(children);
            }
            if (childName.equals("Not")) {
                if (children.size() != 1) {
                    throw new IllegalFilterException("Filter negation can be applied to one and only one child filter");
                }
                return FILTER_FACT.not((Filter)children.get(0));
            }
            throw new RuntimeException("Logical filter, but not And, Or, Not? This should not happen");
        }
        catch (IllegalFilterException ife) {
            LOGGER.warning("Unable to build filter: " + String.valueOf(ife));
            return null;
        }
    }

    private static BinaryComparisonOperator parseSimpleComparison(ExpressionDOMParser expressionDOMParser, Node child, String childName, short type) {
        Node value = child.getFirstChild();
        while (value.getNodeType() != 1) {
            value = value.getNextSibling();
        }
        LOGGER.finest("add left value -> " + String.valueOf(value) + "<-");
        Expression left = expressionDOMParser.expression(value);
        value = value.getNextSibling();
        while (value.getNodeType() != 1) {
            value = value.getNextSibling();
        }
        LOGGER.finest("add right value -> " + String.valueOf(value) + "<-");
        Expression right = expressionDOMParser.expression(value);
        switch (type) {
            case 14: {
                return FILTER_FACT.equals(left, right);
            }
            case 16: {
                return FILTER_FACT.greater(left, right);
            }
            case 18: {
                return FILTER_FACT.greaterOrEqual(left, right);
            }
            case 15: {
                return FILTER_FACT.less(left, right);
            }
            case 17: {
                return FILTER_FACT.lessOrEqual(left, right);
            }
            case 23: {
                return FILTER_FACT.notEqual(left, right, true);
            }
        }
        LOGGER.warning("Unable to build filter for " + childName);
        return null;
    }

    private static Id parseFidFilter(Element child) {
        HashSet<FeatureId> ids = new HashSet<FeatureId>();
        Element fidElement = child;
        ids.add(FILTER_FACT.featureId(fidElement.getAttribute("fid")));
        for (Node sibling = fidElement.getNextSibling(); sibling != null; sibling = sibling.getNextSibling()) {
            LOGGER.finer("Parsing another FidFilter");
            if (sibling.getNodeType() != 1) continue;
            Element fidElement1 = (Element)sibling;
            String fidElementName = fidElement1.getLocalName();
            if (fidElementName == null) {
                fidElementName = fidElement1.getNodeName();
            }
            if (fidElementName.indexOf(58) != -1) {
                fidElementName = fidElementName.substring(fidElementName.indexOf(58) + 1);
            }
            if (!"FeatureId".equals(fidElementName)) continue;
            ids.add(FILTER_FACT.featureId(fidElement1.getAttribute("fid")));
        }
        return FILTER_FACT.id(ids);
    }

    private static PropertyIsLike parseLikeFilter(ExpressionDOMParser expressionDOMParser, Node child) {
        String wildcard = null;
        String single = null;
        String escape = null;
        String pattern = null;
        Object value = null;
        NodeList map = child.getChildNodes();
        int parsedExpressions = 0;
        for (int i = 0; i < map.getLength(); ++i) {
            String res;
            Node kid = map.item(i);
            if (kid == null || kid.getNodeType() != 1) continue;
            String string = res = kid.getLocalName() != null ? kid.getLocalName() : kid.getNodeName();
            if (res.indexOf(58) != -1) {
                res = res.substring(res.indexOf(58) + 1);
            }
            if (parsedExpressions == 0) {
                value = expressionDOMParser.expression(kid);
                ++parsedExpressions;
                continue;
            }
            if (parsedExpressions != true || !res.equalsIgnoreCase("Literal")) continue;
            pattern = expressionDOMParser.expression(kid).toString();
            ++parsedExpressions;
        }
        NamedNodeMap kids = child.getAttributes();
        for (int i = 0; i < kids.getLength(); ++i) {
            String res;
            Node kid = kids.item(i);
            String string = res = kid.getLocalName() != null ? kid.getLocalName() : kid.getNodeName();
            if (res.indexOf(58) != -1) {
                res = res.substring(res.indexOf(58) + 1);
            }
            if (res.equalsIgnoreCase("wildCard")) {
                wildcard = kid.getNodeValue();
            }
            if (res.equalsIgnoreCase("singleChar")) {
                single = kid.getNodeValue();
            }
            if (!res.equalsIgnoreCase("escapeChar") && !res.equalsIgnoreCase("escape")) continue;
            escape = kid.getNodeValue();
        }
        if (wildcard != null && single != null && escape != null && pattern != null) {
            LOGGER.finer("Building like filter " + value.toString() + "\n" + pattern + " " + wildcard + " " + single + " " + escape);
            return FILTER_FACT.like((Expression)value, pattern, wildcard, single, escape);
        }
        LOGGER.finer("Problem building like filter\n" + pattern + " " + wildcard + " " + single + " " + escape);
        return null;
    }

    private static PropertyIsBetween parseBetweenFilter(ExpressionDOMParser expressionDOMParser, Node child) {
        NodeList kids = child.getChildNodes();
        if (kids.getLength() < 3) {
            throw new IllegalFilterException("wrong number of children in Between filter: expected 3 got " + kids.getLength());
        }
        Node value = child.getFirstChild();
        while (value.getNodeType() != 1) {
            value = value.getNextSibling();
        }
        LOGGER.finer("add middle value -> " + String.valueOf(value) + "<-");
        Expression middle = expressionDOMParser.expression(value);
        Expression lower = null;
        Expression upper = null;
        for (int i = 0; i < kids.getLength(); ++i) {
            String kidName;
            Node kid = kids.item(i);
            String string = kidName = kid.getLocalName() != null ? kid.getLocalName() : kid.getNodeName();
            if (kidName.indexOf(58) != -1) {
                kidName = kidName.substring(kidName.indexOf(58) + 1);
            }
            if (kidName.equalsIgnoreCase("LowerBoundary")) {
                value = kid.getFirstChild();
                while (value.getNodeType() != 1) {
                    value = value.getNextSibling();
                }
                LOGGER.finer("add left value -> " + String.valueOf(value) + "<-");
                lower = expressionDOMParser.expression(value);
            }
            if (!kidName.equalsIgnoreCase("UpperBoundary")) continue;
            value = kid.getFirstChild();
            while (value.getNodeType() != 1) {
                value = value.getNextSibling();
            }
            LOGGER.finer("add right value -> " + String.valueOf(value) + "<-");
            upper = expressionDOMParser.expression(value);
        }
        return FILTER_FACT.between(middle, lower, upper);
    }

    private static PropertyIsNull parseNullFilter(Node nullNode) throws IllegalFilterException {
        ExpressionDOMParser expressionDOMParser = new ExpressionDOMParser(FILTER_FACT);
        LOGGER.finest("parsing null node: " + String.valueOf(nullNode));
        Node value = nullNode.getFirstChild();
        while (value.getNodeType() != 1) {
            value = value.getNextSibling();
        }
        LOGGER.finest("add null value -> " + String.valueOf(value) + "<-");
        Expression expr = expressionDOMParser.expression(value);
        return FILTER_FACT.isNull(expr);
    }

    private static BinarySpatialOperator parseSpatialFilter(Node child, String childName) {
        LOGGER.finest("a spatial filter " + childName);
        ExpressionDOMParser expressionDOMParser = new ExpressionDOMParser(FILTER_FACT);
        try {
            Expression right;
            String valueName;
            short type = spatial.get(childName).shortValue();
            Node value = child.getFirstChild();
            while (value.getNodeType() != 1) {
                value = value.getNextSibling();
            }
            LOGGER.finest("add left value -> " + String.valueOf(value) + "<-");
            Expression left = expressionDOMParser.expression(value);
            value = value.getNextSibling();
            while (value.getNodeType() != 1) {
                value = value.getNextSibling();
            }
            LOGGER.finest("add right value -> " + String.valueOf(value) + "<-");
            String string = valueName = value.getLocalName() != null ? value.getLocalName() : value.getNodeName();
            if (valueName.indexOf(58) != -1) {
                valueName = valueName.substring(valueName.indexOf(58) + 1);
            }
            Node nextNode = value.getNextSibling();
            if (!valueName.equalsIgnoreCase("Literal") && !valueName.equalsIgnoreCase("propertyname")) {
                Element literal = value.getOwnerDocument().createElement("literal");
                literal.appendChild(value);
                LOGGER.finest("Built new literal " + String.valueOf(literal));
                right = expressionDOMParser.expression(literal);
            } else {
                right = expressionDOMParser.expression(value);
            }
            String units = null;
            switch (type) {
                case 5: {
                    return FILTER_FACT.equal(left, right);
                }
                case 6: {
                    return FILTER_FACT.disjoint(left, right);
                }
                case 7: {
                    return FILTER_FACT.intersects(left, right);
                }
                case 8: {
                    return FILTER_FACT.touches(left, right);
                }
                case 9: {
                    return FILTER_FACT.crosses(left, right);
                }
                case 10: {
                    return FILTER_FACT.within(left, right);
                }
                case 11: {
                    return FILTER_FACT.contains(left, right);
                }
                case 12: {
                    return FILTER_FACT.overlaps(left, right);
                }
                case 24: {
                    return FilterDOMParser.parseWithinFilter(left, nextNode, right, units);
                }
                case 13: {
                    return FilterDOMParser.parseBeyondFilter(left, nextNode, right, units);
                }
                case 4: {
                    return FilterDOMParser.parseBBOXFilter(left, (Literal)right);
                }
            }
            LOGGER.warning("Unable to build filter: " + childName);
            return null;
        }
        catch (IllegalFilterException ife) {
            LOGGER.warning("Unable to build filter: " + String.valueOf(ife));
            return null;
        }
    }

    private static BBOX parseBBOXFilter(Expression left, Literal right) {
        Literal literal = right;
        Object obj = literal.getValue();
        ReferencedEnvelope bbox = null;
        if (obj instanceof Geometry) {
            Geometry geometry = (Geometry)obj;
            bbox = JTS.toEnvelope(geometry);
        } else if (obj instanceof ReferencedEnvelope) {
            ReferencedEnvelope envelope1;
            bbox = envelope1 = (ReferencedEnvelope)((Object)obj);
        } else if (obj instanceof Envelope) {
            Envelope envelope = (Envelope)obj;
            bbox = new ReferencedEnvelope(envelope, null);
        }
        return FILTER_FACT.bbox(left, (BoundingBox)bbox);
    }

    private static Beyond parseBeyondFilter(Expression left, Node nextNode, Expression right, String units) {
        Node value;
        for (value = nextNode; value != null && value.getNodeType() != 1; value = value.getNextSibling()) {
        }
        if (value == null) {
            throw new IllegalFilterException("Beyond is missing the Distance element");
        }
        String nodeName = value.getNodeName();
        if (nodeName.indexOf(58) > 0) {
            nodeName = nodeName.substring(nodeName.indexOf(":") + 1);
        }
        if (!"Distance".equals(nodeName)) {
            throw new IllegalFilterException("Parsing Beyond, was expecting to find Distance but found " + value.getLocalName());
        }
        double distance = Double.parseDouble(value.getTextContent());
        if (value.getAttributes().getNamedItem("units") != null) {
            units = value.getAttributes().getNamedItem("units").getTextContent();
        }
        return FILTER_FACT.beyond(left, right, distance, units);
    }

    private static DWithin parseWithinFilter(Expression left, Node nextNode, Expression right, String units) {
        Node value;
        for (value = nextNode; value != null && value.getNodeType() != 1; value = value.getNextSibling()) {
        }
        if (value == null) {
            throw new IllegalFilterException("DWithin is missing the Distance element");
        }
        String nodeName = value.getNodeName();
        if (nodeName.indexOf(58) > 0) {
            nodeName = nodeName.substring(nodeName.indexOf(":") + 1);
        }
        if (!"Distance".equals(nodeName)) {
            throw new IllegalFilterException("Parsing DWithin, was expecting to find Distance but found " + value.getLocalName());
        }
        double distance = Double.parseDouble(value.getTextContent());
        if (value.getAttributes().getNamedItem("units") != null) {
            units = value.getAttributes().getNamedItem("units").getTextContent();
        }
        return FILTER_FACT.dwithin(left, right, distance, units);
    }

    static {
        comparisons.put("PropertyIsEqualTo", 14);
        comparisons.put("PropertyIsNotEqualTo", 23);
        comparisons.put("PropertyIsGreaterThan", 16);
        comparisons.put("PropertyIsGreaterThanOrEqualTo", 18);
        comparisons.put("PropertyIsLessThan", 15);
        comparisons.put("PropertyIsLessThanOrEqualTo", 17);
        comparisons.put("PropertyIsLike", 20);
        comparisons.put("PropertyIsNull", 21);
        comparisons.put("PropertyIsBetween", 19);
        comparisons.put("FeatureId", 22);
        spatial.put("Equals", 5);
        spatial.put("Disjoint", 6);
        spatial.put("Intersects", 7);
        spatial.put("Touches", 8);
        spatial.put("Crosses", 9);
        spatial.put("Within", 10);
        spatial.put("Contains", 11);
        spatial.put("Overlaps", 12);
        spatial.put("BBOX", 4);
        spatial.put("Beyond", 13);
        spatial.put("DWithin", 24);
        logical.put("And", 2);
        logical.put("Or", 1);
        logical.put("Not", 3);
    }
}

