/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter;

import java.awt.RenderingHints;
import org.geotools.api.filter.FilterVisitor;
import org.geotools.api.filter.MultiValuedFilter;
import org.geotools.api.filter.PropertyIsEqualTo;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.filter.expression.Literal;
import org.geotools.filter.MultiCompareFilterImpl;
import org.geotools.util.ConverterFactory;
import org.geotools.util.Converters;
import org.geotools.util.factory.Hints;

public class IsEqualsToImpl
extends MultiCompareFilterImpl
implements PropertyIsEqualTo {
    public static final Hints SAFE_CONVERSION_HINTS = new Hints((RenderingHints.Key)ConverterFactory.SAFE_CONVERSION, (Object)true);

    protected IsEqualsToImpl(Expression expression1, Expression expression2) {
        this(expression1, expression2, true);
    }

    protected IsEqualsToImpl(Expression expression1, Expression expression2, MultiValuedFilter.MatchAction matchAction) {
        this(expression1, expression2, true, matchAction);
    }

    protected IsEqualsToImpl(Expression expression1, Expression expression2, boolean matchCase) {
        super(expression1, expression2, matchCase);
    }

    protected IsEqualsToImpl(Expression expression1, Expression expression2, boolean matchCase, MultiValuedFilter.MatchAction matchAction) {
        super(expression1, expression2, matchCase, matchAction);
    }

    @Override
    public boolean evaluateInternal(Object value1, Object value2) {
        Object v2;
        Object v1;
        if (value1 == value2) {
            return true;
        }
        if (value1 == null || value2 == null) {
            return false;
        }
        if (!this.matchingCase && value1 instanceof String) {
            String string = (String)value1;
            if (value2 instanceof String) {
                String string1 = (String)value2;
                return string.equalsIgnoreCase(string1);
            }
        }
        if (value1.equals(value2)) {
            return true;
        }
        if (value1.getClass().equals(value2.getClass())) {
            return false;
        }
        if (this.expression1 instanceof Literal && !(this.expression2 instanceof Literal) ? (v1 = Converters.convert((Object)value1, value2.getClass())) != null && v1.equals(value2) : this.expression2 instanceof Literal && !(this.expression1 instanceof Literal) && (v2 = Converters.convert((Object)value2, value1.getClass())) != null && v2.equals(value1)) {
            return true;
        }
        if (value1 instanceof String && !(value2 instanceof String) ? (v1 = Converters.convert((Object)value1, value2.getClass(), (Hints)SAFE_CONVERSION_HINTS)) != null && v1.equals(value2) : value2 instanceof String && !(value1 instanceof String) && (v2 = Converters.convert((Object)value2, value1.getClass(), (Hints)SAFE_CONVERSION_HINTS)) != null && v2.equals(value1)) {
            return true;
        }
        boolean isNumeric1 = value1 instanceof Number;
        boolean isNumeric2 = value2 instanceof Number;
        if (isNumeric1 && isNumeric2 || isNumeric1 && value2 instanceof CharSequence || isNumeric2 && value1 instanceof CharSequence) {
            long lg2;
            Number n2;
            Number n1;
            try {
                n1 = isNumeric1 ? (Number)((Number)value1) : (Number)IsEqualsToImpl.parseToNumber(value1.toString());
                n2 = isNumeric2 ? (Number)((Number)value2) : (Number)IsEqualsToImpl.parseToNumber(value2.toString());
            }
            catch (NumberFormatException e) {
                return false;
            }
            double fp1 = n1.doubleValue();
            double fp2 = n2.doubleValue();
            long lg1 = n1.longValue();
            if (fp1 == (double)lg1 && fp2 == (double)(lg2 = n2.longValue())) {
                return lg1 == lg2;
            }
            return fp1 == fp2 || Double.isNaN(fp1) && Double.isNaN(fp2);
        }
        if (!this.isMatchingCase()) {
            String s1 = (String)Converters.convert((Object)value1, String.class);
            String s2 = (String)Converters.convert((Object)value2, String.class);
            return s1.equalsIgnoreCase(s2);
        }
        return false;
    }

    private static Number parseToNumber(String value) throws NumberFormatException {
        try {
            return Long.valueOf(value);
        }
        catch (NumberFormatException e) {
            return Double.valueOf(value);
        }
    }

    @Override
    public Object accept(FilterVisitor visitor, Object extraData) {
        return visitor.visit((PropertyIsEqualTo)this, extraData);
    }
}

