/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.function;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.api.feature.type.Name;
import org.geotools.api.filter.FilterFactory;
import org.geotools.api.filter.capability.FunctionName;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.filter.expression.Function;
import org.geotools.api.filter.expression.Literal;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.NameImpl;
import org.geotools.filter.FunctionExpression;
import org.geotools.filter.FunctionExpressionImpl;
import org.geotools.filter.FunctionFactory;
import org.geotools.filter.FunctionImpl;
import org.geotools.util.logging.Logging;

public class DefaultFunctionFactory
implements FunctionFactory {
    private static final Logger LOGGER = Logging.getLogger(DefaultFunctionFactory.class);
    private FilterFactory filterFactory = CommonFactoryFinder.getFilterFactory(null);
    private volatile Map<Name, FunctionDescriptor> functionCache;

    @Override
    public List<FunctionName> getFunctionNames() {
        ArrayList<FunctionName> list = new ArrayList<FunctionName>(this.functionCache().size());
        for (FunctionDescriptor fd : this.functionCache().values()) {
            list.add(fd.name);
        }
        return list;
    }

    @Override
    public Function function(String name, List<Expression> parameters, Literal fallback) {
        return this.function(new NameImpl(name), parameters, fallback);
    }

    @Override
    public Function function(Name name, List<Expression> parameters, Literal fallback) {
        Name key = this.functionName(name);
        FunctionDescriptor fd = this.functionCache().get(key);
        if (fd == null && (fd = this.functionCache().get(name)) == null) {
            return null;
        }
        try {
            Function newFunction = fd.newFunction(parameters, fallback);
            return newFunction;
        }
        catch (Exception e) {
            LOGGER.log(Level.FINER, "Unable to create function " + String.valueOf(name) + "Function", e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<Name, FunctionDescriptor> functionCache() {
        if (this.functionCache == null) {
            DefaultFunctionFactory defaultFunctionFactory = this;
            synchronized (defaultFunctionFactory) {
                if (this.functionCache == null) {
                    this.functionCache = this.loadFunctions();
                }
            }
        }
        return this.functionCache;
    }

    private FunctionName getFunctionName(Function function) {
        String name = function.getName();
        FunctionName functionName = function.getFunctionName();
        if (functionName == null && function instanceof FunctionExpressionImpl) {
            functionName = function.getFunctionName();
        }
        if (functionName == null) {
            int argc = function.getParameters().size();
            functionName = this.filterFactory.functionName(name, argc);
            if (!functionName.getName().equals(name)) {
                LOGGER.warning(String.valueOf(function.getClass()) + " FunctionName was null, used for etArgumentCount(): " + String.valueOf(functionName));
            }
        } else if (!functionName.getName().equals(name)) {
            LOGGER.warning(String.valueOf(function.getClass()) + " has name conflict betwee '" + name + "' and '" + functionName.getName() + "'");
        }
        return functionName;
    }

    private Map<Name, FunctionDescriptor> loadFunctions() {
        HashMap<Name, FunctionDescriptor> functionMap = new HashMap<Name, FunctionDescriptor>();
        Set<Function> functions = CommonFactoryFinder.getFunctions(null);
        for (Function function : functions) {
            FunctionName functionName = this.getFunctionName(function);
            Name name = functionName.getFunctionName();
            FunctionDescriptor fd = new FunctionDescriptor(functionName, function.getClass());
            Name key = this.functionName(name);
            if (functionMap.containsKey(key)) {
                FunctionDescriptor conflict = (FunctionDescriptor)functionMap.get(key);
                LOGGER.warning("Function " + String.valueOf(key) + " clash between " + conflict.clazz.getSimpleName() + " and " + function.getClass().getSimpleName());
            }
            functionMap.put(key, fd);
        }
        return functionMap;
    }

    private Name functionName(Name functionName) {
        String name = functionName.getLocalPart();
        int index = -1;
        index = name.indexOf("Function");
        if (index != -1) {
            name = name.substring(0, index);
        }
        name = name.toLowerCase().trim();
        return new NameImpl(functionName.getNamespaceURI(), functionName.getSeparator(), name);
    }

    static class FunctionDescriptor {
        FunctionName name;
        Class<? extends Function> clazz;

        FunctionDescriptor(FunctionName name, Class<? extends Function> clazz) {
            this.name = name;
            this.clazz = clazz;
        }

        Function newFunction(List<Expression> parameters, Literal fallback) throws Exception {
            if (FunctionExpression.class.isAssignableFrom(this.clazz)) {
                FunctionExpression function = (FunctionExpression)this.clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                if (parameters != null) {
                    function.setParameters(parameters);
                }
                if (fallback != null) {
                    function.setFallbackValue(fallback);
                }
                return function;
            }
            if (FunctionImpl.class.isAssignableFrom(this.clazz)) {
                FunctionImpl function = (FunctionImpl)this.clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                if (parameters != null) {
                    function.setParameters(parameters);
                }
                if (fallback != null) {
                    function.setFallbackValue(fallback);
                }
                return function;
            }
            Constructor<? extends Function> constructor = this.clazz.getConstructor(List.class, Literal.class);
            return constructor.newInstance(parameters, fallback);
        }
    }
}

