/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.function;

import org.geotools.api.feature.Feature;
import org.geotools.api.feature.GeometryAttribute;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.filter.capability.FunctionName;
import org.geotools.api.filter.expression.VolatileFunction;
import org.geotools.api.parameter.Parameter;
import org.geotools.filter.FunctionExpressionImpl;
import org.geotools.filter.capability.FunctionNameImpl;
import org.locationtech.jts.geom.Geometry;

public class GeometryFunction
extends FunctionExpressionImpl
implements VolatileFunction {
    public static FunctionName NAME = new FunctionNameImpl("geometry", FunctionNameImpl.parameter("geometry", Boolean.class, "Default Geometry", "Default geometry, or null if there is none."), new Parameter[0]);

    public GeometryFunction() {
        super(NAME);
    }

    public Object evaluate(Feature feature) {
        if (feature == null) {
            return null;
        }
        if (feature instanceof SimpleFeature) {
            SimpleFeature sf = (SimpleFeature)feature;
            return this.geometry(sf.getDefaultGeometry());
        }
        GeometryAttribute ga = feature.getDefaultGeometryProperty();
        if (ga == null) {
            return null;
        }
        return this.geometry(ga.getValue());
    }

    private Object geometry(Object value) {
        if (value instanceof Geometry) {
            return value;
        }
        return null;
    }

    @Override
    public Object evaluate(Object object) {
        if (object instanceof Feature) {
            Feature feature = (Feature)object;
            return this.evaluate(feature);
        }
        return null;
    }
}

