/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.function;

import org.geotools.api.filter.capability.FunctionName;
import org.geotools.filter.FunctionExpressionImpl;
import org.geotools.filter.capability.FunctionNameImpl;
import org.geotools.geometry.jts.LineStringCursor;
import org.locationtech.jts.geom.LineString;

public class MidAngleFunction
extends FunctionExpressionImpl {
    public static FunctionName NAME = new FunctionNameImpl("midAngle", FunctionNameImpl.parameter("degrees", Double.class), FunctionNameImpl.parameter("linestring", LineString.class));

    public MidAngleFunction() {
        super(NAME);
    }

    @Override
    public Object evaluate(Object feature) {
        LineString ls = (LineString)this.getExpression(0).evaluate(feature, LineString.class);
        if (ls == null || ls.getNumPoints() == 1) {
            return null;
        }
        LineStringCursor cursor = new LineStringCursor(ls);
        cursor.moveTo(cursor.getLineStringLength() / 2.0);
        double radians = cursor.getCurrentAngle();
        return -Math.toDegrees(radians);
    }
}

