/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.function;

import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.api.feature.Feature;
import org.geotools.api.feature.type.FeatureType;
import org.geotools.api.feature.type.GeometryDescriptor;
import org.geotools.api.feature.type.PropertyDescriptor;
import org.geotools.api.filter.FilterFactory;
import org.geotools.api.filter.capability.FunctionName;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.filter.expression.Literal;
import org.geotools.api.filter.expression.PropertyName;
import org.geotools.api.filter.expression.SimplifiableFunction;
import org.geotools.api.parameter.Parameter;
import org.geotools.api.referencing.FactoryException;
import org.geotools.api.referencing.crs.CompoundCRS;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.api.referencing.crs.EngineeringCRS;
import org.geotools.api.referencing.crs.GeographicCRS;
import org.geotools.api.referencing.crs.ProjectedCRS;
import org.geotools.api.referencing.operation.MathTransform;
import org.geotools.api.referencing.operation.TransformException;
import org.geotools.api.util.InternationalString;
import org.geotools.filter.FunctionExpressionImpl;
import org.geotools.filter.capability.FunctionNameImpl;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.referencing.operation.projection.CylindricalEqualArea;
import org.geotools.referencing.operation.projection.EquidistantCylindrical;
import org.geotools.referencing.operation.projection.Mercator;
import org.geotools.util.SimpleInternationalString;
import org.geotools.util.logging.Logging;
import org.locationtech.jts.algorithm.Angle;
import org.locationtech.jts.geom.Point;

public class NorthFix
extends FunctionExpressionImpl
implements SimplifiableFunction {
    static final Logger LOGGER = Logging.getLogger(NorthFix.class);
    public static final String FUNCTION_NAME = "northFix";
    public static final Parameter<Double> RESULT = FunctionNameImpl.parameter("angle", Double.class, "North fix", "Returns the fixed angle, given the current CRS and position (in case the angle is missing, the result is the offset that needs to be added to the angle.");
    public static final Parameter<CoordinateReferenceSystem> TARGET_CRS = FunctionNameImpl.parameter("targetCRS", CoordinateReferenceSystem.class, "Target coordinate reference system", "The target coordinate reference system used to paint the map");
    public static final Parameter<Point> POINT = FunctionNameImpl.parameter("point", Point.class, "point", "The point at which to perform the calculation");
    public static final org.geotools.api.data.Parameter<Double> ANGLE = new org.geotools.api.data.Parameter<Object>("angle", Double.class, (InternationalString)new SimpleInternationalString("angle"), (InternationalString)new SimpleInternationalString("The angle to be fixed (optional, defaults to 0)"), false, 0, 1, null, null);
    public static final Parameter<CoordinateReferenceSystem> SOURCE_CRS = new org.geotools.api.data.Parameter<Object>("sourceCRS", CoordinateReferenceSystem.class, (InternationalString)new SimpleInternationalString("Source Coordinate Reference System"), (InternationalString)new SimpleInternationalString("The CRS of the provided point. Optional, the function will look up the CRS of the point, and if the source is a simple feature, use its CRS instead. If none of the above is available, then the target and source CRS are assumed to be the same"), false, 0, 1, null, null);
    public static final int FULL_CIRCLE = 360;
    public static FunctionName NAME = new FunctionNameImpl("northFix", RESULT, TARGET_CRS, POINT, ANGLE, SOURCE_CRS);

    public NorthFix() {
        super(NAME);
    }

    @Override
    public Object evaluate(Object feature) {
        CoordinateReferenceSystem targetCRS = (CoordinateReferenceSystem)this.getExpression(0).evaluate(feature, CoordinateReferenceSystem.class);
        double angle = 0.0;
        if (this.getParameters().size() >= 3) {
            angle = (Double)this.getExpression(2).evaluate(feature, Double.class);
        }
        if (!NorthFix.fixRequired(targetCRS)) {
            return angle;
        }
        Point point = (Point)this.getExpression(1).evaluate(feature, Point.class);
        if (point == null) {
            return angle;
        }
        CoordinateReferenceSystem sourceCRS = this.getSourceCRS(feature, point);
        try {
            double x = point.getX();
            double y = point.getY();
            double[] pt = new double[]{x, y};
            if (sourceCRS != null && !CRS.equalsIgnoreMetadata(sourceCRS, targetCRS)) {
                MathTransform step1 = CRS.findMathTransform(sourceCRS, targetCRS, true);
                step1.transform(pt, 0, pt, 0, 1);
                x = pt[0];
                y = pt[1];
            }
            MathTransform step2 = CRS.findMathTransform(targetCRS, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84, true);
            step2.transform(pt, 0, pt, 0, 1);
            pt[1] = pt[1] + 0.01;
            step2.inverse().transform(pt, 0, pt, 0, 1);
            double northDirection = Angle.toDegrees((double)Math.atan2(pt[1] - y, pt[0] - x));
            return this.normalizeAngle(angle - northDirection + 90.0);
        }
        catch (FactoryException | TransformException e) {
            throw new RuntimeException(e);
        }
    }

    private double normalizeAngle(double angle) {
        return (angle % 360.0 + 360.0) % 360.0;
    }

    private CoordinateReferenceSystem getSourceCRS(Object feature, Point point) {
        CoordinateReferenceSystem sorceCRS;
        block6: {
            sorceCRS = null;
            if (this.getParameters().size() == 4) {
                sorceCRS = (CoordinateReferenceSystem)this.getExpression(3).evaluate(feature, CoordinateReferenceSystem.class);
            }
            if (sorceCRS == null && point.getUserData() instanceof CoordinateReferenceSystem) {
                sorceCRS = (CoordinateReferenceSystem)point.getUserData();
            }
            if (feature instanceof Feature) {
                Feature feature1 = (Feature)feature;
                sorceCRS = feature1.getType().getCoordinateReferenceSystem();
            }
            if (sorceCRS == null && point.getSRID() > 0) {
                try {
                    sorceCRS = CRS.decode("EPSG:" + point.getSRID(), true);
                }
                catch (FactoryException e) {
                    if (!LOGGER.isLoggable(Level.FINE)) break block6;
                    LOGGER.log(Level.FINE, "Could not decode EPSG:" + point.getSRID(), e);
                }
            }
        }
        return sorceCRS;
    }

    static boolean fixRequired(CoordinateReferenceSystem crs) {
        ProjectedCRS projected;
        MathTransform mt;
        if (crs == null) {
            return false;
        }
        if (crs instanceof CompoundCRS) {
            crs = CRS.getHorizontalCRS(crs);
        }
        if (crs instanceof GeographicCRS || crs instanceof EngineeringCRS) {
            return false;
        }
        return !(crs instanceof ProjectedCRS) || !NorthFix.isNorthUpProjection(mt = (projected = (ProjectedCRS)crs).getConversionFromBase().getMathTransform());
    }

    private static boolean isNorthUpProjection(MathTransform mt) {
        return mt instanceof Mercator || mt instanceof CylindricalEqualArea || mt instanceof EquidistantCylindrical;
    }

    public Expression simplify(FilterFactory ff, FeatureType featureType) {
        GeometryDescriptor gd;
        CoordinateReferenceSystem crs;
        PropertyDescriptor pd;
        CoordinateReferenceSystem crs2;
        ArrayList<Expression> parameters = new ArrayList<Expression>(this.getParameters());
        if (parameters.get(0) instanceof Literal) {
            crs2 = (CoordinateReferenceSystem)((Expression)parameters.get(0)).evaluate(null, CoordinateReferenceSystem.class);
            if (!NorthFix.fixRequired(crs2)) {
                if (parameters.size() >= 3) {
                    return (Expression)parameters.get(2);
                }
                return ff.literal(0.0);
            }
            parameters.set(0, (Expression)ff.literal((Object)crs2));
        }
        if (parameters.size() == 4) {
            if (parameters.get(3) instanceof Literal && (crs2 = (CoordinateReferenceSystem)((Expression)parameters.get(3)).evaluate(null, CoordinateReferenceSystem.class)) != null) {
                parameters.set(3, (Expression)ff.literal((Object)crs2));
            }
        } else if (featureType != null && parameters.get(2) instanceof PropertyName && (pd = (PropertyDescriptor)((Expression)parameters.get(1)).evaluate((Object)featureType, PropertyDescriptor.class)) instanceof GeometryDescriptor && (crs = (gd = (GeometryDescriptor)pd).getCoordinateReferenceSystem()) != null) {
            parameters.add(3, (Expression)ff.literal((Object)crs));
        }
        NorthFix simplified = new NorthFix();
        simplified.setParameters(parameters);
        return simplified;
    }
}

