/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.function;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import org.geotools.api.filter.capability.FunctionName;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.filter.expression.Literal;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.util.NullProgressListener;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.visitor.Aggregate;
import org.geotools.feature.visitor.CalcResult;
import org.geotools.feature.visitor.GroupByVisitor;
import org.geotools.feature.visitor.UniqueVisitor;
import org.geotools.filter.capability.FunctionNameImpl;
import org.geotools.filter.function.ClassificationFunction;
import org.geotools.filter.function.ExplicitClassifier;
import org.geotools.filter.function.RangedClassifier;

public class UniqueIntervalFunction
extends ClassificationFunction {
    public static FunctionName NAME = new FunctionNameImpl("UniqueInterval", RangedClassifier.class, FunctionNameImpl.parameter("value", Double.class), FunctionNameImpl.parameter("classes", Integer.class), FunctionNameImpl.parameter("percentages", Boolean.class, 0, 1));

    public UniqueIntervalFunction() {
        super(NAME);
    }

    private Object calculate(SimpleFeatureCollection featureCollection) {
        try {
            Literal literal;
            Boolean percentages;
            Set[] values;
            int classNum = this.getClasses();
            UniqueVisitor uniqueVisit = new UniqueVisitor(this.getParameters().get(0));
            if (this.progress == null) {
                this.progress = new NullProgressListener();
            }
            featureCollection.accepts(uniqueVisit, this.progress);
            if (this.progress.isCanceled()) {
                return null;
            }
            CalcResult calcResult = uniqueVisit.getResult();
            if (calcResult == null) {
                return null;
            }
            List result = calcResult.toList();
            Collections.sort(result, (o1, o2) -> {
                if (o1 == null) {
                    if (o2 == null) {
                        return 0;
                    }
                    return -1;
                }
                if (o2 == null) {
                    return 1;
                }
                if (o1 instanceof String) {
                    String string = (String)o1;
                    if (o2 instanceof String) {
                        String string1 = (String)o2;
                        return string.compareTo(string1);
                    }
                }
                return 0;
            });
            Object[] results = result.toArray();
            if (classNum < results.length) {
                values = new Set[classNum];
                int binPop = (int)Math.ceil((double)results.length / (double)classNum);
                int lastBigBin = results.length % classNum;
                lastBigBin = lastBigBin == 0 ? classNum : --lastBigBin;
                int itemIndex = 0;
                for (int binIndex = 0; binIndex < classNum; ++binIndex) {
                    HashSet<Object> val = new HashSet<Object>();
                    for (int binItem = 0; binItem < binPop; ++binItem) {
                        val.add(results[itemIndex++]);
                    }
                    if (lastBigBin == binIndex) {
                        --binPop;
                    }
                    values[binIndex] = val;
                }
            } else {
                if (classNum > results.length) {
                    classNum = results.length;
                }
                values = new Set[classNum];
                for (int i = 0; i < classNum; ++i) {
                    HashSet<Object> val = new HashSet<Object>();
                    val.add(results[i]);
                    values[i] = val;
                }
            }
            ExplicitClassifier classifier = new ExplicitClassifier(values);
            if (this.getParameters().size() > 2 && (percentages = (Boolean)(literal = (Literal)this.getParameters().get(2)).getValue()).booleanValue()) {
                classifier.setPercentages(this.getPercentages(featureCollection, values));
            }
            return classifier;
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, "UniqueIntervalFunction calculate failed", e);
            return null;
        }
    }

    @Override
    public Object evaluate(Object feature) {
        if (!(feature instanceof FeatureCollection)) {
            return null;
        }
        return this.calculate((SimpleFeatureCollection)feature);
    }

    private double[] getPercentages(FeatureCollection collection, Set ... values) throws IOException {
        Expression prop = this.getParameters().get(0);
        GroupByVisitor groupBy = new GroupByVisitor(Aggregate.COUNT, prop, Arrays.asList(prop), null);
        collection.accepts(groupBy, null);
        Map result = groupBy.getResult().toMap();
        return this.computePercentages(result, collection.size(), values);
    }

    private double[] computePercentages(Map<List, Integer> queryResult, int totalSize, Set ... values) {
        double[] percentages = new double[values.length];
        for (int i = 0; i < values.length; ++i) {
            Set s = values[i];
            double value = 0.0;
            for (Object o : s) {
                List<Object> key = Arrays.asList(o);
                value += (double)queryResult.get(key).intValue();
            }
            percentages[i] = value > 0.0 ? value / (double)totalSize * 100.0 : 0.0;
        }
        return percentages;
    }
}

