/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.spatial;

import org.geotools.api.filter.FilterVisitor;
import org.geotools.api.filter.MultiValuedFilter;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.filter.expression.Literal;
import org.geotools.api.filter.spatial.BBOX;
import org.geotools.api.geometry.BoundingBox;
import org.geotools.api.geometry.MismatchedDimensionException;
import org.geotools.api.referencing.FactoryException;
import org.geotools.api.referencing.NoSuchAuthorityCodeException;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.filter.AttributeExpressionImpl;
import org.geotools.filter.IllegalFilterException;
import org.geotools.filter.LiteralExpressionImpl;
import org.geotools.filter.spatial.AbstractPreparedGeometryFilter;
import org.geotools.geometry.jts.JTSFactoryFinder;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.geom.TopologyException;
import org.locationtech.jts.geom.prep.PreparedGeometry;

public class BBOXImpl
extends AbstractPreparedGeometryFilter
implements BBOX {
    static final GeometryFactory GEOMETRY_FACTORY = JTSFactoryFinder.getGeometryFactory();
    double minx;
    double miny;
    double maxx;
    double maxy;
    String srs;

    public BBOXImpl(Expression e1, Expression e2) {
        super(e1, e2);
        if (e1 != null) {
            this.setExpression1(e1);
        }
        if (e2 != null) {
            this.setExpression2(e2);
        }
    }

    public BBOXImpl(Expression name, double minx, double miny, double maxx, double maxy, String srs) {
        this(name, new LiteralExpressionImpl(BBOXImpl.boundingPolygon(new Envelope(minx, maxx, miny, maxy))));
        this.srs = srs;
    }

    public BBOXImpl(Expression e1, Expression e2, MultiValuedFilter.MatchAction matchAction) {
        super(e1, e2, matchAction);
        if (e1 != null) {
            this.setExpression1(e1);
        }
        if (e2 != null) {
            this.setExpression2(e2);
        }
    }

    public BBOXImpl(Expression name, double minx, double miny, double maxx, double maxy, String srs, MultiValuedFilter.MatchAction matchAction) {
        this(name, (Expression)new LiteralExpressionImpl(BBOXImpl.boundingPolygon(BBOXImpl.buildEnvelope(minx, maxx, miny, maxy, srs))), matchAction);
        this.srs = srs;
    }

    public void setPropertyName(String propertyName) {
        this.setExpression1(new AttributeExpressionImpl(propertyName));
    }

    @Override
    public boolean evaluateInternal(Geometry left, Geometry right) {
        switch (this.literals) {
            case BOTH: {
                return this.cacheValue;
            }
            case RIGHT: {
                return this.preppedEvaluate(this.rightPreppedGeom, left);
            }
            case LEFT: {
                return this.preppedEvaluate(this.leftPreppedGeom, right);
            }
        }
        return this.basicEvaluate(left, right);
    }

    @Override
    protected boolean basicEvaluate(Geometry left, Geometry right) {
        Envelope envLeft = left.getEnvelopeInternal();
        Envelope envRight = right.getEnvelopeInternal();
        if (envRight.intersects(envLeft)) {
            return left.intersects(right);
        }
        return false;
    }

    private boolean preppedEvaluate(PreparedGeometry prepped, Geometry other) {
        Envelope envLeft = prepped.getGeometry().getEnvelopeInternal();
        Envelope envRight = other.getEnvelopeInternal();
        if (envRight.intersects(envLeft)) {
            return prepped.intersects(other);
        }
        return false;
    }

    public Object accept(FilterVisitor visitor, Object extraData) {
        return visitor.visit((BBOX)this, extraData);
    }

    @Override
    public void setExpression1(Expression expression) {
        this.updateMinMaxFields(expression);
        super.setExpression1(expression);
    }

    @Override
    public void setExpression2(Expression expression) {
        this.updateMinMaxFields(expression);
        super.setExpression2(expression);
    }

    private void updateMinMaxFields(Expression expression) {
        if (expression instanceof Literal) {
            Literal bbox = (Literal)expression;
            Object value = bbox.getValue();
            if (value instanceof BoundingBox) {
                BoundingBox env = (BoundingBox)value;
                this.minx = env.getMinX();
                this.maxx = env.getMaxX();
                this.miny = env.getMinY();
                this.maxy = env.getMaxY();
                this.srs = CRS.toSRS(env.getCoordinateReferenceSystem());
            } else {
                Envelope env = null;
                if (value instanceof Envelope) {
                    Envelope envelope;
                    env = envelope = (Envelope)value;
                } else if (value instanceof Geometry) {
                    Geometry geom = (Geometry)value;
                    env = geom.getEnvelopeInternal();
                    if (geom.getUserData() != null) {
                        if (geom.getUserData() instanceof String) {
                            this.srs = (String)geom.getUserData();
                        } else if (geom.getUserData() instanceof CoordinateReferenceSystem) {
                            this.srs = CRS.toSRS((CoordinateReferenceSystem)geom.getUserData());
                        }
                    }
                } else {
                    env = (Envelope)bbox.evaluate(null, Envelope.class);
                }
                if (env == null) {
                    return;
                }
                this.minx = env.getMinX();
                this.maxx = env.getMaxX();
                this.miny = env.getMinY();
                this.maxy = env.getMaxY();
            }
        }
    }

    public static Polygon boundingPolygon(Envelope env) {
        Coordinate[] coords = new Coordinate[]{new Coordinate(env.getMinX(), env.getMinY()), new Coordinate(env.getMinX(), env.getMaxY()), new Coordinate(env.getMaxX(), env.getMaxY()), new Coordinate(env.getMaxX(), env.getMinY()), new Coordinate(env.getMinX(), env.getMinY())};
        LinearRing ring = null;
        try {
            ring = GEOMETRY_FACTORY.createLinearRing(coords);
        }
        catch (TopologyException tex) {
            throw new IllegalFilterException(tex.toString());
        }
        Polygon polygon = GEOMETRY_FACTORY.createPolygon(ring, null);
        if (env instanceof ReferencedEnvelope) {
            ReferencedEnvelope refEnv = (ReferencedEnvelope)env;
            polygon.setUserData((Object)refEnv.getCoordinateReferenceSystem());
        }
        return polygon;
    }

    private static ReferencedEnvelope buildEnvelope(double minx, double maxx, double miny, double maxy, String srs) {
        CoordinateReferenceSystem crs = null;
        if (srs != null && !"".equals(srs)) {
            try {
                try {
                    crs = CRS.decode(srs);
                }
                catch (MismatchedDimensionException e) {
                    throw new RuntimeException(e);
                }
                catch (NoSuchAuthorityCodeException e) {
                    CRS.parseWKT(srs);
                }
            }
            catch (FactoryException factoryException) {
                // empty catch block
            }
        }
        return new ReferencedEnvelope(minx, maxx, miny, maxy, crs);
    }

    public BoundingBox getBounds() {
        Object value = ((Literal)this.getExpression2()).getValue();
        if (value instanceof BoundingBox) {
            BoundingBox box = (BoundingBox)value;
            return box;
        }
        return BBOXImpl.buildEnvelope(this.minx, this.maxx, this.miny, this.maxy, this.srs);
    }
}

