/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.visitor;

import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.filter.FilterFactory;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.filter.expression.ExpressionVisitor;
import org.geotools.api.filter.expression.Function;
import org.geotools.api.filter.expression.Literal;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.filter.FilterAttributeExtractor;
import org.geotools.filter.FilterCapabilities;
import org.geotools.filter.function.JsonPointerFunction;
import org.geotools.filter.visitor.ClientTransactionAccessor;
import org.geotools.filter.visitor.DuplicatingFilterVisitor;
import org.geotools.filter.visitor.PostPreProcessFilterSplittingVisitor;

public class JsonPointerFilterSplittingVisitor
extends PostPreProcessFilterSplittingVisitor {
    public JsonPointerFilterSplittingVisitor(FilterCapabilities fcs, SimpleFeatureType parent, ClientTransactionAccessor transactionAccessor) {
        super(fcs, parent, transactionAccessor);
    }

    @Override
    public Object visit(Function expression, Object notUsed) {
        Expression param;
        if (expression instanceof JsonPointerFunction && !((param = (Expression)expression.getParameters().get(1)) instanceof Literal)) {
            expression = this.constantParameterToLiteral(expression, param, 1);
        }
        return super.visit(expression, notUsed);
    }

    @Override
    protected boolean supports(Object value) {
        if (value instanceof JsonPointerFunction) {
            JsonPointerFunction function = (JsonPointerFunction)value;
            Expression param = function.getParameters().get(1);
            return param instanceof Literal;
        }
        return super.supports(value);
    }

    private Function constantParameterToLiteral(Function expression, Expression param, int paramIdx) {
        FilterAttributeExtractor extractor = new FilterAttributeExtractor();
        param.accept((ExpressionVisitor)extractor, null);
        if (extractor.isConstantExpression()) {
            DuplicatingFilterVisitor duplicating = new DuplicatingFilterVisitor();
            Function duplicated = (Function)expression.accept((ExpressionVisitor)duplicating, null);
            Object result = param.evaluate(null);
            FilterFactory ff = CommonFactoryFinder.getFilterFactory();
            duplicated.getParameters().set(paramIdx, ff.literal(result));
            return duplicated;
        }
        return expression;
    }
}

