/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.geometry.jts;

import java.util.List;
import org.geotools.geometry.jts.CircularRing;
import org.geotools.geometry.jts.CompoundCurve;
import org.geotools.geometry.jts.CompoundCurvedGeometry;
import org.geotools.geometry.jts.CurvedRing;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateFilter;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.CoordinateSequenceComparator;
import org.locationtech.jts.geom.CoordinateSequenceFilter;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryComponentFilter;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.GeometryFilter;
import org.locationtech.jts.geom.IntersectionMatrix;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.PrecisionModel;

public class CompoundRing
extends LinearRing
implements CompoundCurvedGeometry<LinearRing>,
CurvedRing {
    private static final long serialVersionUID = -5796254063449438787L;
    CompoundCurve delegate;
    LineString linearized;

    public CompoundRing(List<LineString> components, GeometryFactory factory, double tolerance) {
        this(new CompoundCurve(components, factory, tolerance));
    }

    public CompoundRing(CompoundCurve delegate) {
        super(CircularRing.FAKE_RING_2D, delegate.getFactory());
        this.delegate = delegate;
        if (!delegate.isClosed()) {
            throw new IllegalArgumentException("The components do not form a closed ring");
        }
    }

    @Override
    public double getTolerance() {
        return this.delegate.getTolerance();
    }

    @Override
    public List<LineString> getComponents() {
        return this.delegate.components;
    }

    @Override
    public int getCoordinatesDimension() {
        return this.delegate.getCoordinatesDimension();
    }

    @Override
    public LinearRing linearize() {
        CoordinateSequence cs = this.delegate.getLinearizedCoordinateSequence(this.delegate.tolerance);
        return this.getFactory().createLinearRing(cs);
    }

    @Override
    public LinearRing linearize(double tolerance) {
        CoordinateSequence cs = this.delegate.getLinearizedCoordinateSequence(tolerance);
        return this.getFactory().createLinearRing(cs);
    }

    public boolean isClosed() {
        return true;
    }

    public int getDimension() {
        return super.getDimension();
    }

    public int getBoundaryDimension() {
        return super.getDimension();
    }

    public boolean isEmpty() {
        return false;
    }

    public String getGeometryType() {
        return "CompoundRing";
    }

    public CompoundRing reverse() {
        return (CompoundRing)super.reverse();
    }

    public CompoundRing reverseInternal() {
        CompoundCurve reversedDelegate = this.delegate.reverse();
        return new CompoundRing(reversedDelegate);
    }

    public int getNumGeometries() {
        return this.delegate.getNumGeometries();
    }

    public Geometry getGeometryN(int n) {
        return this.delegate.getGeometryN(n);
    }

    public void setUserData(Object userData) {
        super.setUserData(userData);
    }

    public int getSRID() {
        return super.getSRID();
    }

    public void setSRID(int SRID) {
        super.setSRID(SRID);
    }

    public GeometryFactory getFactory() {
        return super.getFactory();
    }

    public Object getUserData() {
        return super.getUserData();
    }

    public PrecisionModel getPrecisionModel() {
        return super.getPrecisionModel();
    }

    public boolean isRectangle() {
        return this.delegate.isRectangle();
    }

    public Point getInteriorPoint() {
        return this.delegate.getInteriorPoint();
    }

    public Geometry getEnvelope() {
        return this.delegate.getEnvelope();
    }

    public Envelope getEnvelopeInternal() {
        return this.delegate.getEnvelopeInternal();
    }

    protected Envelope computeEnvelopeInternal() {
        return this.delegate.getEnvelopeInternal();
    }

    public boolean equalsExact(Geometry other) {
        return this.delegate.equalsExact(other);
    }

    public boolean equalsExact(Geometry other, double tolerance) {
        if (other instanceof CompoundRing) {
            CompoundRing csOther = (CompoundRing)other;
            return this.delegate.equalsExact((Geometry)csOther.delegate, tolerance);
        }
        return this.linearize(tolerance).equalsExact(other, tolerance);
    }

    public boolean equals(Geometry other) {
        if (other instanceof CompoundRing) {
            CompoundRing csOther = (CompoundRing)other;
            return this.delegate.equals((Geometry)csOther.delegate);
        }
        return this.linearize().equals(other);
    }

    public boolean equalsTopo(Geometry other) {
        if (other instanceof CompoundRing) {
            CompoundRing csOther = (CompoundRing)other;
            return this.delegate.equalsTopo((Geometry)csOther.delegate);
        }
        return this.linearize().equalsTopo(other);
    }

    public boolean equals(Object o) {
        if (o instanceof Geometry) {
            Geometry geometry = (Geometry)o;
            return this.equals(geometry);
        }
        return false;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public String toString() {
        return this.toCurvedText();
    }

    @Override
    public String toCurvedText() {
        return this.delegate.toCurvedText();
    }

    public boolean equalsNorm(Geometry g) {
        return super.equalsNorm(g);
    }

    public Point getPointN(int n) {
        if (n == 0) {
            return this.getStartPoint();
        }
        return this.linearize().getPointN(n);
    }

    public Point getStartPoint() {
        return this.delegate.getStartPoint();
    }

    public Point getEndPoint() {
        return this.delegate.getEndPoint();
    }

    public Coordinate[] getCoordinates() {
        return this.linearize().getCoordinates();
    }

    public CoordinateSequence getCoordinateSequence() {
        if (this.delegate != null) {
            return this.linearize().getCoordinateSequence();
        }
        return super.getCoordinateSequence();
    }

    public Coordinate getCoordinateN(int n) {
        if (this.delegate != null) {
            return this.linearize().getCoordinateN(n);
        }
        return super.getCoordinateN(n);
    }

    public Coordinate getCoordinate() {
        return this.linearize().getCoordinate();
    }

    public int getNumPoints() {
        if (this.delegate != null) {
            return this.linearize().getNumPoints();
        }
        return super.getNumPoints();
    }

    public boolean isRing() {
        return this.linearize().isRing();
    }

    public double getLength() {
        return this.linearize().getLength();
    }

    public Geometry getBoundary() {
        return this.linearize().getBoundary();
    }

    public boolean isCoordinate(Coordinate pt) {
        return this.linearize().isCoordinate(pt);
    }

    public void apply(CoordinateFilter filter) {
        this.linearize().apply(filter);
    }

    public void apply(CoordinateSequenceFilter filter) {
        this.linearize().apply(filter);
    }

    public void apply(GeometryFilter filter) {
        this.linearize().apply(filter);
    }

    public void apply(GeometryComponentFilter filter) {
        this.linearize().apply(filter);
    }

    public CompoundRing copyInternal() {
        return new CompoundRing(this.delegate);
    }

    public void normalize() {
        this.linearize().normalize();
    }

    public boolean isSimple() {
        return this.linearize().isSimple();
    }

    public boolean isValid() {
        return this.linearize().isValid();
    }

    public double distance(Geometry g) {
        return this.linearize().distance(g);
    }

    public boolean isWithinDistance(Geometry geom, double distance) {
        return this.linearize().isWithinDistance(geom, distance);
    }

    public double getArea() {
        return this.linearize().getArea();
    }

    public Point getCentroid() {
        return this.linearize().getCentroid();
    }

    public void geometryChanged() {
        this.linearize().geometryChanged();
    }

    public boolean disjoint(Geometry g) {
        return this.linearize().disjoint(g);
    }

    public boolean touches(Geometry g) {
        return this.linearize().touches(g);
    }

    public boolean intersects(Geometry g) {
        return this.linearize().intersects(g);
    }

    public boolean crosses(Geometry g) {
        return this.linearize().crosses(g);
    }

    public boolean within(Geometry g) {
        return this.linearize().within(g);
    }

    public boolean contains(Geometry g) {
        return this.linearize().contains(g);
    }

    public boolean overlaps(Geometry g) {
        return this.linearize().overlaps(g);
    }

    public boolean covers(Geometry g) {
        return this.linearize().covers(g);
    }

    public boolean coveredBy(Geometry g) {
        return this.linearize().coveredBy(g);
    }

    public boolean relate(Geometry g, String intersectionPattern) {
        return this.linearize().relate(g, intersectionPattern);
    }

    public IntersectionMatrix relate(Geometry g) {
        return this.linearize().relate(g);
    }

    public Geometry buffer(double distance) {
        return this.linearize().buffer(distance);
    }

    public Geometry buffer(double distance, int quadrantSegments) {
        return this.linearize().buffer(distance, quadrantSegments);
    }

    public Geometry buffer(double distance, int quadrantSegments, int endCapStyle) {
        return this.linearize().buffer(distance, quadrantSegments, endCapStyle);
    }

    public Geometry convexHull() {
        return this.linearize().convexHull();
    }

    public Geometry intersection(Geometry other) {
        return this.linearize().intersection(other);
    }

    public Geometry union(Geometry other) {
        return this.linearize().union(other);
    }

    public Geometry difference(Geometry other) {
        return this.linearize().difference(other);
    }

    public Geometry symDifference(Geometry other) {
        return this.linearize().symDifference(other);
    }

    public Geometry union() {
        return this.linearize().union();
    }

    public Geometry norm() {
        return this.linearize().norm();
    }

    public int compareTo(Object o) {
        return this.linearize().compareTo(o);
    }

    public int compareTo(Object o, CoordinateSequenceComparator comp) {
        return this.linearize().compareTo(o, comp);
    }

    public String toText() {
        return this.linearize().toText();
    }
}

