/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.geometry.jts;

import java.util.ArrayList;
import java.util.List;
import org.geotools.geometry.jts.CircularRing;
import org.geotools.geometry.jts.CircularString;
import org.geotools.geometry.jts.CompoundCurve;
import org.geotools.geometry.jts.CompoundCurvedGeometry;
import org.geotools.geometry.jts.CompoundRing;
import org.geotools.geometry.jts.LiteCoordinateSequenceFactory;
import org.geotools.geometry.jts.SingleCurvedGeometry;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.CoordinateSequenceFactory;
import org.locationtech.jts.geom.CoordinateXY;
import org.locationtech.jts.geom.CoordinateXYM;
import org.locationtech.jts.geom.CoordinateXYZM;
import org.locationtech.jts.geom.Coordinates;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.geom.impl.PackedCoordinateSequence;

public class LiteCoordinateSequence
extends PackedCoordinateSequence
implements Cloneable {
    private static final GeometryFactory geomFac = new GeometryFactory((CoordinateSequenceFactory)new LiteCoordinateSequenceFactory());
    private double[] coords;
    private int size;

    public LiteCoordinateSequence(double[] coords, int dimensions) {
        this(coords, dimensions, 0);
    }

    public LiteCoordinateSequence(double[] coords, int dimensions, int measures) {
        super(dimensions, measures);
        this.init(coords, dimensions);
    }

    void init(double[] coords, int dimensions) {
        this.dimension = dimensions;
        if (dimensions < 2) {
            throw new IllegalArgumentException("Invalid dimensions, must be at least 2");
        }
        if (coords.length % this.dimension != 0) {
            throw new IllegalArgumentException("Packed array does not contain an integral number of coordinates");
        }
        this.coords = coords;
        this.size = coords.length / dimensions;
    }

    public LiteCoordinateSequence(double ... coords) {
        this(coords, 2, 0);
    }

    public LiteCoordinateSequence(float[] coordinates, int dimension) {
        super(dimension, 0);
        double[] dcoords = new double[coordinates.length];
        for (int i = 0; i < coordinates.length; ++i) {
            dcoords[i] = coordinates[i];
        }
        this.init(dcoords, dimension);
    }

    public LiteCoordinateSequence(float[] coordinates) {
        this(coordinates, 2);
    }

    public LiteCoordinateSequence(Coordinate ... coordinates) {
        super(2, 0);
        if (coordinates != null && coordinates.length != 0) {
            this.dimension = Coordinates.dimension((Coordinate)coordinates[0]);
            this.measures = Coordinates.measures((Coordinate)coordinates[0]);
            this.coords = new double[coordinates.length * this.dimension];
            for (int i = 0; i < coordinates.length; ++i) {
                this.coords[i * this.dimension] = coordinates[i].x;
                this.coords[i * this.dimension + 1] = coordinates[i].y;
                if (this.dimension == 4) {
                    this.coords[i * this.dimension + 2] = coordinates[i].getZ();
                    this.coords[i * this.dimension + 3] = coordinates[i].getM();
                    continue;
                }
                if (this.dimension == 3 && this.measures == 1) {
                    this.coords[i * this.dimension + 2] = coordinates[i].getM();
                    continue;
                }
                if (this.dimension != 3 || this.measures != 0) continue;
                this.coords[i * this.dimension + 2] = coordinates[i].getZ();
            }
            this.size = coordinates.length;
        } else {
            this.size = 0;
            this.coords = new double[0];
        }
    }

    public LiteCoordinateSequence(int size, int dimension) {
        this(size, dimension, 0);
    }

    public LiteCoordinateSequence(int size, int dimension, int measures) {
        super(dimension, measures);
        this.coords = new double[size * this.dimension];
        this.size = this.coords.length / dimension;
    }

    public LiteCoordinateSequence(LiteCoordinateSequence seq) {
        super(seq.getDimension(), seq.getMeasures());
        this.dimension = seq.dimension;
        this.size = seq.size;
        double[] orig = seq.getArray();
        this.coords = new double[orig.length];
        System.arraycopy(orig, 0, this.coords, 0, this.coords.length);
    }

    public LiteCoordinateSequence(CoordinateSequence cs, int dimension) {
        this(cs, dimension, 0);
    }

    /*
     * Enabled aggressive block sorting
     */
    public LiteCoordinateSequence(CoordinateSequence cs, int dimension, int measures) {
        super(dimension, measures);
        this.size = cs.size();
        this.dimension = dimension;
        if (cs instanceof LiteCoordinateSequence) {
            LiteCoordinateSequence sequence = (LiteCoordinateSequence)cs;
            if (cs.getMeasures() == measures) {
                double[] orig = sequence.getOrdinateArray(dimension, measures);
                this.coords = new double[orig.length];
                System.arraycopy(orig, 0, this.coords, 0, this.coords.length);
                return;
            }
        }
        this.coords = new double[this.size * dimension];
        int minDimension = Math.min(dimension, cs.getDimension());
        int i = 0;
        while (i < this.size) {
            for (int j = 0; j < minDimension; ++j) {
                this.coords[i * dimension + j] = cs.getOrdinate(i, j);
            }
            ++i;
        }
    }

    public Coordinate getCoordinateInternal(int i) {
        double x = this.coords[i * this.dimension];
        double y = this.coords[i * this.dimension + 1];
        if (this.dimension == 2 && this.measures == 0) {
            return new CoordinateXY(x, y);
        }
        if (this.dimension == 3 && this.measures == 0) {
            double z = this.coords[i * this.dimension + 2];
            return new Coordinate(x, y, z);
        }
        if (this.dimension == 3 && this.measures == 1) {
            double m = this.coords[i * this.dimension + 2];
            return new CoordinateXYM(x, y, m);
        }
        if (this.dimension == 4) {
            double z = this.coords[i * this.dimension + 2];
            double m = this.coords[i * this.dimension + 3];
            return new CoordinateXYZM(x, y, z, m);
        }
        return new Coordinate(x, y);
    }

    public int size() {
        return this.size;
    }

    public Object clone() {
        double[] clone = new double[this.coords.length];
        System.arraycopy(this.coords, 0, clone, 0, this.coords.length);
        return new LiteCoordinateSequence(clone, this.dimension);
    }

    public PackedCoordinateSequence copy() {
        return (PackedCoordinateSequence)this.clone();
    }

    public double getOrdinate(int index, int ordinate) {
        return this.coords[index * this.dimension + ordinate];
    }

    public double getX(int index) {
        return this.coords[index * this.dimension];
    }

    public double getY(int index) {
        return this.coords[index * this.dimension + 1];
    }

    public void setOrdinate(int index, int ordinate, double value) {
        this.coordRef = null;
        this.coords[index * this.dimension + ordinate] = value;
    }

    public Envelope expandEnvelope(Envelope env) {
        double miny;
        double minx;
        double maxx = minx = this.coords[0];
        double maxy = miny = this.coords[1];
        for (int i = 0; i < this.coords.length; i += this.dimension) {
            double x = this.coords[i];
            if (x < minx) {
                minx = x;
            } else if (x > maxx) {
                maxx = x;
            }
            double y = this.coords[i + 1];
            if (y < miny) {
                miny = y;
                continue;
            }
            if (!(y > maxy)) continue;
            maxy = y;
        }
        env.expandToInclude(minx, miny);
        env.expandToInclude(maxx, maxy);
        return env;
    }

    public double[] getArray() {
        return this.coords;
    }

    public void setArray(double[] coords2) {
        this.init(coords2, this.dimension);
        this.coordRef = null;
    }

    public void setArray(double[] coords2, int dimension) {
        this.init(coords2, dimension);
        this.coordRef = null;
    }

    public double[] getXYArray() {
        if (this.dimension == 2) {
            return this.coords;
        }
        int n = this.size();
        double[] result = new double[n * 2];
        for (int t = 0; t < n; ++t) {
            result[t * 2] = this.getOrdinate(t, 0);
            result[t * 2 + 1] = this.getOrdinate(t, 1);
        }
        return result;
    }

    public double[] getOrdinateArray(int dimensions, int measures) {
        if (dimensions == this.dimension && measures == this.measures) {
            return this.coords;
        }
        int n = this.size();
        double[] result = new double[n * dimensions];
        int minDimensions = Math.min(dimensions, this.dimension);
        int minMeasures = Math.min(measures, this.measures);
        for (int t = 0; t < n; ++t) {
            for (int d = 0; d < minDimensions; ++d) {
                result[t * 2 + d] = this.getOrdinate(t, d);
            }
            for (int m = 0; m < minMeasures; ++m) {
                result[t * 2 + minDimensions + m] = this.getOrdinate(t, minDimensions + m);
            }
        }
        return result;
    }

    public double[] getOrdinateArray(int dimensions) {
        if (dimensions == this.dimension && this.measures == 0) {
            return this.coords;
        }
        int n = this.size();
        double[] result = new double[n * dimensions];
        int minDimensions = Math.min(dimensions, this.dimension);
        for (int t = 0; t < n; ++t) {
            for (int d = 0; d < minDimensions; ++d) {
                result[t * 2 + d] = this.getOrdinate(t, d);
            }
        }
        return result;
    }

    public static Geometry cloneGeometry(Geometry geom, int dimension) {
        if (dimension < 2) {
            throw new IllegalArgumentException("Invalid dimension value, must be >= 2");
        }
        if (geom == null) {
            return null;
        }
        if (geom instanceof LineString) {
            LineString string = (LineString)geom;
            return LiteCoordinateSequence.cloneGeometry(string, dimension);
        }
        if (geom instanceof Polygon) {
            Polygon polygon = (Polygon)geom;
            return LiteCoordinateSequence.cloneGeometry(polygon, dimension);
        }
        if (geom instanceof Point) {
            Point point = (Point)geom;
            return LiteCoordinateSequence.cloneGeometry(point, dimension);
        }
        return LiteCoordinateSequence.cloneGeometry((GeometryCollection)geom, dimension);
    }

    public static final Geometry cloneGeometry(Geometry geom) {
        return LiteCoordinateSequence.cloneGeometry(geom, 2);
    }

    private static final Geometry cloneGeometry(Polygon geom, int dimension) {
        LinearRing lr = (LinearRing)LiteCoordinateSequence.cloneGeometry(geom.getExteriorRing(), dimension);
        LinearRing[] rings = new LinearRing[geom.getNumInteriorRing()];
        for (int t = 0; t < rings.length; ++t) {
            rings[t] = (LinearRing)LiteCoordinateSequence.cloneGeometry(geom.getInteriorRingN(t), dimension);
        }
        return geomFac.createPolygon(lr, rings);
    }

    private static final Geometry cloneGeometry(Point geom, int dimension) {
        return geomFac.createPoint((CoordinateSequence)new LiteCoordinateSequence(geom.getCoordinateSequence(), dimension));
    }

    private static final Geometry cloneGeometry(LineString geom, int dimension) {
        if (geom instanceof SingleCurvedGeometry) {
            SingleCurvedGeometry curved = (SingleCurvedGeometry)geom;
            double[] controlPoints = curved.getControlPoints();
            double[] clonedPoints = new double[controlPoints.length];
            System.arraycopy(controlPoints, 0, clonedPoints, 0, controlPoints.length);
            return new CircularString(clonedPoints, geomFac, curved.getTolerance());
        }
        if (geom instanceof CompoundCurvedGeometry) {
            CompoundCurvedGeometry curved = (CompoundCurvedGeometry)geom;
            List<LineString> components = curved.getComponents();
            ArrayList<LineString> clonedComponents = new ArrayList<LineString>(components.size());
            for (LineString ls : components) {
                LineString cloned = (LineString)LiteCoordinateSequence.cloneGeometry(ls, dimension);
                clonedComponents.add(cloned);
            }
            return new CompoundCurve(clonedComponents, geomFac, dimension);
        }
        return geomFac.createLineString((CoordinateSequence)new LiteCoordinateSequence(geom.getCoordinateSequence(), dimension));
    }

    private static final Geometry cloneGeometry(LinearRing geom, int dimension) {
        if (geom instanceof SingleCurvedGeometry) {
            SingleCurvedGeometry curved = (SingleCurvedGeometry)geom;
            double[] controlPoints = curved.getControlPoints();
            double[] clonedPoints = new double[controlPoints.length];
            System.arraycopy(controlPoints, 0, clonedPoints, 0, controlPoints.length);
            return new CircularRing(clonedPoints, geomFac, curved.getTolerance());
        }
        if (geom instanceof CompoundCurvedGeometry) {
            CompoundCurvedGeometry curved = (CompoundCurvedGeometry)geom;
            List<LineString> components = curved.getComponents();
            ArrayList<LineString> clonedComponents = new ArrayList<LineString>(components.size());
            for (LineString ls : components) {
                LineString cloned = (LineString)LiteCoordinateSequence.cloneGeometry(ls, dimension);
                clonedComponents.add(cloned);
            }
            return new CompoundRing(clonedComponents, geomFac, dimension);
        }
        return geomFac.createLinearRing((CoordinateSequence)new LiteCoordinateSequence(geom.getCoordinateSequence(), dimension));
    }

    private static final Geometry cloneGeometry(GeometryCollection geom, int dimension) {
        if (geom.getNumGeometries() == 0) {
            Geometry[] gs = new Geometry[]{};
            return geomFac.createGeometryCollection(gs);
        }
        ArrayList<Geometry> gs = new ArrayList<Geometry>(geom.getNumGeometries());
        int n = geom.getNumGeometries();
        for (int t = 0; t < n; ++t) {
            gs.add(LiteCoordinateSequence.cloneGeometry(geom.getGeometryN(t), dimension));
        }
        return geomFac.buildGeometry(gs);
    }

    public String toString() {
        if (this.size > 0) {
            StringBuffer strBuf = new StringBuffer(9 * this.dimension * this.size);
            strBuf.append('(');
            for (int i = 0; i < this.size; ++i) {
                for (int j = 0; j < this.dimension; ++j) {
                    strBuf.append(this.coords[i * this.dimension + j]);
                    if (j >= this.dimension - 1) continue;
                    strBuf.append(" ");
                }
                if (i >= this.size - 1) continue;
                strBuf.append(", ");
            }
            strBuf.append(')');
            return strBuf.toString();
        }
        return "()";
    }
}

